<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

namespace CE;

defined('_PS_VERSION_') or die;

class Post
{
    private $id;
    private $uid;
    private $model;

    public $_obj;

    public $post_author = 0;
    public $post_date = '';
    public $post_modified = '';
    public $post_title = '';
    public $post_excerpt = '';
    public $post_content = '';
    public $template_type;

    private function __construct()
    {
    }

    public function __get($prop)
    {
        switch ($prop) {
            case 'uid':
                $val = $this->uid;
                break;
            case 'ID':
            case 'post_ID':
                $val = $this->id;
                break;
            case 'post_type':
                $val = $this->model;
                break;
            case 'post_status':
                $active = property_exists($this->_obj, 'active') ? 'active' : 'actif';
                $val = $this->_obj->$active ? 'publish' : 'draft';
                break;
            default:
                throw new \RuntimeException('TODO');
                break;
        }
        return $val;
    }

    public function __set($prop, $val)
    {
        switch ($prop) {
            case 'ID':
            case 'post_ID':
                // allow change only when starts with zero
                empty($this->id[0]) && $this->id = "$val";
                break;
            case 'post_type':
                // readonly
                break;
            case 'post_status':
                $active = property_exists($this->_obj, 'active') ? 'active' : 'actif';
                $this->_obj->$active = 'publish' == $val;
                break;
            default:
                throw new \RuntimeException('TODO');
                break;
        }
    }

    public function getLangId()
    {
        return (int) \Tools::substr($this->id, -4, 2);
    }

    public static function getInstance(UId $uid)
    {
        $self = new self();
        $self->id = "$uid";
        $self->uid = $uid;
        $self->model = $uid->getModel();
        $objectModel = '\\' . $self->model;

        switch ($uid->id_type) {
            case UId::TEMPLATE:
                $obj = new $objectModel($uid->id ? $uid->id : null);

                $self->template_type = &$obj->type;
                break;
            case UId::PRODUCT:
                $obj = new $objectModel($uid->id, false, $uid->id_lang, $uid->id_shop);
                break;
            default:
                $obj = new $objectModel($uid->id, $uid->id_lang, $uid->id_shop);
                break;
        }
        $self->_obj = $obj;

        property_exists($obj, 'id_employee') && $self->post_author = &$obj->id_employee;
        property_exists($obj, 'date_add') && $self->post_date = &$obj->date_add;
        property_exists($obj, 'date_upd') && $self->post_modified = &$obj->date_upd;
        property_exists($obj, 'title')
            ? $self->post_title = &$obj->title
            : property_exists($obj, 'meta_title') && $self->post_title = &$obj->meta_title
        ;
        if (property_exists($obj, 'content')) {
            $self->post_content = &$obj->content;
        } elseif (property_exists($obj, 'description')) {
            $self->post_content = &$obj->description;
        } elseif (property_exists($obj, 'post_content')) {
            $self->post_content = &$obj->post_content;
        }
        return $self;
    }
}

function get_post($post = null, $output = 'OBJECT', $filter = 'raw')
{
    is_null($post) && $post = get_the_ID();

    if (false === $post || $post instanceof Post) {
        $_post = $post;
    } elseif ($post instanceof UId) {
        $_post = Post::getInstance($post);
    } elseif (is_numeric($post)) {
        $_post = Post::getInstance(UId::parse($post));
    } else {
        _doing_it_wrong(__CLASS__ . '::' . __FUNCTION__, 'Invalid $post argument!');
    }

    if (!$_post) {
        return null;
    }
    if ('OBJECT' != $output) {
        throw new \RuntimeException('todo');
    }
    return $_post;
}

function wp_update_post($postarr = array(), $wp_error = false)
{
    if (!is_array($postarr) || $wp_error) {
        throw new \RuntimeException('TODO');
    }
    if (empty($postarr['ID'])) {
        _doing_it_wrong(__FUNCTION__, 'ID is missing!');
    }
    $post = get_post($postarr['ID']);

    foreach ($postarr as $key => $value) {
        $post->{$key} = $value;
    }
    try {
        // Fix: category groups would lose after save
        if ($post->_obj instanceof \Category) {
            $post->_obj->groupBox = $post->_obj->getGroups();
        }
        $res = $post->_obj->update();
    } catch (\Exception $ex) {
        $res = false;
    }
    return $res ? $post->ID : 0;
}

function wp_insert_post($postarr, $wp_error = false)
{
    if (!is_array($postarr) || $wp_error || 'elementor_library' != $postarr['post_type']) {
        throw new \RuntimeException('TODO');
    }
    $uid = new UId(0, UId::TEMPLATE);
    $post = Post::getInstance($uid);
    $postarr['post_author'] = \Context::getContext()->employee->id;

    foreach ($postarr as $key => &$value) {
        $post->$key = $value;
    }
    if ($post->_obj->add()) {
        $uid->id = $post->_obj->id;
        $post->ID = "$uid";
    } else {
        $post->ID = 0;
    }
    return $post->ID;
}

function wp_delete_post($postid, $force_delete = false)
{
    $post = get_post($postid);

    return $post->_obj->delete() || $force_delete ? $post : false;
}

function get_post_meta($id, $key = '', $single = false)
{
    if (false === $id) {
        return $id;
    }
    $table = _DB_PREFIX_ . 'ce_meta';
    $id = preg_replace('/\D+/', '', $id);
    $key = preg_replace('/\W+/', '', $key);

    if (!is_numeric($id)) {
        _doing_it_wrong(__FUNCTION__, 'Id must be numeric!');
    }
    if (!$single) {
        throw new \RuntimeException('TODO');
    }
    $res = \Db::getInstance()->getValue("SELECT value FROM $table WHERE id = $id AND name = '$key'");

    return isset($res[0]) && ('{' == $res[0] || '[' == $res[0] || '"' == $res[0]) ? json_decode($res, true) : $res;
}

function update_post_meta($id, $key, $value, $prev_value = '')
{
    if ($prev_value) {
        throw new \RuntimeException('TODO');
    }
    $db = \Db::getInstance();
    $table = _DB_PREFIX_ . 'ce_meta';
    $res = true;
    $ids = ($uid = UId::parse($id)) ? $uid->getShopContextList() : (array) $id;
    $data = array(
        'name' => preg_replace('/\W+/', '', $key),
        'value' => $db->escape(is_array($value) || is_object($value) ? json_encode($value) : $value, true),
    );
    foreach ($ids as $id) {
        $data['id'] = preg_replace('/\D+/', '', $id);
        $id_ce_meta = $db->getValue("SELECT id_ce_meta FROM $table WHERE id = {$data['id']} AND name = '{$data['name']}'");

        if ($id_ce_meta) {
            $data['id_ce_meta'] = (int) $id_ce_meta;
            $type = \Db::REPLACE;
        } else {
            unset($data['id_ce_meta']);
            $type = \Db::INSERT;
        }
        $res &= $db->insert($table, $data, false, true, $type, false);
    }
    return $res;
}

function delete_post_meta($id, $key, $value = '')
{
    if ($value) {
        throw new \RuntimeException('TODO');
    }
    $ids = ($uid = UId::parse($id)) ? $uid->getShopContextList() : (array) $id;

    foreach ($ids as &$id) {
        $id = preg_replace('/\D+/', '', $id);
    }
    if (count($ids) > 1) {
        $in = 'IN';
        $ids = '(' . implode(', ', $ids) . ')';
    } else {
        $in = '=';
        $ids = $ids[0];
    }
    $key = preg_replace('/[^\w\%]+/', '', $key);
    $like = stripos($key, '%') === false ? '=' : 'LIKE';

    return \Db::getInstance()->delete('ce_meta', "id $in $ids AND name $like '$key'");
}

function get_post_type($post = null)
{
    is_null($post) && $post = get_the_ID();

    if ($post instanceof Post) {
        return UId::parse($post->ID)->getModel();
    } elseif ($post instanceof UId) {
        return $post->getModel();
    } elseif (is_numeric($post)) {
        return UId::parse($post)->getModel();
    }
    return false;
}

function get_post_type_object($post_type)
{
    // todo
    return !$post_type ? null : (object) array(
        'cap' => (object) array(
            'edit_post' => 'edit',
        ),
    );
}

function current_user_can($capability, $post_id)
{
    $context = \Context::getContext();

    if (empty($context->employee->id_profile)) {
        return false;
    }

    if (!$post_id instanceof UId) {
        $post_id = UId::parse($post_id);
    }
    $controller = $post_id->getAdminController();

    if ('AdminModules' === $controller) {
        $id_module = \Module::getModuleIdByName($post_id->getModule());
        $action = 'view' === $capability ? $capability : 'configure';
        $result = \Module::getPermissionStatic($id_module, $action, $context->employee);
    } else {
        $id_tab = \Tab::getIdFromClassName($controller);
        $access = \Profile::getProfileAccess($context->employee->id_profile, $id_tab);
        $result = '1' === $access[$capability];
    }
    return $result;
}
