<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A Color Picker control.
 *
 * @param string $default    A color, in rgb|rgba|hex format.
 *                           Default empty
 * @param bool   $alpha      Whether to allow set the alpha channel
 *                           Default true
 * @since 1.0.0
 */
class ControlColor extends ControlBase
{
    public function getType()
    {
        return 'color';
    }

    public function enqueue()
    {
        $suffix = defined('_PS_MODE_DEV_') && _PS_MODE_DEV_ ? '' : '.min';

        wp_enqueue_style('wp-color-picker', _CE_ASSETS_URL_ . 'lib/wp-color-picker/wp-color-picker.min.css', array(), '1.0.7');

        wp_register_script('iris', _CE_ASSETS_URL_ . 'lib/iris/iris.min.js', array('jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch'), '1.0.7', 1);
        wp_register_script('wp-color-picker', _CE_ASSETS_URL_ . 'lib/wp-color-picker/wp-color-picker.min.js', array('iris'), false, true);

        wp_localize_script(
            'wp-color-picker',
            'wpColorPickerL10n',
            array(
                'clear' => __('Clear', 'elementor'),
                'defaultString' => __('Default', 'elementor'),
                'pick' => __('Select Color', 'elementor'),
                'current' => __('Current Color', 'elementor'),
            )
        );

        wp_register_script(
            'wp-color-picker-alpha',
            _CE_ASSETS_URL_ . 'lib/wp-color-picker/wp-color-picker-alpha' . $suffix . '.js',
            array(
                'wp-color-picker',
            ),
            '1.1',
            true
        );

        wp_enqueue_script('wp-color-picker-alpha');
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlColor');
    }

    protected function getDefaultSettings()
    {
        return array(
            'alpha' => true,
        );
    }
}
