<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A Media Chooser control. Based on the Responsive File Manager
 *
 * @param array  $default {
 *         @type string  $url   Default empty
 *         @type integer $id    Default empty
 * }
 *
 * @since 1.0.0
 */
class ControlMedia extends ControlBaseMultiple
{
    public function getType()
    {
        return 'media';
    }

    public function getDefaultValue()
    {
        return array(
            'url' => '',
            'id' => '',
        );
    }

    public function onImport(&$settings)
    {
        if (!empty($settings['url'])) {
            $settings = Plugin::instance()->templates_manager->getImportImagesInstance()->import($settings);

            if (!$settings) {
                $settings = array(
                    'id' => 0,
                    'url' => Utils::getPlaceholderImageSrc(),
                );
            }
        }

        return $settings;
    }

    public function onExport(&$settings)
    {
        if (!empty($settings['url'])) {
            $settings['url'] = Helper::getMediaLink($settings['url'], true);
        }

        return $settings;
    }

    public function enqueue()
    {
        wp_enqueue_style('jquery-fancybox', _PS_JS_DIR_ . 'jquery/plugins/fancybox/jquery.fancybox.css');

        wp_enqueue_script('jquery-fancybox', _PS_JS_DIR_ . 'jquery/plugins/fancybox/jquery.fancybox.js', array('jquery'), false, true);
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlMedia');
    }

    protected function getDefaultSettings()
    {
        return array(
            'label_block' => true,
        );
    }
}
