<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * An 'Order By' select box control.
 *
 * @param array $default {
 *      @type string $order_by      The selected order
 *                                  Default empty
 *      @type string $reverse_order Whether to reverse the order
 *                                  Default empty
 * }
 *
 * @param array $options      Array of key & value pairs: `[ 'key' => 'value', ... ]`
 *                            Default empty
 *
 * @since 1.0.0
 */
class ControlOrder extends ControlBaseMultiple
{
    public function getType()
    {
        return 'order';
    }

    public function getDefaultValue()
    {
        return array(
            'order_by' => '',
            'reverse_order' => '',
        );
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlOrder');
    }
}
