<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A draggable Range Slider control.
 *
 * @param array  $default    {
 *         @type integer $size     The initial value of slider
 *                                 Default empty
 * }
 *
 * @since              1.0.0
 */
class ControlSlider extends ControlBaseUnits
{
    public function getType()
    {
        return 'slider';
    }

    public function getDefaultValue()
    {
        return array_merge(parent::getDefaultValue(), array(
            'size' => '',
        ));
    }

    protected function getDefaultSettings()
    {
        return array_merge(parent::getDefaultSettings(), array(
            'label_block' => true,
        ));
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlSlider');
    }
}
