<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

namespace CE;

defined('_PS_VERSION_') or die;

class WidgetModule extends WidgetBase
{
    public function getName()
    {
        return 'ps-widget-module';
    }

    public function getTitle()
    {
        return __('Module', 'elementor');
    }

    public function getIcon()
    {
        return 'fa fa-puzzle-piece';
    }

    public function getCategories()
    {
        return array('prestashop');
    }

    protected function getModuleOptions()
    {
        $modules = array(
            __('- Select Module -', 'elementor'),
        );
        if (\Context::getContext()->controller instanceof \AdminCEEditorController) {
            $table = _DB_PREFIX_ . 'module';
            $rows = \Db::getInstance()->executeS(
                "SELECT m.name FROM $table AS m " . \Shop::addSqlAssociation('module', 'm') .
                " WHERE m.active = 1 AND m.name NOT IN ('creativeelements')"
            );
            if ($rows) {
                foreach ($rows as &$row) {
                    try {
                        $mod = \Module::getInstanceByName($row['name']);

                        if (!empty($mod->active) && method_exists($mod, 'renderWidget')) {
                            $modules[$mod->name] = $mod->displayName;
                        }
                    } catch (\Exception $ex) {
                        // TODO
                    }
                }
            }
        }
        return $modules;
    }

    protected function _registerControls()
    {
        $this->startControlsSection(
            'section_pswidget_options',
            array(
                'label' => __('Widget Settings', 'elementor'),
            )
        );

        $this->addControl(
            'module',
            array(
                'label' => __('Module', 'elementor'),
                'label_block' => true,
                'description' => __('Only those modules are available which implements the WidgetInterface', 'elementor'),
                'type' => ControlsManager::SELECT,
                'options' => $this->getModuleOptions(),
                'default' => '0',
            )
        );

        $this->endControlsSection();
    }

    protected function renderModule($hook_name, $hook_args = array(), $module = null)
    {
        $res = '';
        try {
            $mod = \Module::getInstanceByName($module);

            if (!empty($mod->active) && method_exists($mod, 'renderWidget')) {
                $res = $mod->renderWidget($hook_name, $hook_args);
            }
        } catch (\Exception $ex) {
            // TODO
        }
        return $res;
    }

    protected function render()
    {
        if (is_admin()) {
            return Helper::remoteRender($this->getData());
        }

        $module = $this->getSettings('module');

        if (!empty($module)) {
            echo $this->renderModule('displayCreativeWidget', array(), $module);
        }
    }

    public function renderPlainContent($instance = array())
    {
    }
}
