<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

namespace CE;

defined('_PS_VERSION_') or die;

class WidgetShortcode extends WidgetBase
{
    public function getName()
    {
        return 'shortcode';
    }

    public function getTitle()
    {
        return __('Shortcode', 'elementor');
    }

    public function getIcon()
    {
        return 'eicon-shortcode';
    }

    public function getCategories()
    {
        return array('general-elements');
    }

    protected function _registerControls()
    {
        $this->startControlsSection(
            'section_title',
            array(
                'label' => __('Shortcode', 'elementor'),
            )
        );

        $this->addControl(
            'shortcode',
            array(
                'label' => __('Insert your shortcode here', 'elementor'),
                'type' => ControlsManager::TEXTAREA,
                'placeholder' => "{hook h='displayShortcode'}",
                'default' => '',
            )
        );

        $this->endControlsSection();
    }

    public function parseNative($native)
    {
        return "'" == $native[0] ? str_replace('\\\\', '\\', trim($native, "'")) : json_decode($native);
    }

    public function parseHook($match)
    {
        preg_match_all(
            '~\s+(\w+)\s*=\s*(null|false|true|\d+|".*?"|\'.*?\'|\[.*?\])~',
            $match[0],
            $args,
            PREG_SET_ORDER
        );
        $smarty = null;
        $params = array();

        foreach ($args as $arg) {
            if ('[' == $arg[2][0]) {
                preg_match_all(
                    '~\s*,\s*(?:(\d+|".*?"|\'.*?\')\s*=>\s*)?(null|false|true|\d+|".*?"|\'.*?\')~',
                    ',' . trim($arg[2], '[]'),
                    $elems,
                    PREG_SET_ORDER
                );
                $array = array();

                foreach ($elems as $elem) {
                    $val = $this->parseNative($elem[2]);

                    if ($elem[1]) {
                        $key = $this->parseNative($elem[1]);

                        $array[$key] = $val;
                    } else {
                        $array[] = $val;
                    }
                }
                $params[$arg[1]] = $array;
            } else {
                $params[$arg[1]] = $this->parseNative($arg[2]);
            }
        }

        return empty($params['h']) ? '' : smartyHook($params, $smarty);
    }

    protected function render()
    {
        if (is_admin()) {
            return Helper::remoteRender($this->getData());
        }

        echo preg_replace_callback(
            '~\{hook(?:\s+\w+\s*=\s*(?:null|false|true|\d+|".*?"|\'.*?\'|\[.*?\]))+\s*\}~',
            array($this, 'parseHook'),
            $this->getSettings('shortcode')
        );
    }

    public function renderPlainContent()
    {
        // In plain mode, render without shortcode
        echo $this->getSettings('shortcode');
    }
}
