/*!
 * Creative Elements - Elementor based PageBuilder
 * Copyright 2019-2020 WebshopWorks.com
 */

function Class(c) {
	return (c.constructor.prototype = c).constructor;
}

// fix for multiple select val(): when no options are selected, return [] instead of null
$.fn.val = (function(parent) {
	return function val(value) {
		return void 0 === value && this[0] && this[0].multiple && parent.call(this) === null ? [] : parent.apply(this, arguments);
	}
})($.fn.val);

// wrapfix jQuery plugin for product miniatures
$.fn.wrapfix = function() {
	return this.each(function(i, el) {
		if (!$(el).find('.elementor-product-miniature:first').length) {
			if (ce.wrapfix) {
				$(el).addClass(ce.wrapfix);
			} else if (ce.PS16) {
				$(el).addClass('wrapfix');
			}
		}
	});
};

// for advanced content templates
CeView = Class({
	constructor: function CeView() {
		this.attr = {};
	},

	addRenderAttribute: function(elem, key, value) {
		elem in this.attr || (this.attr[elem] = {});
		key in this.attr[elem] || (this.attr[elem][key] = []);
		$.isArray(value) || (value = [value]);

		this.attr[elem][key] = this.attr[elem][key].concat(value);
	},

	getRenderAttributeString: function( elem ) {
		if (!this.attr[elem]) return '';
		var key, attr = [];

		for (key in this.attr[elem]) {
			attr.push(key + '="' + this.attr[elem][key].join(' ') + '"');
		}
		return attr.join(' ');
	}
});

FlipBoxHandler = function(self) { return self = {
	$style: null,

	aTabs: '.elementor-control-section_a, .elementor-control-section_style_a, .elementor-control-section_flip_box, .elementor-tabs-controls [data-tab]',
	bTabs: '.elementor-control-section_b, .elementor-control-section_style_b, .elementor-control-section_style_button',

	init: function() {
		if (self.$style) {
			return elementor.panel.$el.find('.elementor-control.elementor-open:first').prev(self.bTabs).length || self.clearStyle();
		}
		self.$style = $('<style id="ce-flip-box-edit-back">').appendTo(elementor.$previewContents.find('head'));

		elementor.panel.$el
			.on('mouseup.ce-flip-clear', self.aTabs, function(e) { 1 === e.which && self.clearStyle() })
			.on('mouseup.ce-flip-back', self.bTabs, function(e) { 1 === e.which && self.backStyle() })
		;
	},

	clearStyle: function() {
		self.$style.html('#elementor .elementor-flip-box-back { transition: none; }');

		setTimeout(function() { self.$style.html('') }, 100);
	},

	backStyle: function() {
		var wrapper = '#elementor-element-' + elementor.panel.currentView.content.currentView.model.id;

		self.$style.html(
			wrapper + ' .elementor-flip-box-front { display: none; }\n' +
			wrapper + ' .elementor-flip-box-back { transition: none; transform: none; opacity: 1; }'
		);
	}
}}.call();

$(function onReady() {
	// init custom CSS
	elementor.hooks.addFilter('editor/style/styleText', function addCustomCss(css, view) {
		var model = view.getEditModel(),
			customCSS = model.get('settings').get('custom_css');

		if (customCSS) {
			css += customCSS.replace(/selector/g, '#elementor-element-' + view.model.id);
		}

		return css;
	});

	// fix: add home_url to relative image path
	elementor.imagesManager.getImageUrl = function(image) {
		var url = image.url;

		if (!/^(https?:)?\/\//i.test(url)) {
			url = elementor.config.home_url + url;
		}
		return url;
	};
});

$(window).on('load.ce', function onLoadWindow() {
	// init language switcher
	var $context = $('#ce-context'),
		$langs = $('#ce-langs'),
		$languages = $langs.children().remove(),
		built = $langs.data('built'),
		lang = $langs.data('lang');

	elementor.shopContext = $context.length
		? $context.val()
		: 's-' + parseInt(elementor.config.post_id.slice(-2))
	;
	elementor.helpers.filterLangs = function() {
		var ctx = $context.length ? $context.val() : elementor.shopContext,
			id_group = ctx[0] == 'g' ? parseInt(ctx.substr(2)) : 0,
			id_shop = ctx[0] == 's' ? parseInt(ctx.substr(2)) : 0,
			dirty = elementor.shopContext != ctx;

		$langs.html('');

		var id_shops = id_group ? $context.find(':selected').nextUntil('[value^=g]').map(function() {
			return parseInt(this.value.substr(2));
		}).get() : [id_shop];

		$languages.each(function() {
			if (!ctx || $(this).data('shops').filter(function(id) { return ~id_shops.indexOf(id) }).length) {
				var $lang = $(this).clone().appendTo($langs),
					id_lang = $lang.data('lang'),
					active = !dirty && lang == id_lang;

				var uid = elementor.config.post_id.replace(/\d\d(\d\d)$/, function(m, shop) {
					return ('0'+id_lang).slice(-2) + ('0' + (id_shop || shop)).slice(-2);
				});
				$lang.attr('data-uid', uid).data('uid', uid);

				active && $lang.addClass('active');

				if (id_shop && !active && built[id_shop] && built[id_shop][id_lang]) {
					$lang.find('.elementor-button').data('uid', )
				} else {
					$lang.find('.elementor-button').remove();
				}
			}
		});
	};
	elementor.helpers.filterLangs();
	$context.on('change.ce-ctx', elementor.helpers.filterLangs);

	$langs.on('click.ce-lang', '.ce-lang', function onChangeLanguage() {
		var uid = $(this).data('uid'),
			href = location.href.replace(/uid=\d+/, 'uid=' + uid);

		if ($context.length && $context.val() != elementor.shopContext) {
			document.context.action = href;
			document.context.submit();
		} else if (uid != elementor.config.post_id) {
			location = href;
		}
	}).on('click.ce-lang-get', '.elementor-button', function onGetLanguageContent(e) {
		e.stopImmediatePropagation();
		var $icon = $('i', this);

		if ($icon.hasClass('fa-spin')) {
			return;
		}
		$icon.attr('class', 'fa fa-spin fa-circle-o-notch');

		elementor.ajax.send('getLanguageContent', {
			data: {
				uid: $(this).closest('[data-uid]').data('uid')
			},
			success: function(data) {
				$icon.attr('class', 'eicon-file-download');

				elementor.getRegion('sections').currentView.addChildModel(data);
			},
			error: function(data) {
				elementor.templates.showErrorDialog(data);
			}
		});
	});

	// handle permission errors for AJAX requests
	$(document).ajaxSuccess(function onAjaxSuccess(e, xhr, conf, res) {
		if (false === res.success && res.data && res.data.permission) {
			NProgress.done();
			$('.elementor-button-state').removeClass('elementor-button-state');

			try {
				elementor.templates.showTemplates();
			} catch (ex) {}

			elementor.templates.getErrorDialog()
				.setMessage('<center>' + res.data.permission + '</center>')
				.show()
			;
		}
	});

	// handle custom widget ready action
	ceFrontend.hooks.addAction('frontend/element_ready/widget', function onReadyWidget($widget, $) {
		var widget = $widget.data('element_type').split('.').shift();

		if (0 === widget.indexOf('product')) {
			$widget.removeClass('wrapfix').wrapfix();
		} else if ('flip-box' === widget) {
			FlipBoxHandler.init();
		}
	});
});

$(function() { elementor.on('preview:loaded', function onPreviewLoaded() {
	// fix for View Page in force edit mode
	var href = elementor.$preview[0].contentWindow.location.href;

	if (~href.indexOf('&force=1&')) {
		elementor.config.post_permalink = href.replace(/&force=1&.*/, '');
	}

	// Add multistore warning
	elementor.$previewContents.find('#ce-warning-multistore').html(elementor.config.i18n.multistore);

	// scroll to content area
	var contentTop = elementor.$previewContents.find('#elementor .elementor-section-wrap').offset().top;
	if (contentTop > $(window).height() * 0.66) {
		elementor.$previewContents.find('html, body').animate({
			scrollTop: contentTop - 30
		}, 400);
	}

	// carousel fix for device change
	elementor.$previewContents.on('init', '.slick-slider', function(e, slick) {
		$(elementor.$previewContents[0].defaultView).on('resize.slick', function() {
			slick.windowWidth = 0;
			slick.resize();
		});
	});

	// fix for multiple Global colors / fonts
	elementor.$previewContents.find('#elementor-frontend-stylesheet').remove();

	// init Edit with CE buttons
	elementor.$previewContents.find('.ce-edit-btn').on('click.ce', function() {
		location.href = this.href;
	});

	// init Read More link
	elementor.$previewContents.find('.ce-read-more').on('click.ce', function() {
		window.open(this.href);
	});

	// init existing widgets
	elementor.$previewContents.find('.elementor-widget[data-element_type^=product]').wrapfix();
	FlipBoxHandler.init();

	// init layerslider widget
	elementor.panel.$el.on('change.ls', '.ls-selector select', function onChangeSlider() {
		var $ = elementor.$previewContents[0].defaultView.jQuery;

		$('#elementor-element-' + elementor.panel.currentView.content.currentView.model.id)
			.addClass('elementor-widget-empty')
			.append('<i class="elementor-widget-empty-icon eicon-insert-image">')
			.find('.ls-container').layerSlider('destroy').remove()
		;
	}).on('click.ls-new', '.elementor-control-ls-new button', function addSlider(e) {
		var title = prompt(ls.NameYourSlider);

		null === title || $.post(ls.url, {
			'ls-add-new-slider': 1,
			'title': title
		}, function onSuccessNewSlider(data) {
			var id = (data.match(/name="slider_id" value="(\d+)"/) || []).pop();
			if (id) {
				var option = '#' + id + ' - ' + title;
				elementor.config.widgets['ps-widget-LayerSlider'].controls[2].options[id] = option;
				$('.ls-selector select')
					.append('<option value="' + id + '">' + option + '</option>')
					.val(id)
					.change()
				;
				$('.elementor-control-ls-edit button').trigger('click.ls-edit');
			}
		});
	}).on('click.ls-edit', '.elementor-control-ls-edit button', function editSlider(e) {
		var lsUpdate,
			lsId = $('.ls-selector select').val();

		$.fancybox({
			width: '100%',
			height: '100%',
			padding: 0,
			href: ls.url + '&action=edit&id=' + lsId,
			type: 'if'+'rame',
			afterLoad: function onAfterLoadSlider() {
				var win = $('.fancybox-if'+'rame').contents()[0].defaultView;

				win.jQuery(win.document).ajaxSuccess(function(e, xhr, args, res) {
					if (args.data && args.data.indexOf('action=ls_save_slider') === 0 && '{"status":"ok"}' === res) {
						lsUpdate = true;
					}
				});
				$(win.document.head).append('<style>\
					#header, #nav-sidebar, .add-new-h2, .ls-save-shortcode { display: none; }\
					#main { padding-top: 0; }\
					#main #content { margin-left: 0; }\
				</style>');
			},
			beforeClose: function onBeforeCloseSlider() {
				var win = $('.fancybox-if'+'rame').contents()[0].defaultView,
					close = win.LS_editorIsDirty ? confirm(ls.ChangesYouMadeMayNotBeSaved) : true;

				if (close && win.LS_editorIsDirty) {
					win.LS_editorIsDirty = false;
				}
				return close;
			},
			afterClose: function onAfterCloseSlider() {
				lsUpdate && $('.ls-selector select')
					.val(0).change()
					.val(lsId).change()
				;
			}
		});
	});
})});
