{**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 *}

{capture ce_warning_multistore}<span id="ce-warning-multistore"></span>{/capture}

{capture ce_alert}<div class="alert alert-%s">%s</div>{/capture}

{capture ce_paragraph}<p>%s</p>{/capture}

{capture ce_undefined_position}
	{ce__('Undefined Position!')}
	<a href="http://docs.webshopworks.com/creative-elements/79-troubleshooting/337-undefined-position" class="ce-read-more">{ce__('Learn More')}</a>
{/capture}

{capture ce_action_link}<a href="%s" target="%s"><i class="icon-%"></i> %s</a>{/capture}

{capture ce_link}<a href="%s" target="%s">%s</a>{/capture}

{function ce_preview_breadcrumb links=[]}
	{$last = array_pop($links)}
	{foreach $links as $link}
		<a>{$link['title']|cleanHtml}</a><span class="navigation-pipe">&gt;</span>
	{/foreach}
	{$last['title']|cleanHtml}
{/function}

{capture ce_stylesheet}
	<link rel="stylesheet" href="%s" media="%s">
{/capture}

{capture ce_style}
	<style>
	%s
	</style>
{/capture}

{capture ce_script}
	<script data-cfasync="false" src="%s"></script>
{/capture}

{capture ce_inline_script}
	<script data-cfasync="false">
	%s
	</script>
{/capture}

{function ce_render elems=[]}
	{foreach $elems as $tag => $elem}
	{if 'text' === $tag}
		{$elem|cleanHtml}
	{else}
		<{$tag|escape:'html':'UTF-8'}{if isset($elem.attrs)}{foreach $elem.attrs as $attr => $value}{if is_int($attr)} {$value|escape:'html':'UTF-8'}{else} {$attr|escape:'html':'UTF-8'}="{$value|escape:'html':'UTF-8'}"{/if}{/foreach}{/if}>
		{if isset($elem.children)}
			{if is_array($elem.children)}{ce_render elems=$elem.children}{else}{$elem.children|cleanHtml}{/if}
		</{$tag|escape:'html':'UTF-8'}>
		{/if}
	{/if}
	{/foreach}
{/function}
