<?php
/**
 * EtixPay - A Payment Module for PrestaShop 1.7
 *
 * This file is the declaration of the module.
 *
 * @author Atrium Team <team@atrim.com>
 * @license http://opensource.org/licenses/afl-3.0.php
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
include(_PS_MODULE_DIR_ . 'etixpay/lib/EtixpayOrder.php');
include(_PS_MODULE_DIR_ . 'etixpay/lib/Etixpay_OrderState.php');
include(_PS_MODULE_DIR_ . 'etixpay/lib/EtixpayRecoverPay.php');

class EtixPay extends PaymentModule
{
    private $_html = '';
    private $_postErrors = array();
    public $pay_pasarelaUSER;
    public $pay_pasarelaAPISECRET;
    public $walletCode;
    public $p_state_end_transaction;

    public $address;

    public function __construct()
    {
        $this->name                   = 'etixpay';
        $this->tab                    = 'payments_gateways';
        $this->version                = '1.0';
        $this->author                 = 'Team Atrium';
        $this->controllers            = array('payment', 'validation');
        $this->currencies             = true;
        $this->currencies_mode        = 'checkbox';
        $this->bootstrap              = true;
        $this->displayName            = 'EtixPay';
        $this->description            = 'etixpay payments module.';
        $this->confirmUninstall       = 'Are you sure you want to uninstall this module?';
        $this->ps_versions_compliancy = array('min' => '1.7.0', 'max' => _PS_VERSION_);

        parent::__construct();

        $config = Configuration::getMultiple(array('P_CUST_ID_CLIENTE',
            'pay_pasarelaUSER',
            'pay_pasarelaAPISECRET',
            'walletCode',
            'P_REDUCE_STOCK_PENDING',
            'P_STATE_END_TRANSACTION'));
        if (isset($config['pay_pasarelaUSER']))
            $this->pay_pasarelaUSER = trim($config['pay_pasarelaUSER']);
        if (isset($config['pay_pasarelaAPISECRET']))
            $this->pay_pasarelaAPISECRET = trim($config['pay_pasarelaAPISECRET']);
        if (isset($config['walletCode']))
            $this->walletCode = trim($config['walletCode']);
        if (isset($config['P_REDUCE_STOCK_PENDING']))
            $this->p_reduce_stock_pending = $config['P_REDUCE_STOCK_PENDING'];
        if (isset($config['P_STATE_END_TRANSACTION'])){
            $this->p_state_end_transaction = $config['P_STATE_END_TRANSACTION'];
        }else{
            $this->p_state_end_transaction = (int)Configuration::get('PS_OS_PAYMENT');
        }

        if (!isset($this->pay_pasarelaUSER) OR !isset($this->pay_pasarelaAPISECRET) OR !isset($this->walletCode))
            $this->warning = $this->l('pay_pasarelaUSER, pay_pasarelaAPISECRET and walletCode must be configured to use this module correctly');
    }

    public function install()
    {
        if ((int)Configuration::get('etixPay') == 1 ) {
            $this->_errors[] = $this->l('this module is already installed');
            return false;
        }

        if (extension_loaded('curl') == false)
        {
            $this->_errors[] = $this->l('You have to enable the cURL extension on your server to install this module');
            return false;
        }

        Configuration::updateValue('pay_pasarelaUSER', '');
        Configuration::updateValue('pay_pasarelaAPISECRET', '');
        Configuration::updateValue('walletCode', '');
        Configuration::updateValue('etixpay', true);

        EtixpayOrder::remove();
        EtixpayOrder::setup();
        Etixpay_OrderState::remove();
        Etixpay_OrderState::setup();
        EtixpayRecoverPay::remove();
        EtixpayRecoverPay::setup();

        return parent::install()
            && $this->registerHook('header')
            && $this->registerHook('backOfficeHeader')
            && $this->registerHook('payment')
            && $this->registerHook('paymentReturn')
            && $this->registerHook('paymentOptions')
            && $this->registerHook('displayOrderConfirmation');
    }

    /**
     * Uninstall this module and remove it from all hooks
     *
     * @return bool
     */
    public function uninstall()
    {
        Configuration::deleteByName('pay_pasarelaUSER');
        Configuration::deleteByName('pay_pasarelaAPISECRET');
        Configuration::deleteByName('walletCode');
        Configuration::deleteByName('etixpay', false);
        EtixpayOrder::remove();
        EtixpayRecoverPay::remove();
        return parent::uninstall();
    }

    protected function _displayInfoAdmin()
    {
        return $this->display(__FILE__, 'infos.tpl');
    }
    /**
     *
     * @return string
     */
    public function getContent()
    {
        if (Tools::isSubmit('btnSubmit')) {
            $this->postValidation();
            if (!count($this->_postErrors)) {
                $this->postProcess();
            } else {
                foreach ($this->_postErrors as $err) {
                    $this->_html .= $this->displayError($err);
                }
            }
        } else {
            $this->_html .= '<br />';
        }
        $this->_html .= $this->_displayInfoAdmin();
        $this->_html .= $this->renderForm();

        return $this->_html;
    }
    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }
    protected function getConfigForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->trans('Configuración etixpay', array(), 'Modules.Etixpay.Admin'),
                    'icon' => 'icon-envelope'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->trans('pay_pasarelaUSER', array(), 'Modules.Etixpay.Admin'),
                        'name' => 'pay_pasarelaUSER',
                        'desc' => $this->trans('Id user etixpay platform.', array(), 'Modules.Etixpay.Admin'),
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('pay_pasarelaAPISECRET', array(), 'Modules.Etixpay.Admin'),
                        'name' => 'pay_pasarelaAPISECRET',
                        'desc' => $this->trans('Secret key to api conection', array(), 'Modules.Etixpay.Admin'),
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('walletCode', array(), 'Modules.Etixpay.Admin'),
                        'name' => 'walletCode',
                        'desc' => $this->trans('Wallet Code', array(), 'Modules.Etixpay.Admin'),
                        'required' => true
                    ),
                ),
                'submit' => array(
                    'title' => $this->trans('Save', array(), 'Admin.Actions'),
                )
            ),
        );

        return $fields_form;
    }
    protected function getConfigFormValues()
    {
        return array(
            'pay_pasarelaUSER' => Tools::getValue('pay_pasarelaUSER', Configuration::get('pay_pasarelaUSER')),
            'pay_pasarelaAPISECRET' => Tools::getValue('pay_pasarelaAPISECRET', Configuration::get('pay_pasarelaAPISECRET')),
            'walletCode' => Tools::getValue('walletCode', Configuration::get('walletCode'))
        );
    }

    private function postValidation() {
        if (Tools::isSubmit('btnSubmit')) {
            if (!Tools::getValue('pay_pasarelaUSER'))
                $this->_postErrors[] = $this->l('\'pay_pasarelaUSER\' Required.');
            if (!Tools::getValue('pay_pasarelaAPISECRET'))
                $this->_postErrors[] = $this->l('\'pay_pasarelaAPISECRET\' Required.');
            if (!Tools::getValue('walletCode'))
                $this->_postErrors[] = $this->l('\'walletCode\' Required.');
        }
    }
    protected function postProcess()
    {
        if (Tools::isSubmit('btnSubmit')) {

            Configuration::updateValue('pay_pasarelaUSER', Tools::getValue('pay_pasarelaUSER'));
            Configuration::updateValue('pay_pasarelaAPISECRET', Tools::getValue('pay_pasarelaAPISECRET'));
            Configuration::updateValue('walletCode', Tools::getValue('walletCode'));

            $this->_html.= '<div class="bootstrap"><div class="alert alert-success">'.$this->l('Saved') . '</div></div>';

        }
    }
    /**
     * Display this module as a payment option during the checkout
     *
     * @param array $params
     * @return array|void
     */
    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }

        $formAction = $this->context->link->getModuleLink($this->name, 'validation', array(), true);
        $this->smarty->assign(['action' => $formAction]);
        $paymentForm = $this->fetch('module:etixpay/views/templates/hook/payment_options.tpl');

        /**
         * Create a PaymentOption object containing the necessary data
         * to display this module in the checkout
         */
        $newOption = new PrestaShop\PrestaShop\Core\Payment\PaymentOption;
        $newOption->setModuleName($this->displayName)
            ->setCallToActionText($this->displayName)
            ->setAction($formAction)
            ->setForm($paymentForm);

        $payment_options = array(
            $newOption
        );

        return $payment_options;
    }

    /**
     * Display a message in the paymentReturn hook
     * 
     * @param array $params
     * @return string
     */
    public function hookPaymentReturn($params)
    {
        /**
         * Verify if this module is enabled
         */
        if (!$this->active) {
            return;
        }
        if (version_compare(_PS_VERSION_, '1.7.0.0 ', '<')){
            $order = $params['objOrder'];
            $value = $params['total_to_pay'];
        }else{
            $order = $params['order'];
            $value = $params['order']->getOrdersTotalPaid();
        }
        if ($order->getCurrentOrderState()->id != Configuration::get('PS_OS_ERROR')){
            $this->smarty->assign('status', 'ok');
        }
        $extra1 = $order->id_cart;
        $extra2 = $order->id;
        $emailComprador = $this->context->customer->email;
        $valorBaseDevolucion = $order->total_paid_tax_excl;
        $cart= $this->context->cart;
        $refVenta = $order->reference;

        $state = $order->getCurrentState();

        if($state){
            if (!EtixpayOrder::ifExist($order->id)) {
                EtixpayOrder::create($order->id,1);
            }
            $recoverPay = EtixpayRecoverPay::getCode($order->id);

            $this->smarty->assign(array(
                'status' => 'ok',
                'refVenta' => $refVenta,
                'extra1' => $extra1,
                'extra2' => $extra2,
                'total' => $value,
                'recover_pay' => $recoverPay,
                'payment_status' => EtixpayRecoverPay::verifyPayment($order->id),
            ));
        }else {
            $this->smarty->assign('status', 'failed');
        }
        //return $this->display(__FILE__, 'views/templates/hook/payment_return.tpl');
        return $this->fetch('module:etixpay/views/templates/hook/payment_return.tpl');
        //Tools::redirect('index.php?controller=order-confirmation&id_cart='.(int)$cart->id.'&id_module='.(int)$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
    }
    public function hookDisplayOrderConfirmation($params)
    {}
}