<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A group of Dimensions settings (Top, Right, Bottom, Left) With the option to link them together
 *
 * @param array  $default {
 *         @type integer       $top                     Default empty
 *         @type integer       $right                   Default empty
 *         @type integer       $bottom                  Default empty
 *         @type integer       $left                    Default empty
 *         @type string        $unit                    The selected CSS Unit. 'px', '%', 'em'
 *                                                         Default 'px'
 *         @type bool          $isLinked                Whether to link them together ( prevent set different values )
 *                                                         Default true
 * }
 *
 * @param array|string $allowed_dimensions      Which fields to show, 'all' | 'horizontal' | 'vertical' | [ 'top', 'left' ... ]
 *                                              Default 'all'
 *
 * @since                         1.0.0
 */
class ControlDimensions extends ControlBaseUnits
{
    public function getType()
    {
        return 'dimensions';
    }

    public function getDefaultValue()
    {
        return array_merge(parent::getDefaultValue(), array(
            'top' => '',
            'right' => '',
            'bottom' => '',
            'left' => '',
            'isLinked' => true,
        ));
    }

    protected function getDefaultSettings()
    {
        return array_merge(parent::getDefaultSettings(), array(
            'label_block' => true,
            'allowed_dimensions' => 'all',
            'placeholder' => '',
        ));
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlDimensions');
    }
}
