<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A Select box control based on select2 jQuery plugin @see https://select2.github.io/ .
 *
 * @param string|array $default  The selected option key, or an array of selected values if multiple == true
 *                               Default empty
 * @param array        $options  Array of of key & value pairs: `[ 'key' => 'value', ... ]`
 *                               Default empty
 * @param bool         $multiple Whether to allow multi choices
 *                               Default false
 *
 * @since 1.0.0
 */
class ControlSelect2 extends ControlBase
{
    public function getType()
    {
        return 'select2';
    }

    public function getDefaultSettings()
    {
        return array(
            'multiple' => false,
        );
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlSelect2');
    }
}
