<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2015 knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class Prestasms
{

    public $id;
    public $token;
    public function __construct($param)
    {
        $this->id = $param['id'];
        $this->token = $param['token'];
    }

    /**
     * Send SMS using PrestaSMS API
     * @param string $call_prefix
     * @param string $mobile_number
     * @param string $message
     * @return boolean
     * @throws Exception
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function sendSMS($call_prefix, $mobile_number, $message)
    {
        $mobile_number = $call_prefix . '' . $mobile_number;
        $url = "https://portal.bulkgate.com/api/1.0/simple/transactional";
        $data = array(
                    'application_id' => $this->id,
                    'application_token' => $this->token,
                    //'number' => '919654457010',
                    'number' => $mobile_number,
                    'text' => $message,
                );
        $post = http_build_query($data);
        $curl_request_data = curl_init($url);
        curl_setopt($curl_request_data, CURLOPT_POST, true);
        curl_setopt($curl_request_data, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl_request_data, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl_request_data, CURLOPT_POSTFIELDS, $post);
        $curl_response = curl_exec($curl_request_data);
        curl_close($curl_request_data);
        $response = json_decode($curl_response, true);

        /**
         * if response data status is accepted or sent then return true and save data in database else return false and save error message in database
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (isset($response['data']) && ($response['data']['status'] == 'accepted' || $response['data']['status'] == 'sent')) {
            $message_id = $response['data']['sms_id'];
            Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_detail` (mobile_number, message, unique_sms_id, is_error, error_message, response, sms_gateway) VALUES ("' . pSQL($mobile_number) . '", "' . pSQL($message) . '", "' . pSQL($message_id) . '", "0", "", "' . pSQL($curl_response) . '", "prestasms")');
            return true;
        } else {
            $error_message = $response['error'];
            Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_detail` (mobile_number, message, is_error, error_message, response, sms_gateway) VALUES ("' . pSQL($mobile_number) . '", "' . pSQL($message) . '", "1", "' . pSQL($error_message) . '", "' . pSQL($curl_response) . '", "prestasms")');
            return false;
        }
    }
}
