<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2015 knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class Twilio
{

    public $sid;
    public $token;
    public $from;

    public function __construct($param)
    {
        $this->sid = $param['twilio_account_sid'];
        $this->token = $param['twilio_account_token'];
        $this->from = $param['twilio_number'];
    }

    /**
     * Send SMS using Twilio API 
     * @param string $call_prefix
     * @param string $mobile_number
     * @param string $message
     * @return boolean
     * @throws Exception
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function sendSMS($call_prefix, $mobile_number, $message)
    {
        $mobile_number = '+' . $call_prefix . '' . $mobile_number;
        $sid = $this->sid;
        $token = $this->token;
        $from = $this->from;
        /**
         * Twilio API deprecated and the response method also
         * URL changed from "https://api.twilio.com/2010-04-01/Accounts/$sid/SMS/Messages.json" to "https://api.twilio.com/2010-04-01/Accounts/".$sid."/Messages.json"
         * NAAug2023 Twilio-API
         * @date 03-08-2023
         * @modifier Nikhil Aggarwal
         */
        $url = "https://api.twilio.com/2010-04-01/Accounts/".$sid."/Messages.json";
        // Changes end by Nikhil
        $data = array(
            'From' => $from,
            'To' => $mobile_number,
            'Body' => $message,
        );
        $post = http_build_query($data);
        $curl_request_data = curl_init($url);
        curl_setopt($curl_request_data, CURLOPT_POST, true);
        curl_setopt($curl_request_data, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl_request_data, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl_request_data, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl_request_data, CURLOPT_USERPWD, "$sid:$token");
        curl_setopt($curl_request_data, CURLOPT_POSTFIELDS, $post);
        $curl_response = curl_exec($curl_request_data);
        curl_close($curl_request_data);
        /**
         * Twilio API deprecated and the response method also
         * Response format is now in JSON so commented out xml response
         * NAAug2023 Twilio-API
         * @date 03-08-2023
         * @modifier Nikhil Aggarwal
         */
        // $xml = simplexml_load_string($curl_response, 'SimpleXMLElement', LIBXML_NOCDATA);
        $response = json_decode($curl_response, true);
        // Changes end by Nikhil
        /**
         * If SMS is sent successfully then save the response in database and return true else return false with error message
         * @date 23-03-2023
         * @commenter Prvind Panday
         */

        /**
         * Twilio API deprecated and the response method also
         * Replaced line - if (isset($response['SMSMessage']) && ($response['SMSMessage']['Status'] == 'queued')) {    with  if (isset($response['status']) && ($response['status'] == 'queued')) {
         * NAAug2023 Twilio-API
         * @date 03-08-2023
         * @modifier Nikhil Aggarwal
         */
        if (isset($response['status']) && ($response['status'] == 'queued')) {
            /**
             * Twilio API deprecated and the response method also
             * Replaced line $message_id = $response['SMSMessage']['Sid']; with $message_id = $response['sid'];
             * NAAug2023 Twilio-API
             * @date 03-08-2023
             * @modifier Nikhil Aggarwal
             */
            $message_id = $response['sid'];
            Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_detail` (mobile_number, message, unique_sms_id, is_error, error_message, response, sms_gateway) VALUES ("' . pSQL($mobile_number) . '", "' . pSQL($message) . '", "' . pSQL($message_id) . '", "0", "", "' . pSQL($curl_response) . '", "twilio")');
            return true;
        } else {
            /**
             * Twilio API deprecated and the response method also
             * Replaced line $error_message = $response['SMSMessage']['message']; with $error_message = $response['message'];
             * NAAug2023 Twilio-API
             * @date 03-08-2023
             * @modifier Nikhil Aggarwal
             */
            $error_message = $response['message'];
            Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_detail` (mobile_number, message, is_error, error_message, response, sms_gateway) VALUES ("' . pSQL($mobile_number) . '", "' . pSQL($message) . '", "1", "' . pSQL($error_message) . '", "' . pSQL($curl_response) . '", "twilio")');
            return false;
        }
        // Changes end by Nikhil
    }
}
