<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2017 Knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 *
 *
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class KbMobileloginVerificationModuleFrontController extends ModuleFrontController
{

    private $module_dir = '';

    public function __construct()
    {
        parent::__construct();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme = false);
    }

    /**
     * Initializes front controller: sets smarty variables,
     * class properties, redirects depending on context, etc.
     *
     * @throws PrestaShopException
     */
    public function init()
    {
        parent::init();
        $this->module_dir = _PS_MODULE_DIR_ . 'kbmobilelogin/';
    } 

    /**
     * Initializes page content variables. This method is automatically when the page is displayed.
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function initContent()
    {
        $moduleobject = new KbMobileLogin();
        if (Tools::getIsset('ajax')) {
            $response = null;
            $mobile_login_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
            /**
             * Update type of $kbMobileNumber from string to int to avoid sql injection
             * @date 28-02-2023
             * @commenter Prvind Panday
             */
            $kbMobileNumber = (int)trim(Tools::getValue('kbMobileNumber'));
            
            /**
             * Check if $kbMobileNumber is empty or not and if it is not empty then check if it is valid or not 
             * @date 28-02-2023
             * @commenter Prvind Panday
             */
            if (!empty($kbMobileNumber) && $this->checkInputMobileValidation($mobile_login_setting, $kbMobileNumber)) {

                /**
                 * if method is checkMobileNumberExist then check if mobile number exist or not 
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (Tools::getValue('method') == 'checkMobileNumberExist') {
                    $kbCountryId = Tools::getValue('kbCountryId');
                    $currentCustomerId = Tools::getValue('currentCustomerId');
                    $response = $moduleobject->checkMobileNumberExist($kbCountryId, $kbMobileNumber, false, $currentCustomerId);
                }

                /**
                 *  Added new code to check if mobile number exist or not and if it exist then check if it is verified or not 
                 *  and if it is verified then email will be return else the unknown email will be passed 
                 *  To remove the use of post in php file
                 *  ASFeb2024 Post_Change
                 *  @date 08-02-2024
                 *  @modifier Amit Singh
                 */
                if (Tools::getValue('method') == 'checkMobileNumberemail') {
                    $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
                        if ($module_setting['enable']) {
                            if ($module_setting['login_by_mobile']) {
                                $kblastemailvalue = $kbMobileNumber;
                                if (!Validate::isEmail($kblastemailvalue)) {
                                    $selectSql = 'SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kblastemailvalue) . '" AND customer_id is not null AND customer_id != "" ';
                                    if ($module_setting['login_mobile_verified']) {
                                        $selectSql .= ' and verified = 1 ';
                                    }
                                    $mobilenumber_exist = Db::getInstance()->getRow($selectSql);
                                    if ($mobilenumber_exist) {
                                        $customer_id = $mobilenumber_exist['customer_id'];
                                        $customer = new Customer($customer_id);
                                        $response['email'] = $customer->email;
                                        $response['success'] = true;
                                    } else {
                                        $response['email'] = uniqid('unknown_') . $module_setting['temp_email_format'];
                                        $response['success'] = true;
                                    }
                                }
                            }
                      }
                    } 
                    // End of change By Amit
    

                /**
                 * if method is sendOTP then send OTP to mobile number entered by user at the time of login or registration
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (Tools::getValue('method') == 'sendOTP') {
                    $kbCountryId = Tools::getValue('kbCountryId');
                    $message = '';
                    if ($moduleobject->sendOTP($kbCountryId, $kbMobileNumber, $message)) {
                        if (isset($this->context->cookie->kbLastMobileNumber)) {
                            $kbLastCountryID = $this->context->cookie->kbLastCountryID;
                            $kbLastMobileNumber = $this->context->cookie->kbLastMobileNumber;

                            if (($kbLastCountryID != $kbCountryId ) || ($kbMobileNumber != $kbLastMobileNumber)) {
                                $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kbLastMobileNumber) . '" AND customer_id is  null AND country_id = ' . pSQL($kbLastCountryID);
                                Db::getInstance()->execute($DeleteSQL);
                            }
                        }
                        $this->context->cookie->__set('kbLastCountryID', $kbCountryId);
                        $this->context->cookie->__set('kbLastMobileNumber', $kbMobileNumber);

                        $response['success'] = true;
                        $response['message'] = $message;
                    } else {
                        $response['success'] = false;
                        $response['message'] = $message;
                    };
                }

                /**
                 * if method is verifyOTP then verify OTP entered by user at the time of login or registration
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (Tools::getValue('method') == 'verifyOTP') {
                    $kbCountryId = Tools::getValue('kbCountryId');
                    $kbCurrentOTP = Tools::getValue('kbCurrentOTP');
                    $message = '';
                    if ($moduleobject->checkOTPValidation($kbCountryId, $kbMobileNumber, $message, true, true)) {
                        $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId));
                        $wrong_otp_count = $mobilenumber_exist['wrong_otp_count'];
                        $otp = $mobilenumber_exist['otp'];
                        if ($otp == $kbCurrentOTP) {
                            //Update new OTP in database corresponding to number
                            Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET otp = "", otp_count = "0", verified = 1, otp_sent_time = null, wrong_otp_count = "0" WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId));
                            $response['success'] = true;
                            $response['message'] = $this->module->l('OTP verified successfully.', 'verification');
                            unset($this->context->cookie->kbLastCountryID);
                            unset($this->context->cookie->kbLastMobileNumber);
                        } else {
                            $wrong_otp_count = $wrong_otp_count + 1;
                            Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET wrong_otp_count = "' . pSQL($wrong_otp_count) . '" WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId));
                            $message = $this->module->l('You have entered invalid OTP.Please enter correct OTP.', 'verification');
                            $response['success'] = false;
                            $response['message'] = $message;
                        }
                    } else {
                        $response['success'] = false;
                        $response['message'] = $message;
                    }
                }

                /**
                 * if method is supercheckouLoginByPassword then check if mobile number exist or not and if it exist then check if it is verified or not
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (Tools::getValue('method') == 'supercheckouLoginByPassword') {
                    $kbCountryId = Tools::getValue('kbCountryId');
                    $password = Tools::getValue('kbPassword');

                    /**
                     * Check if mobile number exist or not if exist then check if it is verified or not and if it is verified then check if password is correct or not, etc.
                     * @date 28-02-2023
                     * @commenter Prvind Panday
                     */
                    $mobileNumberExist = $moduleobject->checkMobileNumberExist($kbCountryId, $kbMobileNumber, true);
                    if ($mobileNumberExist) {
                        $customerId = $mobileNumberExist['customer_id'];
                        $error = '';
                        if ($mobile_login_setting['verify_mobile_on_registration']) {
                            $SelectSQL = 'SELECT verified FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId);
                            $verified_status = Db::getInstance()->getValue($SelectSQL);
                            if ($verified_status != 1) {
                                $error = $this->module->l('Mobile number must be verified for authentication.', 'verification');
                            }
                        }
                        if (empty($kbMobileNumber)) {
                            $error = $this->module->l('Mobile number is required.', 'verification');
                        }
                        if (empty($password)) {
                            $error = $this->module->l('Password is required.', 'verification');
                        } elseif (!Validate::isPasswd($password)) {
                            $error = $this->module->l('Invalid Password', 'verification');
                        }
                        /**
                         * if no error then authenticate user and login the customer
                         * @date 28-02-2023
                         * @commenter Prvind Panday
                         */
                        if (empty($error)) {
                            $tempCustomer = new Customer($customerId);
                            $email =  $tempCustomer->email;
                            /**
                            * Commented the below code as we do not need the same.
                            * ASMar2024 actionAuthenticationBefore
                            * @date 08-03-2024
                            * @modifier Amit Singh
                            */
                            // Hook::exec('actionAuthenticationBefore');
                            //End of change by Amit
                            $customer = new Customer();
                            $authentication = $customer->getByEmail(trim($email), trim($password));
                            if (isset($authentication->active) && !$authentication->active) {
                                $error = $this->module->l('Your account is not active at this time.', 'verification');
                                $response['success'] = false;
                                $response['message'] = $error;
                            } elseif (!$authentication || !$customer->id || $customer->is_guest) {
                                $error = $this->module->l('Authentication failed.', 'verification');
                                $response['success'] = false;
                                $response['message'] = $error;
                            } else {
                                $update_product_delivery = true;
                                if (Configuration::get('PS_CART_FOLLOWING') && (empty($this->context->cookie->id_cart) || Cart::getNbProducts($this->context->cookie->id_cart) == 0) && (int) Cart::lastNoneOrderedCart($customer->id)
                                ) {
                                    $update_product_delivery = false;
                                } else {
                                    $update_product_delivery = true;
                                }
                                $this->context->updateCustomer($customer);
                                Hook::exec('actionAuthentication', array(
                                    'customer' => $this->context->customer));
                                CartRule::autoRemoveFromCart($this->context);
                                CartRule::autoAddToCart($this->context);
                                $response['success'] = true;
                            }
                        } else {
                            $response['success'] = false;
                            $response['message'] = $error;
                        }
                    } else {
                        $response['success'] = false;
                        $response['message'] = $kbMobileNumber . ' ' . $this->module->l('mobile number does not exist.', 'verification');
                    }
                }

                /**
                 * if method is supercheckouLoginByOTP then check if mobile number exist or not and if it exist then check if it is verified or not
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (Tools::getValue('method') == 'supercheckouLoginByOTP') {
                    $kbCountryId = Tools::getValue('kbCountryId');
                    $kbCurrentOTP = Tools::getValue('kbCurrentOTP');
                    $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND customer_id is not null AND customer_id != "" AND country_id = ' . pSQL($kbCountryId));
                    if ($mobilenumber_exist) {
                        $message = '';
                        if ($moduleobject->checkOTPValidation($kbCountryId, $kbMobileNumber, $message, true)) {
                            $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND customer_id is not null AND customer_id != "" AND country_id = ' . pSQL($kbCountryId));
                            $wrong_otp_count = $mobilenumber_exist['wrong_otp_count'];
                            $otp = $mobilenumber_exist['otp'];
                            if ($otp == $kbCurrentOTP) {
                                $customer_id = $mobilenumber_exist['customer_id'];
                                $customer = new Customer($customer_id);
                                if (isset($customer->active) && !$customer->active) {
                                    $response['success'] = false;
                                    $response['message'] = $this->module->l('Your account is not active at this time.', 'login');
                                } else {
                                    //Update new OTP in database corresponding to number
                                    Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET otp = "", otp_count = "0", verified = 1, otp_sent_time = null, wrong_otp_count = "0" WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId));
                                    unset($this->context->cookie->kbmobilenumber);
                                    unset($this->context->cookie->kbcountryid);
                                    // <editor-fold defaultstate="collapsed" desc="Customer Authentication Code">
                                    $update_product_delivery = true;
                                    if (Configuration::get('PS_CART_FOLLOWING') && (empty($this->context->cookie->id_cart) || Cart::getNbProducts($this->context->cookie->id_cart) == 0) && (int) Cart::lastNoneOrderedCart($customer->id)
                                    ) {
                                        $update_product_delivery = false;
                                    } else {
                                        $update_product_delivery = true;
                                    }
                                    $this->context->updateCustomer($customer);
                                    Hook::exec('actionAuthentication', array('customer' => $this->context->customer));
                                    CartRule::autoRemoveFromCart($this->context);
                                    CartRule::autoAddToCart($this->context);
                                    $response['success'] = true;
                                    // </editor-fold>
                                }
                            } else {
                                $wrong_otp_count = $wrong_otp_count + 1;
                                Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET wrong_otp_count = "' . pSQL($wrong_otp_count) . '" WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId));
                                $message = $this->module->l('You have entered invalid OTP.Please enter correct OTP.', 'verification');
                                $response['success'] = false;
                                $response['message'] = $message;
                            }
                        } else {
                            $response['success'] = false;
                            $response['message'] = $message;
                        }
                    } else {
                        $message = $kbMobileNumber . ' ' . $this->module->l('mobile number does not exist.', 'verification');
                        $response['success'] = false;
                        $response['message'] = $message;
                    }
                }

                /**
                 * if method is supercheckouRegisterAccount then check if mobile number exist or not and if it exist then check if it is verified or not
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (Tools::getValue('method') == 'supercheckouRegisterAccount') {
                    $kbCountryId = trim(Tools::getValue('kbCountryId'));
                    $kbLastName = trim(Tools::getValue('kbLastName'));
                    $kbPassword = trim(Tools::getValue('kbPassword'));
                    $kbFirstName = trim(Tools::getValue('kbFirstName'));
                    $kbEmail = trim(Tools::getValue('kbEmail'));
                    $mobileexist = $moduleobject->checkMobileNumberExist($kbCountryId, $kbMobileNumber, false);
                    if ($mobileexist) {
                        $message = $kbMobileNumber . ' ' . $this->module->l('mobile number already registered.', 'verification');
                        $response['success'] = false;
                        $response['message'] = $message;
                    } else {
                        $error = '';
                        /**
                         * validations for email, password, firstname etc as per register process
                         * @date 28-02-2023
                         * @commenter Prvind Panday
                         */
                        if ($kbEmail == '') {
                            $error = $this->module->l('An email address required.', 'verification');
                        } else if (!Validate::isEmail($kbEmail)) {
                            $error = $this->module->l('Invalid email address.', 'verification');
                        } else if (Customer::customerExists($kbEmail)) {
                            $error = $this->module->l('This customer is already exist', 'verification');
                        }

                        if (empty($kbMobileNumber)) {
                            $error = $this->module->l('Mobile number is required.', 'verification');
                        }
                        if (empty($kbPassword)) {
                            $error = $this->module->l('Password is required.', 'verification');
                        } elseif (!Validate::isPasswd($kbPassword)) {
                            $error = $this->module->l('Invalid Password', 'verification');
                        }

                        if (empty($kbFirstName)) {
                            $error = $this->module->l('Firstname is required.', 'verification');
                        } elseif (!Validate::isName($kbFirstName)) {
                            $error = $this->module->l('Invalid Firstname', 'verification');
                        }

                        if (empty($kbLastName)) {
                            $error = $this->module->l('Lastname is required.', 'verification');
                        } elseif (!Validate::isName($kbLastName)) {
                            $error = $this->module->l('Invalid Lastname', 'verification');
                        }

                        if (empty($kbMobileNumber)) {
                            $error = $this->module->l('Mobile number is required.', 'verification');
                        }
                        if ($mobile_login_setting['verify_mobile_on_registration']) {
                            $SelectSQL = 'SELECT verified FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kbMobileNumber) . '" AND country_id = ' . pSQL($kbCountryId);
                            $verified_status = Db::getInstance()->getValue($SelectSQL);
                            if ($verified_status != 1) {
                                $error = $this->module->l('Mobile number must be verified before registration.', 'verification');
                            }
                        }
                        /**
                         * if no error then create new customer
                         * @date 28-02-2023
                         * @commenter Prvind Panday
                         */
                        if (empty($error)) {
                           
                            Hook::exec('actionBeforeSubmitAccount');

                            $customer = new Customer();
                            $customer->id_gender = Tools::getValue('id_gender');
                            $customer->firstname = Tools::getValue('customer_firstname');
                            $customer->lastname = Tools::getValue('customer_lastname');
                            $customer->email = Tools::getValue('email');
                            $customer->passwd = Tools::encrypt(Tools::getValue('passwd'));
                            $customer->newsletter = 0;
                            $customer->optin = Tools::getValue('optin');
                            $customer->secure_key = md5(uniqid(rand(), true));
                            $customer->birthday = '';
                            $customer->active = 1;
                            $customer->is_guest = 0;

                            /**
                             * Add customer to database if not added send error message to user else authenticate user and send success message
                             * @date 28-02-2023
                             * @commenter Prvind Panday
                             */
                            if (!$customer->add()) {
                                $message = $this->module->l('An error occurred while creating your account.', 'verification');
                                $response['success'] = false;
                                $response['message'] = $message;
                            } else {
                                $customer->cleanGroups();
                                $customer->addGroups(array((int) Configuration::get('PS_CUSTOMER_GROUP')));
                                $this->sendConfirmationMail($customer, $kbPassword);
                                Hook::exec('actionCustomerAccountAdd', array(
                                    'newCustomer' => $customer
                                ));
                                $id_customer = $customer->id;
                               /**
                                * Commented the below code as we do not need the same.
                                * ASMar2024 actionAuthenticationBefore
                                * @date 08-03-2024
                                * @modifier Amit Singh
                                */
                                // Hook::exec('actionAuthenticationBefore');
                                //End of change by Amit
                                $customer = new Customer($id_customer);
                                $update_product_delivery = true;
                                if (Configuration::get('PS_CART_FOLLOWING') && (empty($this->context->cookie->id_cart) || Cart::getNbProducts($this->context->cookie->id_cart) == 0) && (int) Cart::lastNoneOrderedCart($customer->id)
                                ) {
                                    $update_product_delivery = false;
                                } else {
                                    $update_product_delivery = true;
                                }
                                $this->context->updateCustomer($customer);
                                Hook::exec('actionAuthentication', array(
                                        'customer' => $this->context->customer));
                                CartRule::autoRemoveFromCart($this->context);
                                CartRule::autoAddToCart($this->context);
                                $response['success'] = true;
                            }
                        } else {
                            $response['success'] = false;
                            $response['message'] = $error;
                        }
                    }
                }
            } else {
                $message = $this->module->l('Please input a valid mobile number.', 'verification');
                $response['success'] = false;
                $response['message'] = $message;
            }
            die(json_encode($response));
        }

        parent::initContent();
        $current_lang_id = $this->context->language->id;
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $total_active_country = $moduleobject->getCountries($current_lang_id);
        $this->context->smarty->assign('total_active_country', $total_active_country);
        $cookie_error = '';
        if (isset($this->context->cookie->kbcustom_error)) {
            $cookie_error = explode(',', $this->context->cookie->kbcustom_error);
            unset($this->context->cookie->kbcustom_error);
        }
        $cookie_success = '';
        if (isset($this->context->cookie->kbcustom_success)) {
            $cookie_success = $this->context->cookie->kbcustom_success;
            unset($this->context->cookie->kbcustom_success);
        }

        /**
         * If module is not enabled then redirect to home page else display the login by otp page
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if ($module_setting['enable']) {
            if ((bool) $this->context->customer->logged) {
                Tools::redirect(Context::getContext()->link->getPageLink('index', true));
            }
            $this->display_header = true;
            $this->display_footer = true;
            $this->display_column_left = false;
            $this->display_column_right = false;
            $this->context->smarty->assign('kb_mob_configuration', $module_setting);
            $login_reset = Tools::getIsset('reset') ? 'reset' : 'login';
            $this->context->smarty->assign('login_reset', $login_reset);
            if (Tools::getIsset('login')) {
                if ($module_setting['login_by_otp'] != '1') {
                    Tools::redirect(Context::getContext()->link->getPageLink('index', true));
                }
            }
            /**
             * If login or reset is set then display the login by otp page else redirect to home page
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            if (Tools::getIsset('login') || Tools::getIsset('reset')) {
                $this->context->smarty->assign('otp_type', 'login');
                if (Tools::getIsset('verifyotp')) {
                    $this->context->smarty->assign('otp_type', 'verifyotp');
                    $kbmobilenumber = $this->context->cookie->kbmobilenumber;
                    $kbcountryid = $this->context->cookie->kbcountryid;
                    $this->context->smarty->assign('kbmob_mobile_number', $kbmobilenumber);
                    $this->context->smarty->assign('kbmob_country_id', $kbcountryid);
                }
            } else {
                Tools::redirect(Context::getContext()->link->getPageLink('index', true));
            }
            $this->context->smarty->assign('cookie_error', $cookie_error);
            $this->context->smarty->assign('cookie_success', $cookie_success);
            $this->setTemplate("module:kbmobilelogin/views/templates/front/login_otp.tpl");
        } else {
            Tools::redirect(Context::getContext()->link->getPageLink('index', true));
        }
    }

    /** Prestashop Default Function in FrontController
     * @TODO uses redirectAdmin only if !$this->ajax
     * @date 23-03-2023
     * @commenter Prvind Panday
     * @return bool
     */
    public function postProcess()
    {
        parent::postProcess();
        $error = array();
        $moduleobject = new KbMobileLogin();
        $login_reset = Tools::getIsset('reset') ? 'reset=1' : 'login=1';
        /**
         * if submit type is kbSendOTP then send otp to user or if submit type is kbResendOTP then resend otp to user
         * @date 28-02-2023
         * @commenter Prvind Panday
         */
        if (Tools::isSubmit('kbSendOTP') || Tools::isSubmit('kbResendOTP')) {
            $country_id = Tools::getValue('kbmob_country_id');
            /**
             * Update type of $mobilenumber from string to int to avoid sql injection
             * @date 28-02-2023
             * @commenter Prvind Panday
             */
            $mobilenumber = (int)Tools::getValue('kbmob_mobile_number');
            //Check mobile number exist in system or not.
            $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND customer_id is not null AND customer_id != "" AND country_id = ' . pSQL($country_id));
            if ($mobilenumber_exist) {
                $customer_id = $mobilenumber_exist['customer_id'];
                $customer = Db::getInstance()->ExecuteS('SELECT * FROM `' . _DB_PREFIX_ . 'customer` WHERE id_customer = ' . pSQL($customer_id).' AND deleted = 0');
                /**
                 * Check if customer is active or not if not then show error message
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                if (empty($customer)) {
                    $error[] = $this->module->l('Your account is not active at this time.', 'verification');
                    $errorstring = implode(',', $error);
                    $this->context->cookie->__set('kbcustom_error', $errorstring);
                    $url = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
                    Tools::redirect($url . (strpos($url, '?') !== false ? '&' : '?') . $login_reset);
                } else {
                    /**
                     * if customer is active then send otp to customer and redirect to verification page with verifyotp=1
                     * @date 28-02-2023
                     * @commenter Prvind Panday
                     */
                    $message = '';
                    if ($moduleobject->sendOTP($country_id, $mobilenumber, $message)) {
                        $this->context->cookie->__set('kbcustom_success', $message);
                        $this->context->cookie->__set('kbmobilenumber', $mobilenumber);
                        $this->context->cookie->__set('kbcountryid', $country_id);
                        $url = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
                        Tools::redirect($url . (strpos($url, '?') !== false ? '&' : '?') . 'verifyotp=1&' . $login_reset);
                    } else {
                        /**
                         * if otp not send then show error message
                         * @date 28-02-2023
                         * @commenter Prvind Panday
                         */
                        $this->context->cookie->__set('kbcustom_error', $message);
                        $url = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
                        Tools::redirect($url . (strpos($url, '?') !== false ? '&' : '?') . $login_reset);
                    }
                }
            } else {
                /**
                 * if mobile number does not exist in system then show error message
                 * @date 28-02-2023
                 * @commenter Prvind Panday
                 */
                $error[] = $mobilenumber . ' ' . $this->module->l('Mobile number does not exist with any registered account', 'verification');
                $errorstring = implode(',', $error);
                $this->context->cookie->__set('kbcustom_error', $errorstring);
                $url = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
                Tools::redirect($url . (strpos($url, '?') !== false ? '&' : '?') . $login_reset);
            }
        }
        /**
         * if submit type is kbVerifyOTP then verify otp of user
         * @date 28-02-2023
         * @commenter Prvind Panday
         */
        if (Tools::isSubmit('kbVerifyOTP')) {
            $country_id = Tools::getValue('kbmob_country_id');
            /**
             * Update type of $mobilenumber from string to int to avoid sql injection
             * @date 28-02-2023
             * @commenter Prvind Panday
             */
            $mobilenumber = (int)Tools::getValue('kbmob_mobile_number');
            $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND customer_id is not null AND customer_id != "" AND country_id = ' . pSQL($country_id));
            /**
             * Check if mobile number exist in system or not and if exist then check if otp is correct or not
             * @date 28-02-2023
             * @commenter Prvind Panday
             */
            if ($mobilenumber_exist) {
                $message = '';
                if ($moduleobject->checkOTPValidation($country_id, $mobilenumber, $message, true)) {
                    $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND customer_id is not null AND customer_id != "" AND country_id = ' . pSQL($country_id));
                    $wrong_otp_count = $mobilenumber_exist['wrong_otp_count'];
                    $otp = $mobilenumber_exist['otp'];
                    if ($otp == Tools::getValue('kbmob_otp')) {
                        //Allow user to login

                        $customer_id = $mobilenumber_exist['customer_id'];
                        $customer = new Customer($customer_id);
                        /**
                         * Check if customer is active or not if not then show error message and redirect to login page
                         * @date 28-02-2023
                         * @commenter Prvind Panday
                         */
                        if (isset($customer->active) && !$customer->active) {
                            $error[] = $this->module->l('Your account is not active at this time.', 'login');
                        } else {
                            /**
                             * if customer is active then login customer and redirect to my account page
                             * @date 28-02-2023
                             * @commenter Prvind Panday
                             */
                            //Update new OTP in database corresponding to number
                            Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET otp = "", otp_count = "0", verified = 1, otp_sent_time = null, wrong_otp_count = "0" WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND country_id = ' . pSQL($country_id));
                            unset($this->context->cookie->kbmobilenumber);
                            unset($this->context->cookie->kbcountryid);
                            if ($login_reset == 'reset') {
                                // <editor-fold defaultstate="collapsed" desc="Reset Password Code">
                                if (!$customer->hasRecentResetPasswordToken()) {
                                    $customer->stampResetPasswordToken();
                                    $customer->update();
                                }
                                Tools::redirect($this->context->link->getPageLink('password', true, null, 'token=' . $customer->secure_key . '&id_customer=' . (int) $customer->id . '&reset_token=' . $customer->reset_password_token));
                                // </editor-fold>
                            } else {
                                // <editor-fold defaultstate="collapsed" desc="Customer Authentication Code">
                                $update_product_delivery = true;
                                if (Configuration::get('PS_CART_FOLLOWING') && (empty($this->context->cookie->id_cart) || Cart::getNbProducts($this->context->cookie->id_cart) == 0) && (int) Cart::lastNoneOrderedCart($customer->id)
                                ) {
                                    $update_product_delivery = false;
                                } else {
                                    $update_product_delivery = true;
                                }
                                /**
                                 * Update context of customer and redirect to home page
                                 * @date 28-02-2023
                                 * @commenter Prvind Panday
                                 */
                                $this->context->updateCustomer($customer);
                                Hook::exec('actionAuthentication', array(
                                    'customer' => $this->context->customer));
                                CartRule::autoRemoveFromCart($this->context);
                                CartRule::autoAddToCart($this->context);
                                Tools::redirect(Context::getContext()->link->getPageLink('index', true));
                                // </editor-fold>
                            }
                        }
                    } else {
                        $wrong_otp_count = $wrong_otp_count + 1;
                        Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET wrong_otp_count = "' . pSQL($wrong_otp_count) . '" WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND country_id = ' . pSQL($country_id));
                        $error[] = $this->module->l('You have entered invalid OTP.Please enter correct OTP.', 'verification');
                        $errorstring = implode(',', $error);
                        $this->context->cookie->__set('kbcustom_error', $errorstring);
                        /**
                         * Change made to fix the redirect URL 
                         * The issue was due redirect link was being creted. we are using the the class getModuleLink for generating lik butwe are passing the hardcoded string.
                         * ASDec2023 redirect_URL
                         * @date 26-12-2023
                         * @modifier Amit Singh
                         */
                        Tools:: redirect($this->context->link->getModuleLink('kbmobilelogin', 'verification',array('verifyotp' => 1, 'reset' => 1)));
                        //End Of Change
                    }
                } else {
                    $this->context->cookie->__set('kbcustom_error', $message);
                    /**
                     * Change made to fix the redirect URL 
                     * The issue was due redirect link was being creted. we are using the the class getModuleLink for generating lik butwe are passing the hardcoded string.
                     * ASDec2023 redirect_URL
                     * @date 26-12-2023
                     * @modifier Amit Singh
                     */
                    Tools:: redirect($this->context->link->getModuleLink('kbmobilelogin', 'verification', array('reset' => 1)));
                    //End Of Change
                }
            } else {
                $error[] = $mobilenumber . ' ' . $this->module->l('mobile number does not exist with any registered account.', 'verification');
                $errorstring = implode(',', $error);
                $this->context->cookie->__set('kbcustom_error', $errorstring);
                /**
                 * Change made to fix the redirect URL 
                 * The issue was due redirect link was being creted. we are using the the class getModuleLink for generating lik butwe are passing the hardcoded string.
                 * ASDec2023 redirect_URL
                 * @date 26-12-2023
                 * @modifier Amit Singh
                 */
                Tools:: redirect($this->context->link->getModuleLink('kbmobilelogin', 'verification', array($login_reset => 1)));
                //End Of Change
            }
        }
    }

    /*
     * Function for returning the URL of PrestaShop Root Modules Directory
     */

    private function getModuleDirUrl()
    {
        $module_dir = '';
        if ($this->checkSecureUrl()) {
            $module_dir = _PS_BASE_URL_SSL_ . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_);
        } else {
            $module_dir = _PS_BASE_URL_ . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_);
        }
        return $module_dir;
    }

    /*
     * Function for checking SSL
     */

    private function checkSecureUrl()
    {
        $custom_ssl_var = 0;
        if (isset($_SERVER['HTTPS']) && $_SERVER ['HTTPS'] == 'on') {
            $custom_ssl_var = 1;
        }
        if ((bool) Configuration:: get('PS_SSL_ENABLED') && $custom_ssl_var == 1) {
            return true;
        } else {
            return false;
        }
    }

    private function getRootDirUrl()
    {
        $root_dir = '';
        if ($this->checkSecureUrl()) {
            $root_dir = _PS_BASE_URL_SSL_ . __PS_BASE_URI__;
        } else {
            $root_dir = _PS_BASE_URL_ . __PS_BASE_URI__;
        }
        return $root_dir;
    }
    
    /**
     * Send confirmation mail to customer after registration
     * @param Customer $customer
     * @param string $passd
     * @return boolean
     * @date 28-02-2023
     * @commenter Prvind Panday
     */
    protected function sendConfirmationMail($customer, $passd)
    {
        if (!Configuration::get('PS_CUSTOMER_CREATION_EMAIL')) {
            return true;
        }

        return Mail::Send(
            $this->context->language->id,
            'account',
            Mail::l('Welcome!'),
            array(
                '{firstname}' => $customer->firstname,
                '{lastname}' => $customer->lastname,
                '{email}' => $customer->email,
                '{passwd}' => $passd
            ),
            $customer->email,
            $customer->firstname . ' ' . $customer->lastname
        );
    }
    
    /**
     * Check mobile number validation for min and max length 
     * @param array $mobile_login_setting
     * @param string $number
     * @return boolean
     * @date 28-02-2023
     * @commenter Prvind Panday
     */
    private function checkInputMobileValidation($mobile_login_setting, $number)
    {
        /**
         * Update $mobilenumber to $number variable from string to int to avoid sql injection
         * @date 28-02-2023
         * @commenter Prvind Panday
         */
        $kbMobileNumber = (int) $number;
        $mobileNumberLength = Tools::strlen($kbMobileNumber);
        if (($mobile_login_setting['min_mobile_length'] != '0') && ($mobileNumberLength < $mobile_login_setting['min_mobile_length'])) {
            return false;
        }
        if (($mobile_login_setting['max_mobile_length'] != '0') && ($mobileNumberLength > $mobile_login_setting['max_mobile_length'])) {
            return false;
        }
        return true;
    }
}
