<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2015 knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 */

    use Symfony\Component\Form\FormInterface;
    use Symfony\Component\Form\FormView;
    use PrestaShop\PrestaShop\Adapter\Category\CategoryDataProvider;
    use PrestaShop\PrestaShop\Core\Domain\Customer\ValueObject\FirstName;
    use PrestaShop\PrestaShop\Core\Domain\Customer\ValueObject\LastName;
    use PrestaShop\PrestaShop\Core\Domain\Customer\ValueObject\Password;
    use PrestaShopBundle\Form\Admin\Type\Material\MaterialChoiceTableType;
    use PrestaShopBundle\Form\Admin\Type\SwitchType;
    use PrestaShopBundle\Form\Admin\Type\DatePickerType;
    use PrestaShopBundle\Form\Admin\Type\CategoryChoiceTreeType;
    use PrestaShopBundle\Form\Admin\Type\ChoiceCategoriesTreeType;
    use PrestaShopBundle\Translation\TranslatorAwareTrait;
    use Symfony\Component\Form\AbstractType;
    use Symfony\Component\Form\Extension\Core\Type as FormType;
    use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
    use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
    use Symfony\Component\Form\Extension\Core\Type\EmailType;
    use Symfony\Component\Form\Extension\Core\Type\IntegerType;
    use Symfony\Component\Form\Extension\Core\Type\NumberType;
    use Symfony\Component\Form\Extension\Core\Type\PasswordType;
    use Symfony\Component\Form\Extension\Core\Type\TextType;
    use Symfony\Component\Form\Extension\Core\Type\TextareaType;
    use Symfony\Component\Form\FormBuilderInterface;
    use Symfony\Component\OptionsResolver\OptionsResolver;
    use Symfony\Component\Validator\Constraints\Email;
    use Symfony\Component\Validator\Constraints\Length;
    use Symfony\Component\Validator\Constraints\NotBlank;
    use Symfony\Component\Validator\Constraints\Type;
    use PrestaShopBundle\Form\Admin\Type\CountryChoiceType;

if (!defined('_PS_VERSION_')) {
    exit;
}
require_once(dirname(__FILE__) . '/classes/Twilio.php');
/*start:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
require_once(dirname(__FILE__) . '/classes/Prestasms.php');
require_once(dirname(__FILE__) . '/vendor/sendinblue.php');
/*end:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
define('KB_MOBILE_LOGIN_DEMO', false);

class KbMobileLogin extends Module
{

    public function __construct()
    {
        $this->name = 'kbmobilelogin';
        $this->tab = 'front_office_features';
        $this->version = '2.0.5';
        $this->author = 'Knowband';
        $this->need_instance = 0;
        $this->module_key = 'aad1cb90b77a6875d454c69b203414b1';
        $this->author_address = '0x2C366b113bd378672D4Ee91B75dC727E857A54A6';
        $this->module_key = '';
        $this->author_address = '';
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->custom_smarty = new Smarty();
        $this->custom_smarty->setTemplateDir(_PS_MODULE_DIR_ . 'kbmobilelogin/views/templates/admin/list');
        $this->bootstrap = true;
        parent::__construct(); /* Calling the parent constuctor method */
        $this->displayName = $this->l('Mobile Login');
        $this->description = $this->l('This module provides options to authenticate customer with moblile number');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
        if (!Configuration::get('KB_MOBILE_LOGIN')) {
            $this->warning = $this->l('No name provided');
        }
    }

    /*
     * Default prestashop function for installation
     */

    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }
        if (!parent::install() ||
            !$this->registerHook('displayHeader') ||
            !$this->registerHook('displayCustomerLoginFormAfter') ||
                //changes by vishal
            !$this->registerHook('displayCheckoutSummaryTop') ||
                //changes end
            !$this->registerHook('displayCustomerIdentityForm') ||
            !$this->registerHook('displayAdminCustomersForm') ||
            !$this->registerHook('actionCustomerAccountAdd') ||
            !$this->registerHook('actionOrderStatusPostUpdate') ||
            !$this->registerHook('postUpdateOrderStatus') ||
            !$this->registerHook('orderConfirmation') ||
            !$this->registerHook('actionCustomerAccountUpdate') ||
            !$this->registerHook('actionObjectCustomerUpdateAfter') ||
            !$this->registerHook('actionObjectCustomerAddAfter') ||
            !$this->registerHook('actionDeleteGDPRCustomer') ||
            !$this->registerHook('actionExportGDPRData') ||
            !$this->registerHook('actionObjectCustomerDeleteAfter') ||
            !$this->registerHook('displayCustomerAccountForm')
        ) {
            return false;
        }
        
        if (version_compare(_PS_VERSION_, '1.7.6.0', '>=')) {
            $this->registerHook('actionAfterUpdateCustomerFormHandler');
            $this->registerHook('actionCustomerFormBuilderModifier');
        }
        if (!Configuration::hasKey('KB_MOBILE_LOGIN')) {
            $defaultsettings = json_encode($this->getDefaultSettings());
            Configuration::updateValue('KB_MOBILE_LOGIN', $defaultsettings);
        }

        //Create email templates table
        $query = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "kbmobile_sms_detail` (
                `sms_detail_id` int(11) NOT NULL AUTO_INCREMENT,
                `mobile_number` varchar(100) NOT NULL,
                `message` text NOT NULL,
                `unique_sms_id` varchar(1000) NOT NULL,
                `is_error` int(1) NOT NULL DEFAULT '0',
                `error_message` text NOT NULL,
                `response` text NOT NULL,
                `sms_gateway` varchar(50) NOT NULL,
                `date_add` datetime NOT NULL,
                PRIMARY KEY (`sms_detail_id`)
               ) CHARACTER SET utf8 COLLATE utf8_general_ci";
        Db::getInstance()->execute($query);

        //Create user list who have tried spin wheel
        $query = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "kbmobile_sms_gateway_provider` (
                `sms_gateway_provider_id` int(11) NOT NULL AUTO_INCREMENT,
                `value` text,
                `label` text,
                PRIMARY KEY (`sms_gateway_provider_id`)
               ) CHARACTER SET utf8 COLLATE utf8_general_ci";
        Db::getInstance()->execute($query);
        //Create user list who have tried spin wheel
        $query = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "kbmobile_status_message` (
                `kb_mobile_status_id` int(11) NOT NULL AUTO_INCREMENT,
                `order_status_id` int(11) NOT NULL,
                `status` tinyint(4) NOT NULL,
                `date_added` datetime NOT NULL,
                `date_updated` datetime NOT NULL,
                PRIMARY KEY (`kb_mobile_status_id`)
               ) CHARACTER SET utf8 COLLATE utf8_general_ci";
        Db::getInstance()->execute($query);
        $query = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "kbmobile_status_message_lang` (
                `mobile_status_lang_id` int(11) NOT NULL AUTO_INCREMENT,
                `kb_mobile_status_id` int(11) NOT NULL,
                `lang_id` tinyint(4) NOT NULL,
                `description` varchar(8000) NOT NULL,
                PRIMARY KEY (`mobile_status_lang_id`)
               ) CHARACTER SET utf8 COLLATE utf8_general_ci";
        Db::getInstance()->execute($query);
        $query = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "kbmobile_user_detail` (
                `user_detail_id` int(11) NOT NULL AUTO_INCREMENT,
                `customer_id` int(11) DEFAULT NULL,
                `country_id` int(11) DEFAULT NULL,
                `mobilenumber` varchar(100) DEFAULT NULL,
                `verified` int(1) DEFAULT '0',
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                `otp` varchar(100) DEFAULT NULL,
                `otp_count` int(11) NOT NULL DEFAULT '0',
                `wrong_otp_count` int(11) NOT NULL DEFAULT '0',
                `otp_sent_time` varchar(20) DEFAULT NULL,
                PRIMARY KEY (`user_detail_id`),
                UNIQUE KEY `country_id` (`country_id`,`mobilenumber`)
               ) CHARACTER SET utf8 COLLATE utf8_general_ci";
        Db::getInstance()->execute($query);

        $query = 'SELECT * FROM ' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider';
        $smsGatewayExist = Db::getInstance()->executeS($query);
        
        if (!count($smsGatewayExist)) {
            $insertSql = 'INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider` (`value`, `label`) VALUES
            (\'{"twilio_account_sid":"","twilio_account_token":"","twilio_number":""}\', \'twilio\')';
            Db::getInstance()->execute($insertSql);
            /*start:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
            $insertSql = 'INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider` (`value`, `label`) VALUES
           (\'{"Access_key":"", "From":""}\', \'sendinblue\')';
            Db::getInstance()->execute($insertSql);
            $insertSql = 'INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider` (`value`, `label`) VALUES
           (\'{"id":"", "token":""}\', \'prestasms\')';
            Db::getInstance()->execute($insertSql);
            /*end:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
        } else if (count($smsGatewayExist)==1) {
            /*start:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
            $insertSql = 'INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider` (`value`, `label`) VALUES
           (\'{"Access_key":"", "From":""}\', \'sendinblue\')';
            Db::getInstance()->execute($insertSql);
            $insertSql = 'INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider` (`value`, `label`) VALUES
           (\'{"id":"", "token":""}\', \'prestasms\')';
            Db::getInstance()->execute($insertSql);
            /*end:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
        }


        return true;
    }

    public function uninstall()
    {
        if (!parent::uninstall() ||
            !$this->unregisterHook('displayHeader') ||
            !$this->unregisterHook('displayCustomerLoginFormAfter') ||
                //changes by vishal
            !$this->unregisterHook('displayCheckoutSummaryTop') ||
                //changes end
            !$this->unregisterHook('displayCustomerIdentityForm') ||
            !$this->unregisterHook('displayAdminCustomersForm') ||
            !$this->unregisterHook('actionCustomerAccountAdd') ||
            !$this->unregisterHook('actionOrderStatusPostUpdate') ||
            !$this->unregisterHook('postUpdateOrderStatus') ||
            !$this->unregisterHook('orderConfirmation') ||
            !$this->unregisterHook('actionCustomerAccountUpdate') ||
            !$this->unregisterHook('actionObjectCustomerUpdateAfter') ||
            !$this->unregisterHook('actionObjectCustomerAddAfter') ||
            !$this->unregisterHook('actionDeleteGDPRCustomer') ||
            !$this->unregisterHook('actionExportGDPRData') ||
            !$this->unregisterHook('actionObjectCustomerDeleteAfter') ||
            !$this->unregisterHook('displayCustomerAccountForm')
        ) {
            return false;
        }
        
        if (version_compare(_PS_VERSION_, '1.7.6.0', '>=')) {
            $this->unregisterHook('actionAfterUpdateCustomerFormHandler');
            $this->unregisterHook('actionCustomerFormBuilderModifier');
        }
        $this->uninstallDefaultSettings();
        return true;
    }

    /**
     * disable module
     * @param boolean $force_all
     * @return boolean
     */
    public function disable($force_all = false)
    {
        $this->uninstallDefaultSettings();
        return parent::disable($force_all);
    }

    private function uninstallDefaultSettings()
    {
        $settings = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $settings['enable'] = 0;
        Configuration::updateValue('KB_MOBILE_LOGIN', json_encode($settings));
    }

    /*
     * Default main prestashop function
     */

    public function getContent()
    {
        $output = '';
        if (isset($this->context->cookie->kb_redirect_success)) {
            $output .= $this->displayConfirmation($this->context->cookie->kb_redirect_success);
            unset($this->context->cookie->kb_redirect_success);
        }
        $this->setKbMedia();
        $languages = Language::getLanguages(false);
        $this->context->smarty->assign('show_toolbar', false);
        /**
         * Any request submitted in the admin settings form is handled here. It is checked if ajax submit is done or not.
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (Tools::isSubmit('ajax')) {
            /**
             * Ajax request is handled here. Tools::getValue('method') is used to get the method name.
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            $this->ajaxProcess(Tools::getValue('method'));
        }
        $form_value = array();

        /**
         * Any request submitted in the admin settings form is handled here. It is checked if submit is done or not.
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (Tools::isSubmit('submit' . $this->name)) {
            $form_value = Tools::getValue('kbmoblogin');
            $current_gateway_provider_id = $form_value['sms_gateway_provider'];
            /**
             * If current gateway provider id is not empty then update the value of sms gateway provider.
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            if (!Tools::isEmpty($current_gateway_provider_id)) {
                $sms_gateway_data = Tools::getValue('sms_gateway');
                $UpdateSql = 'UPDATE ' . _DB_PREFIX_ . 'kbmobile_sms_gateway_provider SET value="' . pSQL(json_encode($sms_gateway_data[$current_gateway_provider_id])) . '"  WHERE sms_gateway_provider_id =' . (int) $current_gateway_provider_id;
                Db::getInstance()->execute($UpdateSql);
            }

            $languages = Language::getLanguages(false);
            $error_count = 0;
            foreach ($languages as $lang) {
                $form_value['registration_message'][$lang['id_lang']] = Tools::getValue('registration_message_' . $lang['id_lang']);
                $form_value['otp_message'][$lang['id_lang']] = Tools::getValue('otp_message_' . $lang['id_lang']);
            }

            //If error is zero then update values
            /**
             * If no error is found then update the value of KB_MOBILE_LOGIN. If error is found then display error message.
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            if ($error_count == 0) {
                Configuration::updateValue('KB_MOBILE_LOGIN', json_encode($form_value));
                Tools::redirectAdmin(AdminController::$currentIndex . '&token=' . Tools::getAdminTokenLite('AdminModules') . '&configure=' . $this->name . '&conf=4');
            } else {
                $output .= $this->displayError($this->l('Something went wrong.Please try again.'));
            }
        }

        $form_value = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $selectSql = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_sms_gateway_provider";
        $gateway_list = Db::getInstance()->ExecuteS($selectSql);
        $gateway_options = array();
        $gateway_options[] = array(
            'id_option' => '',
            'name' => $this->l('Select SMS Gateway Provider')
        );
        foreach ($gateway_list as $gateway_details) {
            $gateway_options[] = array(
                'id_option' => $gateway_details['sms_gateway_provider_id'],
                'name' => self::getTranslatedText($gateway_details['label'])
            );
        }

        $this->fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('General Settings'),
                ),
                'input' => array(
                    array(
                        'label' => $this->l('Enable/Disable'),
                        'type' => 'switch',
                        'hint' => $this->l('Enable/Disable this plugin'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[enable]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[enable]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[enable]_off'
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Minimum length of mobile number'),
                        'required' => true,
                        'name' => 'kbmoblogin[min_mobile_length]',
                        'hint' => $this->l('It will be minimum length of mobile number. Length will be calculated excluding country dialing prefix'),
                        'desc' => $this->l('It will be minimum length of mobile number. Length will be calculated excluding country dialing prefix. Enter 0 for no limit on minimum length.'),
                        'col' => 2,
                        'maxlength' => 2
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Maximum length of mobile number'),
                        'required' => true,
                        'name' => 'kbmoblogin[max_mobile_length]',
                        'hint' => $this->l('It will be maximum length of mobile number. Length will be calculated excluding country dialing prefix'),
                        'desc' => $this->l('It will be maximum length of mobile number. Length will be calculated excluding country dialing prefix. Enter 0 for no limit on maximum length.'),
                        'col' => 2,
                        'maxlength' => 2
                    ),
                    array(
                        'label' => $this->l('Display mobile field on registration page'),
                        'type' => 'switch',
                        'hint' => $this->l('If Yes, then Mobile Field will display on registration page.'),
                        'desc' => $this->l('If Yes, then Mobile Field will display on registration page.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[show_mobile_on_registration]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[show_mobile_on_registration]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[show_mobile_on_registration]_off'
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Can user register without email-id ?'),
                        'type' => 'switch',
                        'hint' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'desc' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully. If Yes, then user can sign-up without email id.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[register_without_email]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[register_without_email]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[register_without_email]_off'
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Mobile number required during registration'),
                        'type' => 'switch',
                        'hint' => $this->l('If Yes, then mobile number will be required field on registration page.'),
                        'desc' => $this->l('If Yes, then mobile number will be required field on registration page.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[mobile_number_required]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[mobile_number_required]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[mobile_number_required]_off'
                                
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Display email field'),
                        'type' => 'switch',
                        'hint' => $this->l('If No, then Email field will not be display on registration page.'),
                        'desc' => $this->l('If No, then Email field will not be display on registration page.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[show_email_on_registration]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[show_email_on_registration]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[show_email_on_registration]_off'
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Mobile number must be verified during registration'),
                        'type' => 'switch',
                        'hint' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'desc' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully. If Yes, then mobile number verification by OTP will be mandatory before registration'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[verify_mobile_on_registration]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[verify_mobile_on_registration]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[verify_mobile_on_registration]_off'
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Temporary email format'),
                        'required' => true,
                        'name' => 'kbmoblogin[temp_email_format]',
                        'hint' => $this->l('For making compatible with PrestaShop default functioning a temporary email-id will be generated for the customer who registered with mobile number only.'),
                        'desc' => $this->l('For making compatible with PrestaShop default functioning a temporary email-id will be generated for the customer who registered with mobile number only. It should be in this format: @domain.com'),
                    ),
                    array(
                        'label' => $this->l('Login by mobile number and password'),
                        'type' => 'switch',
                        'hint' => $this->l('If Yes, then Customer can login by their Registered Mobile Number instead of using email-id.'),
                        'desc' => $this->l('If Yes, then Customer can login by their Registered Mobile Number instead of using email-id.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[login_by_mobile]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[login_by_mobile]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[login_by_mobile]_off'
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Mobile number must be verified for login'),
                        'type' => 'switch',
                        'hint' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'desc' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully. If Yes, then only verified customer can login by their mobile number otherwise all the customers (verified/unverified) can login by their mobile number.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[login_mobile_verified]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[login_mobile_verified]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[login_mobile_verified]_off'
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Login by OTP'),
                        'type' => 'switch',
                        'hint' => $this->l('If Yes, then Customer can login by getting OTP on their registered mobile number.'),
                        'desc' => $this->l('If Yes, then Customer can login by getting OTP on their registered mobile number.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[login_by_otp]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[login_by_otp]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[login_by_otp]_off'
                            ),
                        ),
                    ),
                    array(
                        'label' => $this->l('Send message on registration'),
                        'type' => 'switch',
                        'hint' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'desc' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[message_on_registration]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[message_on_registration]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[message_on_registration]_off'
                            ),
                        ),
                    ),
                    array(
                        'type' => 'textarea',
                        'lang' => true,
                        'label' => $this->l('Message to send on registration'),
                        'hint' => $this->l('Please input message which will be sent on successfull customer registration.'),
                        'desc' => $this->l('You can use following keyword to replace with actual value. {firstname}'),
                        'name' => 'registration_message',
                        'required' => true,
                        'cols' => '9',
                        'rows' => '5',
                    ),
                    array(
                        'label' => $this->l('Send message on change of order status'),
                        'type' => 'switch',
                        'hint' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'desc' => $this->l('Before enabling it make sure you have configured the SMS gateway provider\'s APIs Successfully.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[message_on_order_status_change]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[message_on_order_status_change]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[message_on_order_status_change]_off'
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('OTP length'),
                        'required' => true,
                        'name' => 'kbmoblogin[otp_length]',
                        'hint' => $this->l('Enter the OTP length value for OTP message. Values should be between 1 and 20 For example 5 or 20.'),
                        'desc' => $this->l('Enter the OTP length value for OTP message. Values should be between 1 and 20 For example 5 or 20.'),
                        'col' => 2,
                        'maxlength' => 2
                    ),
                    array(
                        'type' => 'textarea',
                        'lang' => true,
                        'label' => $this->l('Message to send with OTP'),
                        'hint' => $this->l('Include {otp} in the message it will be replaced by actual OTP (One Time Password) while sending SMS.'),
                        'desc' => $this->l('Include {otp} in the message it will be replaced by actual OTP (One Time Password) while sending SMS.'),
                        'name' => 'otp_message',
                        'required' => true,
                        'cols' => '9',
                        'rows' => '5',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Disable \'Resend OTP\' button for'),
                        'required' => true,
                        'col' => 3,
                        'maxlength' => 10,
                        'suffix' => $this->l('second(s)'),
                        'name' => 'kbmoblogin[otp_resend_duration]',
                        'hint' => $this->l('Duration after which resend button will enable, After sending the last OTP. Enter 0 to disable this feature.'),
                        'desc' => $this->l('Duration after which resend button will enable, After sending the last OTP. Enter 0 to disable this feature.'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('OTP expiration time'),
                        'required' => true,
                        'col' => 3,
                        'maxlength' => 10,
                        'suffix' => $this->l('second(s)'),
                        'name' => 'kbmoblogin[otp_expiration_duration]',
                        'hint' => $this->l('Duration after which OTP will get expired. Enter 0 if you don\'t want OTP to get expired.'),
                        'desc' => $this->l('Duration after which OTP will get expired. Enter 0 if you don\'t want OTP to get expired.'),
                    ),
                    array(
                        'label' => $this->l('Limit OTP request'),
                        'type' => 'switch',
                        'hint' => $this->l('If Yes, then user can request for OTP only limited no. of times in a row.'),
                        'desc' => $this->l('If Yes, then user can request for OTP only limited no. of times in a row.'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[otp_limit_request]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[otp_limit_request]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[otp_limit_request]_off'
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Number of OTP request'),
                        'required' => true,
                        'col' => 2,
                        'maxlength' => 2,
                        'name' => 'kbmoblogin[otp_request_count]',
                        'hint' => $this->l('No. of times user can request for OTP in a row, After that mobile number will be blocked for sometime.'),
                        'desc' => $this->l('No. of times user can request for OTP in a row, After that mobile number will be blocked for sometime.'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Block Duration'),
                        'required' => true,
                        'col' => 3,
                        'maxlength' => 5,
                        'suffix' => $this->l('minute(s)'),
                        'name' => 'kbmoblogin[otp_request_block_duration]',
                        'hint' => $this->l('Duration for which OTP can\'t be requested for mobile number verification after reaching OTP requesting limit.'),
                        'desc' => $this->l('Duration for which OTP can\'t be requested for mobile number verification after reaching OTP requesting limit.'),
                    ),
                    array(
                        'label' => $this->l('Limit wrong OTP attempt'),
                        'type' => 'switch',
                        'hint' => $this->l('If Yes, then user can enter wrong OTP only limited no. of times after that mobile number will be blocked'),
                        'desc' => $this->l('If Yes, then user can enter wrong OTP only limited no. of times after that mobile number will be blocked'),
                        'class' => 'optn_enable_disable',
                        'name' => 'kbmoblogin[otp_wrong_limit]',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kbmoblogin[otp_wrong_limit]_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kbmoblogin[otp_wrong_limit]_off'
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Number of wrong OTP attempt'),
                        'required' => true,
                        'col' => 2,
                        'maxlength' => 2,
                        'name' => 'kbmoblogin[otp_wrong_count]',
                        'hint' => $this->l('No. of times customer can enter wrong OTP in a row, After that mobile number will be blocked for sometime.'),
                        'desc' => $this->l('No. of times customer can enter wrong OTP in a row, After that mobile number will be blocked for sometime.'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Block Duration'),
                        'required' => true,
                        'col' => 2,
                        'maxlength' => 5,
                        'suffix' => $this->l('minute(s)'),
                        'name' => 'kbmoblogin[otp_wrong_block_duration]',
                        'hint' => $this->l('Duration for which mobile number will be blocked after reaching wrong OTP limit'),
                        'desc' => $this->l('Duration for which mobile number will be blocked after reaching wrong OTP limit'),
                    ),
                    array(
                        'label' => $this->l('Select SMS Gateway Provider'),
                        'type' => 'select',
                        'name' => 'kbmoblogin[sms_gateway_provider]',
                        'hint' => $this->l('Selected name will be show on wheel and for email marketing it will be used..'),
                        'is_bool' => true,
                        'onchange' => 'showHideGateWayOption(this)',
                        'options' => array(
                            'query' => $gateway_options,
                            'id' => 'id_option',
                            'name' => 'name',
                        ),
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                    'id' => 'kbmoblogin[velsof_privateshop_submit]',
                    'class' => 'btn btn-default pull-right btn_save_wheel velovalidation_mobilelogin',
                ),
            ),
        );

        /**
         * Add dynamic fields for SMS Gateway Provider
         * @date 22-03-2023
         * @commenter Prvind Panday
         */
        foreach ($gateway_list as $gateway_details) {
            $gateway_value_data = json_decode($gateway_details['value'], true);
            foreach ($gateway_value_data as $key_data => $value_data) {
                $this->fields_form['form']['input'][] = array(
                    'type' => 'text',
                    'label' => self::getTranslatedText($key_data),
                    'required' => true,
                    'class' => 'sms_gateway_provider_' . $gateway_details['sms_gateway_provider_id'],
                    'name' => "sms_gateway[" . $gateway_details['sms_gateway_provider_id'] . "][" . $key_data . "]",
                );
            }
        }

        /**
         * $previoue_saved_data is used to get the previous saved data of the module and $field_value is used to set the value of the field for the form persistance
         * @date 22-03-2023
         * @commenter Prvind Panday
         */
        $previouse_saved_data = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $field_value = array(
            'kbmoblogin[enable]' => isset($form_value['enable']) ? $form_value['enable'] : $previouse_saved_data['enable'],
            'kbmoblogin[min_mobile_length]' => isset($form_value['min_mobile_length']) ? $form_value['min_mobile_length'] : $previouse_saved_data['min_mobile_length'],
            'kbmoblogin[max_mobile_length]' => isset($form_value['max_mobile_length']) ? $form_value['max_mobile_length'] : $previouse_saved_data['max_mobile_length'],
            'kbmoblogin[show_mobile_on_registration]' => isset($form_value['show_mobile_on_registration']) ? $form_value['show_mobile_on_registration'] : $previouse_saved_data['show_mobile_on_registration'],
            'kbmoblogin[register_without_email]' => isset($form_value['register_without_email']) ? $form_value['register_without_email'] : $previouse_saved_data['register_without_email'],
            'kbmoblogin[mobile_number_required]' => isset($form_value['mobile_number_required']) ? $form_value['mobile_number_required'] : $previouse_saved_data['mobile_number_required'],
            'kbmoblogin[show_email_on_registration]' => isset($form_value['show_email_on_registration']) ? $form_value['show_email_on_registration'] : $previouse_saved_data['show_email_on_registration'],
            'kbmoblogin[verify_mobile_on_registration]' => isset($form_value['verify_mobile_on_registration']) ? $form_value['verify_mobile_on_registration'] : $previouse_saved_data['verify_mobile_on_registration'],
            'kbmoblogin[temp_email_format]' => isset($form_value['temp_email_format']) ? $form_value['temp_email_format'] : $previouse_saved_data['temp_email_format'],
            'kbmoblogin[login_by_mobile]' => isset($form_value['login_by_mobile']) ? $form_value['login_by_mobile'] : $previouse_saved_data['login_by_mobile'],
            'kbmoblogin[login_mobile_verified]' => isset($form_value['login_mobile_verified']) ? $form_value['login_mobile_verified'] : $previouse_saved_data['login_mobile_verified'],
            'kbmoblogin[login_by_otp]' => isset($form_value['login_by_otp']) ? $form_value['login_by_otp'] : $previouse_saved_data['login_by_otp'],
            'kbmoblogin[message_on_registration]' => isset($form_value['message_on_registration']) ? $form_value['message_on_registration'] : $previouse_saved_data['message_on_registration'],
            'kbmoblogin[message_on_order_status_change]' => isset($form_value['message_on_order_status_change']) ? $form_value['message_on_order_status_change'] : $previouse_saved_data['message_on_order_status_change'],
            'kbmoblogin[otp_length]' => isset($form_value['otp_length']) ? $form_value['otp_length'] : $previouse_saved_data['otp_length'],
            'kbmoblogin[otp_resend_duration]' => isset($form_value['otp_resend_duration']) ? $form_value['otp_resend_duration'] : $previouse_saved_data['otp_resend_duration'],
            'kbmoblogin[otp_expiration_duration]' => isset($form_value['otp_expiration_duration']) ? $form_value['otp_expiration_duration'] : $previouse_saved_data['otp_expiration_duration'],
            'kbmoblogin[otp_request_count]' => isset($form_value['otp_request_count']) ? $form_value['otp_request_count'] : $previouse_saved_data['otp_request_count'],
            'kbmoblogin[otp_request_block_duration]' => isset($form_value['otp_request_block_duration']) ? $form_value['otp_request_block_duration'] : $previouse_saved_data['otp_request_block_duration'],
            'kbmoblogin[otp_limit_request]' => isset($form_value['otp_limit_request']) ? $form_value['otp_limit_request'] : $previouse_saved_data['otp_limit_request'],
            'kbmoblogin[otp_wrong_limit]' => isset($form_value['otp_wrong_limit']) ? $form_value['otp_wrong_limit'] : $previouse_saved_data['otp_wrong_limit'],
            'kbmoblogin[otp_wrong_count]' => isset($form_value['otp_wrong_count']) ? $form_value['otp_wrong_count'] : $previouse_saved_data['otp_wrong_count'],
            'kbmoblogin[otp_wrong_block_duration]' => isset($form_value['otp_wrong_block_duration']) ? $form_value['otp_wrong_block_duration'] : $previouse_saved_data['otp_wrong_block_duration'],
            'kbmoblogin[sms_gateway_provider]' => isset($form_value['sms_gateway_provider']) ? $form_value['sms_gateway_provider'] : $previouse_saved_data['sms_gateway_provider'],
        );
        foreach ($languages as $lang) {
            if (!empty($form_value['registration_message'][$lang['id_lang']])) {
                $field_value['registration_message'][$lang['id_lang']] = $form_value['registration_message'][$lang['id_lang']];
            } else {
                $field_value['registration_message'][$lang['id_lang']] = $previouse_saved_data['registration_message'][$lang['id_lang']];
            }
            if (!empty($form_value['otp_message'][$lang['id_lang']])) {
                $field_value['otp_message'][$lang['id_lang']] = $form_value['otp_message'][$lang['id_lang']];
            } else {
                $field_value['otp_message'][$lang['id_lang']] = $previouse_saved_data['otp_message'][$lang['id_lang']];
            }
        }
        foreach ($gateway_list as $gateway_details) {
            $gateway_value_data = json_decode($gateway_details['value'], true);
            foreach ($gateway_value_data as $key_data => $value_data) {
                $field_value["sms_gateway[" . $gateway_details['sms_gateway_provider_id'] . "][" . $key_data . "]"] = $value_data;
            }
        }

        $custom_ssl_var = 0;
        if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
            $custom_ssl_var = 1;
        }
        if ((bool) Configuration::get('PS_SSL_ENABLED') && $custom_ssl_var == 1) {
            $ps_base_url = _PS_BASE_URL_SSL_;
        } else {
            $ps_base_url = _PS_BASE_URL_;
        }
        $languages = Language::getLanguages(false);


        //To pass is_Default parameter
        foreach ($languages as $k => $language) {
            $languages[$k]['is_default'] = ((int) ($language['id_lang'] == $this->context->language->id));
        }
        //To show available tabs
        /**
         * available_tabs_lang array is used to show the tab name in the language of the shop & available_tabs array is used to show the tab name in the language of the module
         * @date 22-03-2023
         * @commenter Prvind Panday
         */
        $this->available_tabs_lang = array(
            'General_Settings' => $this->l('General Settings'),
            'Registration_Page_Settings' => $this->l('Registration Page Settings'),
            'Login_Page_Settings' => $this->l('Login Page Settings'),
            'Sms_Notification_Settings' => $this->l('SMS Notification Settings'),
            'Otp_settings' => $this->l('OTP Settings'),
            'Sms_Gateway_Settings' => $this->l('SMS Gateway Settings'),
            'Mobile_Details_Settings' => $this->l('Mobile Detail Settings'),
        );

        $this->available_tabs = array(
            'General_Settings',
            'Registration_Page_Settings',
            'Login_Page_Settings',
            'Sms_Notification_Settings',
            'Otp_settings',
            'Sms_Gateway_Settings',
            'Mobile_Details_Settings');
        $this->tab_display = 'General_Settings';
        $product_tabs = array();

        foreach ($this->available_tabs as $product_tab) {
            $product_tabs[$product_tab] = array(
                'id' => $product_tab,
                'selected' => (Tools::strtolower($product_tab) == Tools::strtolower($this->tab_display) ||
                (isset($this->tab_display_module) && 'module' .
                $this->tab_display_module == Tools::strtolower($product_tab))),
                'name' => $this->available_tabs_lang[$product_tab],
                'href' => AdminController::$currentIndex . '&token=' . Tools::getAdminTokenLite('AdminModules'),
            );
        }
        //Helper form to generate form
        $helper = new HelperForm();
        $helper->module = $this;
        $helper->table = 'configuration';
        $helper->fields_value = $field_value;
        $helper->name_controller = $this->name;
        $helper->languages = $languages;
        $helper->default_form_language = $this->context->language->id;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->show_cancel_button = false;
        $helper->submit_action = 'submit' . $this->name;
        $form = $helper->generateForm(array(
            $this->fields_form));

        $this->context->smarty->assign('form', $form);  //Assigned form to template
        $this->context->smarty->assign('product_tabs', $product_tabs);
        $this->context->smarty->assign('path', $ps_base_url . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_) . $this->name . '/');
        $this->context->smarty->assign('root_path', $this->_path);
        $count_lang = count($languages);
        $this->context->smarty->assign('count_lang', $count_lang);
        $this->context->smarty->assign('language', $languages);
        $this->context->smarty->assign('language_id', $this->context->language->id);
        $email_lang = $this->context->language->id;
        $this->context->smarty->assign('email_lang', $email_lang);
        $this->context->smarty->assign('email_marketing_values', '');
        $path = $this->_path;
        $module_path = AdminController::$currentIndex . '&token=' . Tools::getAdminTokenLite('AdminModules') . '&configure=' . $this->name;
        $this->context->smarty->assign('module_path', $module_path); //module path
        $this->context->smarty->assign('path', $path);
        $this->context->smarty->assign('general_settings', $this->l('General Settings'));
        $this->context->smarty->assign('registration_page_settings', $this->l('Registration Page Settings'));
        $this->context->smarty->assign('login_page_settings', $this->l('Login Page Settings'));
        $this->context->smarty->assign('sms_notification_settings', $this->l('SMS Notification Settings'));
        $this->context->smarty->assign('otp_settings', $this->l('OTP Settings'));
        $this->context->smarty->assign('sms_gateway_settings', $this->l('SMS Gateway Settings'));
        $this->context->smarty->assign('mobile_details_settings', $this->l('Order State Message Settings'));
        $this->context->smarty->assign('firstCall', false);
        $this->context->smarty->assign('tab', $this->l($this->tab_display));

        $this->context->smarty->assign('current_ip', Tools::getRemoteAddr());
        $product_mapping = array();
        $this->context->smarty->assign(array(
            'KbcurrentToken' => Tools::getAdminTokenLite('AdminModules'),
            'controller_path' => $module_path,
            'product_mapping' => $product_mapping,
        ));
        $this->context->smarty->assign('path_fold', $module_path . '&ajaxproductaction=true&');

        $this->context->smarty->assign('default_tab', '');

        $list_status_message = $this->initListStatusMessageList();
        $this->context->smarty->assign('list_status_message', $list_status_message);

        //For pie chart graph used view
        $helper = new HelperView();
        $helper->module = $this;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->current = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->override_folder = 'helpers/';
        $helper->base_folder = 'view/';
        $helper->base_tpl = 'graph_custom.tpl';
        $view = $helper->generateView();
        $this->context->smarty->assign('view', $view);


        //Rendered custom tpl with helperForm class
        $tpl = 'Form_custom.tpl';
        $helper = new Helper();
        $helper->module = $this;
        $helper->override_folder = 'helpers/';
        $helper->base_folder = 'form/';
        $helper->setTpl($tpl);
        $tpl = $helper->generate();

        $output = $output . $tpl;
        return $output;
    }

    /*
     * Add admin media (CSS & JS)
     */

    public function setKbMedia()
    {
        $this->context->controller->addJs($this->getModuleDirUrl() . 'kbmobilelogin/views/js/velovalidation.js');
        $this->context->controller->addJs($this->getModuleDirUrl() . 'kbmobilelogin/views/js/admin/kbmobilelogin_admin.js');
        $this->context->controller->addCSS($this->getModuleDirUrl() . 'kbmobilelogin/views/css/admin/kbmobilelogin_admin.css');
        $this->context->controller->addJs($this->getModuleDirUrl() . 'kbmobilelogin/views/js/admin/kbmobilelogin_admin_validations.js');
    }

    /*
     * Insert default settings in configuration table while installing the 
     * @date 23-03-2023
     * @commenter Prvind Panday
     */

    private function getDefaultSettings()
    {
        $settings = array(
            'enable' => '0',
            'min_mobile_length' => '7',
            'max_mobile_length' => '12',
            'show_mobile_on_registration' => '0',
            'register_without_email' => '0',
            'mobile_number_required' => '0',
            'show_email_on_registration' => '0',
            'verify_mobile_on_registration' => '0',
            'temp_email_format' => '@domain.com',
            'login_by_mobile' => '0',
            'login_mobile_verified' => '0',
            'login_by_otp' => '0',
            'message_on_registration' => '0',
            'message_on_order_status_change' => '0',
            'otp_length' => '5',
            'otp_resend_duration' => '60',
            'otp_expiration_duration' => '300',
            'otp_request_count' => '5',
            'otp_request_block_duration' => '2',
            'otp_wrong_limit' => '0',
            'otp_limit_request' => '0',
            'sms_gateway_provider' => '1',
            'otp_wrong_count' => '3',
            'otp_wrong_block_duration' => '5'
        );
        foreach (Language::getLanguages(false) as $lang) {
            $settings['otp_message'][$lang['id_lang']] = 'Your OTP for Mobile Number Verification is {otp}. Do Not Share OTP with anyone.';
            $settings['registration_message'][$lang['id_lang']] = '';
        }
        return $settings;
    }

    /*
     * Function to check module url is secure or not
     */

    private function getModuleDirUrl()
    {
        $module_dir = '';
        if ($this->checkSecureUrl()) {
            $module_dir = _PS_BASE_URL_SSL_ . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_);
        } else {
            $module_dir = _PS_BASE_URL_ . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_);
        }
        return $module_dir;
    }

    /*
     * Function to check url is secure or not
     */

    private function checkSecureUrl()
    {
        $custom_ssl_var = 0;
        /**
         * Check if request is over ssl or not. returns true
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (isset($_SERVER['HTTPS'])) {
            if ($_SERVER['HTTPS'] == 'on') {
                $custom_ssl_var = 1;
            }
        } else if (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
            $custom_ssl_var = 1;
        }
        if ((bool) Configuration::get('PS_SSL_ENABLED') && $custom_ssl_var == 1) {
            return true;
        } else {
            return false;
        }
    }

    public function getTranslatedText($label_id)
    {
        $translation_array = array(
            'twilio' => $this->l('Twilio'),
            'sendinblue' => $this->l('SendinBlue'),
            'onehopsmsservice' => $this->l('Onehop (SMS-Magic)'),
            'twilio_account_sid' => $this->l('Twilio account SID'),
            'twilio_account_token' => $this->l('Twilio account token'),
            'twilio_number' => $this->l('Twilio number'),
            'sendinblue_api_key' => $this->l('Sendinblue API key'),
            'onehop_api_key' => $this->l('Onehop API key'),
            'sms_sender_id' => $this->l('SMS Sender ID'),
            /*start:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
            'prestasms' => $this->l('Prestasms'),
            'id' => $this->l('Id'),
            'token' => $this->l('Token'),
            'Access_key' => $this->l('Access Key'),
            'From' => $this->l('From'),
            /*END:changes made by aayushi on 6th June 2019 to add prestasms and sendinblue*/
        );
        if (isset($translation_array[$label_id])) {
            return $translation_array[$label_id];
        } else {
            return $label_id;
        }
    }

    protected function copyfolder($source, $destination)
    {
        $directory = opendir($source);
        mkdir($destination);
        while (($file = readdir($directory)) != false) {
            Tools::copy($source . '/' . $file, $destination . '/' . $file);
        }
        closedir($directory);
    }

    /**
     * get all countries with call prefix and country name in a specific language
     * @param int  $idLang        Language ID
     * @return Array Countries and corresponding zones
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function getCountries($idLang)
    {
        $countries = array();
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
		SELECT cl.`name` country, c.`call_prefix` prefix, c.id_country 
		FROM `' . _DB_PREFIX_ . 'country` c ' . Shop::addSqlAssociation('country', 'c') . '
		LEFT JOIN `' . _DB_PREFIX_ . 'country_lang` cl ON (c.`id_country` = cl.`id_country` AND cl.`id_lang` = ' . (int) $idLang . ')
		WHERE 1 AND c.active = 1 and c.call_prefix is not null and c.call_prefix != "" ORDER BY cl.name ASC');

        foreach ($result as $row) {
            $countries[] = $row;
        }

        return $countries;
    }

    /**
     * generates the otp code for the customer
     * @param int  $digits        number of digits in otp
     * @return int otp code
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function generateOTP($digits = 4)
    {
        /**
         * If demo mode is enabled then return 123456 for testing purpose
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (KB_MOBILE_LOGIN_DEMO) {
            return '123456';
        }
        $i = 0; //counter
        $pin = ""; //our default pin is blank.
        while ($i < $digits) {
            $pin .= mt_rand(0, 9);
            $i++;
        }
        return $pin;
    }

    public function getCallPrefixByCountryId($country_id)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('SELECT call_prefix FROM `' . _DB_PREFIX_ . 'country`  where id_country = ' . (int) $country_id);
        return $result;
    }

    private function getCustomerMobileNumberById($customer_id)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('SELECT mobilenumber FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail`  where customer_id = ' . (int) $customer_id);
        return $result;
    }

    private function getCustomerCountryIdById($customer_id)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('SELECT country_id FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail`  where customer_id = ' . (int) $customer_id);
        return $result;
    }

    /**
     * sendMessage function is used to send message to customer mobile number
     * @param int $country_id
     * @param int $mobile_number
     * @param string $message
     * @return boolean
     * @date 22-03-2023
     * @commenter Prvind Panday
     */
    public function sendMessage($country_id, $mobile_number, $message)
    {
        /**
         * if KB_MOBILE_LOGIN_DEMO is true then it will return true and you can use 123456 as OTP for testing else it will send otp to customer mobile number
         * @date 22-03-2023
         * @commenter Prvind Panday
         */
        if (KB_MOBILE_LOGIN_DEMO) {
            return true;
        }
        $return = false;
        try {
            $settings = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
            $sms_gateway_provider = $settings['sms_gateway_provider'];
            /**
             * if sms_gateway_provider is not empty then it will send sms to customer mobile number
             * @date 22-03-2023
             * @commenter Prvind Panday
             */
            if (!Tools::isEmpty($sms_gateway_provider)) {
                $selectSql = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_sms_gateway_provider where sms_gateway_provider_id = " . (int) $sms_gateway_provider;
                $gatewayDetails = Db::getInstance()->getRow($selectSql);
                $gateway_value_data = json_decode($gatewayDetails['value'], true);
                /**
                 * $class is used to get class name of sms gateway provider and $obj is used to create object of that class. Tools::ucfirst is used to convert first letter of string to uppercase
                 * @date 22-03-2023
                 * @commenter Prvind Panday
                 */
                $class = Tools::ucfirst($gatewayDetails['label']);
                $obj = new $class($gateway_value_data);
                $call_prefix = $this->getCallPrefixByCountryId($country_id);
                /**
                 * if $obj->sendSMS is true then it will return true else it will return false
                 * @date 22-03-2023
                 * @commenter Prvind Panday
                 */
                if ($obj->sendSMS($call_prefix, $mobile_number, $message)) {
                    $return = true;
                } else {
                    $return = false;
                }
            } else {
                $return = false;
            }
        } catch (Exception $exc) {
            echo $exc->getTraceAsString();
            $return = false;
        }
        return $return;
    }

    public function checkMobileNumberExist($countryCode, $mobileNumber, $detail = false, $customerId = '')
    {
        /**
         * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
         * @date 23-02-2023
         * @commenter Prvind Panday
         */
        $number = (int) $mobileNumber;
        $mobileNumberExistSQL = 'SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($number) . '" AND country_id = "' . (int) $countryCode . '"';
        if (!Tools::isEmpty($customerId)) {
            $mobileNumberExistSQL.=' AND customer_id != "' . (int) $customerId . '"';
        } else {
            $mobileNumberExistSQL.=' AND (customer_id != "" OR customer_id is not null)';
        }
        $mobileNumberExist = Db::getInstance()->getRow($mobileNumberExistSQL);
        if ($mobileNumberExist) {
            /**
             * Changes to check if customer is deleted or not, if deleted we allow new customer to have that mobile number
             * @date 23-02-2023
             * @commenter Prvind Panday
             */
            $checkIfDeletedCustomer = Db::getInstance()->ExecuteS('SELECT * FROM `' . _DB_PREFIX_ . 'customer` WHERE id_customer = "' . (int) $mobileNumberExist['customer_id'] . '"');
            if (empty($checkIfDeletedCustomer)) {
                return false;
            } else {
                if ($detail) {
                    return $mobileNumberExist;
                } else {
                    return true;
                }
            }
        } else {
            return false;
        }
    }
    
    public function hookDisplayHeader()
    {
        /**
         * Added a condition to check if the page is registration page or not only applicable for prestashop 8.0.0
         * @date 15-03-2023
         * @author Prvind Panday
         */
        if (($this->context->controller->php_self == 'authentication') || ($this->context->controller->php_self == 'registration') || ($this->context->controller->php_self == 'identity') || ($this->context->controller->php_self == 'order') || ($this->context->controller->php_self == 'password') || (isset($this->context->controller->page_name) && ($this->context->controller->page_name == 'module-kbmobilelogin-verification'))) {
            $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
            if ($module_setting['enable']) {
                $this->context->smarty->assign('kb_mob_configuration', $module_setting);
                $this->context->smarty->assign('kb_form_name', $this->context->controller->php_self);
                 
                /**
                 * Assigning the temp_email_format to smarty to use in tpl file
                 * As the variable is being used in the JS file but missed assigned in the smarty variable
                 * ASMar2024 email_formate_variables
                 * @date 06-03-2024
                 * @author Amit Singh
                 */
                $this->context->smarty->assign('temp_email_format', $module_setting['temp_email_format']);
                /**End of change */

                $link = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
                $this->context->smarty->assign('kbmobile_front_url', $link);
                $this->context->controller->addJS($this->_path . 'views/js/velovalidation.js');
                $this->context->controller->addJS($this->_path . 'views/js/front/front_validation.js');
                return $this->display(__FILE__, 'views/templates/hook/kb_header.tpl');
            }
        }
    }

    /*
     * Function to display Custom Field in Admin Customer Edit Page
     * @param array $params
     * @date 22-03-2023
     * @commenter Prvind Panday
     */
    public function hookDisplayAdminCustomersForm($params)
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            $current_lang_id = $this->context->language->id;
            $customer_id = Tools::getValue('id_customer');
            $mobilenumber_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"');
            $country_id = '';
            $mobilenumber = '';
            $verified = 0;
            if ($mobilenumber_details) {
                $country_id = $mobilenumber_details['country_id'];
                $mobilenumber = $mobilenumber_details['mobilenumber'];
                $verified = $mobilenumber_details['verified'];
            }
            $total_active_country = $this->getCountries($current_lang_id);
            $this->context->smarty->assign('total_active_country', $total_active_country);
            $this->context->smarty->assign('kb_mob_configuration', $module_setting);
            $this->context->smarty->assign('kb_country_id', $country_id);
            $this->context->smarty->assign('kb_mobilenumber', $mobilenumber);
            $this->context->smarty->assign('kb_verified', $verified);
            $this->context->smarty->assign('current_customer_id', $customer_id);
            $link = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
            $this->context->smarty->assign('kbmobile_front_url', $link);
            $this->context->controller->addJS($this->_path . 'views/js/velovalidation.js');
            $this->context->controller->addJS($this->_path . 'views/js/admin/kbmobile_admin_validation.js');
            return $this->display(__FILE__, 'views/templates/hook/field_customer_admin.tpl');
        }
    }

    /*
     * Function to display Edit Custom Fields
     * in the My Account->Your Personal Information page
     */

    public function hookDisplayCustomerIdentityForm()
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            $current_lang_id = $this->context->language->id;
            $customer_id = $this->context->customer->id;
            $mobilenumber_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"');

            $country_id = '';
            $verified = 0;
            $mobilenumber = '';
            if ($mobilenumber_details) {
                $country_id = $mobilenumber_details['country_id'];
                $mobilenumber = $mobilenumber_details['mobilenumber'];
                $verified = $mobilenumber_details['verified'];
            }
            $total_active_country = $this->getCountries($current_lang_id);
            $this->context->smarty->assign('total_active_country', $total_active_country);
            $this->context->smarty->assign('kb_mob_configuration', $module_setting);
            $this->context->smarty->assign('kb_country_id', $country_id);
            $this->context->smarty->assign('kb_mobilenumber', $mobilenumber);
            $link = $this->context->link->getModuleLink('kbmobilelogin', 'verification');
            $this->context->smarty->assign('kbmobile_front_url', $link);
            $this->context->smarty->assign('current_customer_id', $customer_id);
            $this->context->smarty->assign('kb_mobile_verified', $verified);
            $custom_ssl_var = 0;
            if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
                $custom_ssl_var = 1;
            }
            if ((bool) Configuration::get('PS_SSL_ENABLED') && $custom_ssl_var == 1) {
                $ps_base_url = _PS_BASE_URL_SSL_;
            } else {
                $ps_base_url = _PS_BASE_URL_;
            }
            $this->context->smarty->assign('module_path', $ps_base_url . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_) . $this->name . '/');

            return $this->display(__FILE__, 'views/templates/hook/field_display_identity.tpl');
        }
    }

    /*
     * Function to display Custom Fields in the Registration Page
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function hookDisplayCustomerAccountForm()
    {
        if ($this->context->controller->php_self != 'identity') {
            $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
            if ($module_setting['enable']) {
                $current_lang_id = $this->context->language->id;
                $country_id = '';
                $mobilenumber = '';
                $total_active_country = $this->getCountries($current_lang_id);
                $this->context->smarty->assign('total_active_country', $total_active_country);
                $this->context->smarty->assign('kb_mob_configuration', $module_setting);
                $this->context->smarty->assign('kb_country_id', $country_id);
                $this->context->smarty->assign('kb_mobilenumber', $mobilenumber);

                $this->context->smarty->assign('current_customer_id', '');
                $this->context->smarty->assign('kb_mobile_verified', '0');
                $custom_ssl_var = 0;
                if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
                    $custom_ssl_var = 1;
                }
                if ((bool) Configuration::get('PS_SSL_ENABLED') && $custom_ssl_var == 1) {
                    $ps_base_url = _PS_BASE_URL_SSL_;
                } else {
                    $ps_base_url = _PS_BASE_URL_;
                }
                $this->context->smarty->assign('module_path', $ps_base_url . __PS_BASE_URI__ . str_replace(_PS_ROOT_DIR_ . '/', '', _PS_MODULE_DIR_) . $this->name . '/');
                return $this->display(__FILE__, 'views/templates/hook/field_display_identity.tpl');
            }
        } else {
            return $this->hookDisplayCustomerIdentityForm();
        }
    }

    public function hookDisplayCustomerLoginFormAfter()
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            $this->context->smarty->assign('kblastemailvalue', Tools::getValue('kblastemailvalue', ''));
            $this->context->smarty->assign('login_by_otp', $module_setting['login_by_otp']);
            return $this->display(__FILE__, 'views/templates/hook/loginform-after.tpl');
        }
    }
    
    //changes by vishal on 21 july 2020 for resolving the login issue on order page
    public function hookDisplayCheckoutSummaryTop()
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            $this->context->smarty->assign('kblastemailvalue', Tools::getValue('kblastemailvalue', ''));
            $this->context->smarty->assign('login_by_otp', $module_setting['login_by_otp']);
            if (Tools::getvalue('controller') == "order") {
                $this->context->smarty->assign('kb_add_required_js', 1);
            }
            return $this->display(__FILE__, 'views/templates/hook/loginform-after.tpl');
        }
    }
    //changes end
    
    public function hookActionDeleteGDPRCustomer($customer)
    {
        if (!empty($customer['email']) && Validate::isEmail($customer['email'])) {
            if (Module::isInstalled('kbmobilelogin')) {
                $id_customer = Customer::customerExists($customer['email'], true, false);
                if (!empty($id_customer)) {
                    $sql = 'Delete FROM ' . _DB_PREFIX_ . 'kbmobile_user_detail WHERE customer_id ='.(int)$id_customer;
                    if (Db::getInstance()->execute($sql)) {
                        return json_encode(true);
                    }
                }
                return json_encode($this->l('Mobile Login: No user found with this email.'));
            }
        }
    }
    
    
    public function hookActionExportGDPRData($customer)
    {
        if (!empty($customer['email']) && Validate::isEmail($customer['email'])) {
            if (Module::isInstalled('kbmobilelogin')) {
                $id_customer = Customer::customerExists($customer['email'], true, false);
                if (!empty($id_customer)) {
                    $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'kbmobile_user_detail WHERE customer_id ='.(int)$id_customer;
                    if ($res = Db::getInstance()->executeS($sql)) {
                        return json_encode($res);
                    }
                }
                return json_encode($this->l('Mobile Login : No User found with this email.'));
            }
        }
    }

    /**
     * Saves the customer mobile number and country id in the database when customer registers
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function hookActionCustomerAccountAdd($params)
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            if ($module_setting['show_mobile_on_registration']) {
                $customer_id = $params['newCustomer']->id;
                $country_id = trim(Tools::getValue('kbmob_country_id', ''));
                /**
                 * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
                 * @date 23-02-2023
                 * @commenter Prvind Panday
                 */
                $mobilenumber = (int) trim(Tools::getValue('kbmob_mobile_number', ''));
                if (($country_id != '') || ($mobilenumber != '')) {
                    $SelectSQL = 'SELECT verified FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND country_id = ' . pSQL($country_id);
                    $verified_status = Db::getInstance()->getValue($SelectSQL);
                    $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '"  AND country_id = ' . pSQL($country_id);
                    Db::getInstance()->execute($DeleteSQL);
                    Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_user_detail` (customer_id, country_id, mobilenumber, verified, date_add, date_upd)'
                        . ' VALUES ("' . pSQL($customer_id) . '" , "' . pSQL($country_id) . '" , "' . pSQL($mobilenumber) . '" , "' . (int) $verified_status . '" , now() , now())');
                }
            }
            $current_lang_id = $this->context->language->id;
            /**
             * Send message to customer on registration if enabled from back office
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            if ($module_setting['message_on_registration']) {
                $registration_message = $module_setting['registration_message'][$current_lang_id];
                $registration_message = str_replace("{firstname}", $params['newCustomer']->firstname, $registration_message);
                $this->sendMessage($country_id, $mobilenumber, $registration_message);
            }
        }
    }

    public function hookActionCustomerAccountUpdate($params)
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            if ($module_setting['show_mobile_on_registration']) {
                $customer_id = $params['customer']->id;
                $country_id = trim(Tools::getValue('kbmob_country_id', ''));
                /**
                 * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
                 * @date 23-02-2023
                 * @commenter Prvind Panday
                 */
                $mobilenumber = (int) trim(Tools::getValue('kbmob_mobile_number', ''));
                if (($country_id != '') || ($mobilenumber != '')) {
                    $SelectSQL = 'SELECT verified FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND country_id = ' . pSQL($country_id);
                    $verified_status = Db::getInstance()->getValue($SelectSQL);
                    $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"';
                    Db::getInstance()->execute($DeleteSQL);
                    $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" and country_id = "' . pSQL($country_id) . '"';
                    Db::getInstance()->execute($DeleteSQL);
                    Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_user_detail` (customer_id, country_id, mobilenumber, verified, date_add, date_upd)'
                        . ' VALUES ("' . pSQL($customer_id) . '" , "' . pSQL($country_id) . '" , "' . pSQL($mobilenumber) . '" , "' . (int) $verified_status . '" , now() , now())');
                }
            }
        }
    }

    public function hookActionObjectCustomerAddAfter($params)
    {
        if (isset($this->context->controller->controller_name) && ($this->context->controller->controller_name == 'AdminCustomers')) {
            $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
            if (($module_setting['enable']) && (Tools::getIsset('verified'))) {
                if ($module_setting['show_mobile_on_registration']) {
                    $customer_id = $params['object']->id;
                    $country_id = trim(Tools::getValue('kbmob_country_id'));
                    /**
                     * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
                     * @date 23-02-2023
                     * @commenter Prvind Panday
                     */
                    $mobilenumber = (int) trim(Tools::getValue('kbmob_mobile_number'));
                    $verified = Tools::getValue('verified');
                    if (($country_id != '') || ($mobilenumber != '')) {
                        $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"';
                        Db::getInstance()->execute($DeleteSQL);
                        $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" and country_id = "' . pSQL($country_id) . '"';
                        Db::getInstance()->execute($DeleteSQL);
                        Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_user_detail` (customer_id, country_id, mobilenumber, verified, date_add, date_upd)'
                            . ' VALUES ("' . pSQL($customer_id) . '" , "' . pSQL($country_id) . '" , "' . pSQL($mobilenumber) . '" , "' . (int) $verified . '" , now() , now())');
                    }
                }
            }
        }
    }

    public function hookActionObjectCustomerUpdateAfter($params)
    {
        if (isset($this->context->controller->controller_name) && ($this->context->controller->controller_name == 'AdminCustomers')) {
            $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
            if (($module_setting['enable']) && (Tools::getIsset('verified'))) {
                if ($module_setting['show_mobile_on_registration']) {
                    $customer_id = Tools::getValue('id_customer');
                    $country_id = trim(Tools::getValue('kbmob_country_id'));
                    /**
                     * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
                     * @date 23-02-2023
                     * @commenter Prvind Panday
                     */
                    $mobilenumber = (int) trim(Tools::getValue('kbmob_mobile_number'));
                    $verified = Tools::getValue('verified');
                    if (($country_id != '') || ($mobilenumber != '')) {
                        $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"';
                        Db::getInstance()->execute($DeleteSQL);
                        $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" and country_id = "' . pSQL($country_id) . '"';
                        Db::getInstance()->execute($DeleteSQL);
                        Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_user_detail` (customer_id, country_id, mobilenumber, verified, date_add, date_upd)'
                            . ' VALUES ("' . pSQL($customer_id) . '" , "' . pSQL($country_id) . '" , "' . pSQL($mobilenumber) . '" , "' . (int) $verified . '" , now() , now())');
                    }
                }
            }
        }
    }

    /**
     * Function to check OTP validation
     * @param int $country_id
     * @param int $mobilenumber
     * @param string $errorMessage
     * @param boolean $verifyOTP
     * @param boolean $checkMobileNumberAvailbility
     * @return boolean
     * @date 23-02-2023
     * @commenter Prvind Panday
     */
    public function checkOTPValidation($country_id, $mobilenumber, &$errorMessage, $verifyOTP = false, $checkMobileNumberAvailbility = false)
    {
        $otp_request_error = false;
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        //Get Mobile OTP Details
        /**
         * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
         * @date 23-02-2023
         * @commenter Prvind Panday
         */
        $number = (int) $mobilenumber;
        $mobilenumber_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($number) . '" AND  country_id = ' . pSQL($country_id));
        if ($mobilenumber_details) {
            $current_timestamp = time();
            $otp_sent_time = $mobilenumber_details['otp_sent_time'];

            // <editor-fold defaultstate="collapsed" desc="Block OTP if user cross maximum OTP request limit">
            if (!$otp_request_error) {
                if (!$verifyOTP) {
                    if ($module_setting['otp_limit_request']) {
                        $otp_count = $mobilenumber_details['otp_count'];
                        $otp_request_count = $module_setting['otp_request_count'];
                        /**
                         * Check if OTP request count is less than or equal to maximum OTP request count then reset OTP count and OTP sent time
                         * @date 23-02-2023
                         * @commenter Prvind Panday
                         */
                        if ($otp_request_count <= $otp_count) {
                            $otp_request_block_duration = $module_setting['otp_request_block_duration'];
                            $otp_sent_timestamp = $otp_sent_time + ($otp_request_block_duration * 60);
                            if ($current_timestamp > $otp_sent_timestamp) {
                                /**
                                 * Update $mobilenumber to $number variable from string to int to avoid sql injection
                                 * @date 23-02-2023
                                 * @commenter Prvind Panday
                                 */
                                Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET otp_count = "0", otp = null, otp_sent_time = null WHERE mobilenumber = "' . pSQL($number) . '" AND country_id = ' . pSQL($country_id));
                            } else {
                                /**
                                 * error message if user cross maximum OTP request limit and OTP request block duration is not over
                                 * @date 23-02-2023
                                 * @commenter Prvind Panday
                                 */
                                $errorMessage = $this->l('You have crossed maximum limit of OTP request. You can request for next OTP after #d minutes');
                                $errorMessage = str_replace("#d", $otp_request_block_duration, $errorMessage);
                                $otp_request_error = true;
                            }
                        }
                    }
                }
            }
            // </editor-fold>
            // <editor-fold defaultstate="collapsed" desc="Block OTP if user cross maximum wrong OTP limit">
            if (!$otp_request_error) {
                if ($module_setting['otp_wrong_limit']) {
                    $otp_wrong_count = $module_setting['otp_wrong_count'];
                    $wrong_otp_count = $mobilenumber_details['wrong_otp_count'];
                    if ($otp_wrong_count <= $wrong_otp_count) {
                        $otp_wrong_block_duration = $module_setting['otp_wrong_block_duration'];
                        $otp_sent_timestamp = $otp_sent_time + ($otp_wrong_block_duration * 60);
                        if ($current_timestamp > $otp_sent_timestamp) {
                            /**
                             * Update $mobilenumber to $number variable from string to int to avoid sql injection
                             * @date 23-02-2023
                             * @commenter Prvind Panday
                             */
                            Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET wrong_otp_count = "0", otp = null, otp_sent_time = null WHERE mobilenumber = "' . pSQL($number) . '" AND country_id = ' . pSQL($country_id));
                        } else {
                            /**
                             * error message if user cross maximum wrong OTP limit and OTP wrong block duration is not over
                             * @date 23-02-2023
                             * @commenter Prvind Panday
                             */
                            $errorMessage = $this->l('You have crossed maximum limit of wrong OTP request. You can request for next OTP after #d minutes');
                            $errorMessage = str_replace("#d", $otp_wrong_block_duration, $errorMessage);
                            $otp_request_error = true;
                        }
                    }
                }
            }
            // </editor-fold>
            // <editor-fold defaultstate="collapsed" desc="BLOCK OTP if resend time is not over">
            if (!$otp_request_error) {
                if (!$verifyOTP) {
                    if ($module_setting['otp_resend_duration']) {
                        $otp_sent_timestamp = $otp_sent_time + (int) $module_setting['otp_resend_duration'];
                        if ($current_timestamp < $otp_sent_timestamp) {
                            $errorMessage = $this->l('Please wait for #d seconds before requesting for another OTP');
                            $errorMessage = str_replace("#d", $otp_sent_timestamp - $current_timestamp, $errorMessage);
                            $otp_request_error = true;
                        }
                    }
                }
            }
            // </editor-fold>
            // <editor-fold defaultstate="collapsed" desc="Check OTP is expired or not">
            if (!$otp_request_error) {
                if ($verifyOTP) {
                    if ($module_setting['otp_expiration_duration']) {
                        $otp_expiration_timestamp = $otp_sent_time + (int) $module_setting['otp_expiration_duration'];
                        if ($current_timestamp > $otp_expiration_timestamp) {
                            $errorMessage = $this->l('Entered OTP has been expired. Please send OTP again.');
                            $otp_request_error = true;
                        }
                    }
                }
            }
            /**
             * Check if mobile number is already registered with other customer
             * @date 23-02-2023
             * @commenter Prvind Panday
             */
            if (!$otp_request_error) {
                if ($checkMobileNumberAvailbility) {
                    /**
                     * Update $mobilenumber to $number variable from string to int to avoid sql injection
                     * @date 23-02-2023
                     * @commenter Prvind Panday
                     * @comment Added condition to check if customer is logged in then check mobile number is not assigned to other customer
                     */
                    if ($this->context->customer->id) {
                        $mobilenumber_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($number) . '" AND customer_id != '.$this->context->customer->id.' AND country_id = ' . pSQL($country_id));
                    } else {
                        $mobilenumber_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($number) . '" AND country_id = ' . pSQL($country_id).' AND customer_id != 0');
                    }
                    if (!empty($mobilenumber_details)) {
                        $customer_id = $mobilenumber_details['customer_id'];
                        $customer = Db::getInstance()->ExecuteS('SELECT * FROM `' . _DB_PREFIX_ . 'customer` WHERE id_customer = ' . pSQL($customer_id).' AND deleted = 0');
                        if (!empty($customer)) {
                            $errorMessage = $this->l('Mobile number already exist with some other account.');
                            $otp_request_error = true;
                        }
                    }
                }
            }
            // </editor-fold>
        }
        return !$otp_request_error;
    }

    /**
     * Function to send OTP to mobile number
     * @param int $country_id
     * @param string $number
     * @param string $errorMessage
     * @return boolean
     * @date 23-02-2023
     * @commenter Prvind Panday
     */
    public function sendOTP($country_id, $number, &$errorMessage)
    {
        /**
         * Update $number to $mobilenumber variable from string to int to avoid sql injection
         * @date 23-02-2023
         * @commenter Prvind Panday
         */
        $mobilenumber = (int)$number;
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $errorMessage = '';
        /**
         * Check if the otp is valid or not and return error message if not valid
         * @date 23-02-2023
         * @commenter Prvind Panday
         */
        if ($this->checkOTPValidation($country_id, $mobilenumber, $errorMessage)) {
            $current_lang_id = $this->context->language->id;
            $mobilenumber_exist = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND  country_id = ' . pSQL($country_id));
            if ($mobilenumber_exist) {
                $otp_count = $mobilenumber_exist['otp_count'];
            } else {
                Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_user_detail` (country_id, mobilenumber, verified, date_add, date_upd)'
                    . ' VALUES ("' . pSQL($country_id) . '" , "' . pSQL($mobilenumber) . '" , "0" , now() , now())');
                $otp_count = 0;
            }
            /**
             * generate OTP and send it to mobile number and update otp and otp_count in database
             * @date 23-02-2023
             * @commenter Prvind Panday
             */
            $otp = $this->generateOTP($module_setting['otp_length']);
            $current_order_status_message = $module_setting['otp_message'][$current_lang_id];
            $phrase = $current_order_status_message;
            $search = array("{otp}");
            $replacewith = array($otp);
            $newPhrase = str_replace($search, $replacewith, $phrase);
            /**
             * Check if OTP is sent successfully or not and update otp and otp_count in database
             * @date 23-02-2023
             * @commenter Prvind Panday
             */
            if ($this->sendMessage($country_id, $mobilenumber, $newPhrase)) {
                $otp_count += 1;
                Db::getInstance()->execute('UPDATE  `' . _DB_PREFIX_ . 'kbmobile_user_detail` SET otp = "' . pSQL($otp) . '", otp_count = "' . pSQL($otp_count) . '", otp_sent_time = "' . time() . '" WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND country_id = ' . pSQL($country_id));
                $errorMessage = $this->l('OTP has been successfully sent.');
                /**
                 * Fixing translation issue with the variables like {#t}
                 * Earlier the variables were in string, so seperated them 
                 * NAAug2023 Translation
                 * @date 07-08-2023
                 * @modifier Nikhil Aggarwal
                 */
                if ($module_setting['otp_expiration_duration']) {
                    $otp_expire_message = $this->l('Your OTP will be expired in ');
                    $otp_expire_message .= '{#t}';
                    $otp_expire_message .= $this->l(' Seconds.');
                    $otp_expire_message = str_replace('{#t}', $module_setting['otp_expiration_duration'], $otp_expire_message);
                    $errorMessage = $errorMessage . ' ' . $otp_expire_message;
                }
                if ($module_setting['otp_limit_request']) {
                    $otp_request_count = $module_setting['otp_request_count'];
                    $left_otp = $otp_request_count - $otp_count;
                    $otp_expire_message = '{#c}'.$this->l(' OTP request left');
                    $otp_expire_message = str_replace('{#c}', $left_otp, $otp_expire_message);
                    $errorMessage = $errorMessage . ' ' . $otp_expire_message;
                }
                // Changes end by Nikhil
                return true;
            } else {
                $errorMessage = $this->l('Something went wrong. Message has been not sent.');
                return false;
            }
        } else {
            return false;
        }
    }

    public function initListStatusMessageList()
    {
        $this->fields_list = array(
            'kb_mobile_status_id' => array(
                'title' => $this->l('Status Id'),
                'type' => 'text',
                'search' => false,
                'class' => 'kb_mobile_status_id'
            ),
            'status' => array(
                'title' => $this->l('Status'),
                'type' => 'bool',
                'search' => false,
                'align' => 'center',
                'icon' => array(0 => 'disabled.gif', 1 => 'enabled.gif'),
                'class' => 'status'
            ),
            'description' => array(
                'title' => $this->l('Description'),
                'type' => 'text',
                'search' => false,
                'class' => 'status'
            ),
        );

        $helper = new HelperList();
        $helper->shopLinkType = '';
        $helper->simple_header = false;
        $helper->no_link = true;
        // Actions to be displayed in the "Actions" column
        $helper->actions = array(
            'edit', 'delete');
        $helper->identifier = 'kb_mobile_status_id';
        $helper->show_toolbar = true;
        $helper->title = $this->l('Status Message List');
        $helper->table = 'kbmobile_status_message';
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $query = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_status_message ws INNER JOIN " . _DB_PREFIX_ . "kbmobile_status_message_lang wsl ON ws.kb_mobile_status_id = wsl.kb_mobile_status_id  WHERE "
            . " wsl.lang_id = '" . (int) $this->context->language->id . "' order by ws.kb_mobile_status_id asc";
        $data = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
        $results = $data;
        return $helper->generateList($results, $this->fields_list);
    }

    /**
     * Ajax Process process all functions for ajax call and return json
     * @param string $method
     * @return json
     * @date 23-02-2023
     * @commenter Prvind Panday
     */
    private function ajaxProcess($method)
    {
        /**
         * $method refreshStatusMessageList 
         * $method deleteService 
         * $method getStatusMessageForm
         * $method updateStatusMessageData
         * 
         * @date 23-02-2023
         * @commenter Prvind Panday
         */
        $this->json = array();
        if ($method == 'refreshStatusMessageList') {
            $res = $this->initListStatusMessageList();
            $this->json = $res;
        }

        if ($method == 'deleteService') {
            $kb_mobile_status_id = Tools::getValue('kb_mobile_status_id');
            $deleteServiceLangSql = 'Delete from ' . _DB_PREFIX_ . 'kbmobile_status_message_lang where kb_mobile_status_id =' . (int) $kb_mobile_status_id;
            Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($deleteServiceLangSql);

            $deleteServiceSql = 'Delete from ' . _DB_PREFIX_ . 'kbmobile_status_message where kb_mobile_status_id =' . (int) $kb_mobile_status_id;
            $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($deleteServiceSql);
            $this->json = $res;
        }

        if ($method == 'updateStatusMessageData') {
            $language = Language::getLanguages(false);
            $kb_mobile_status_id = Tools::getValue('kb_mobile_status_id');
            $order_status_id = Tools::getValue('kb_order_status_id');
            $status = Tools::getValue('kb_status');
            $res = '';
            if (!Tools::isEmpty($kb_mobile_status_id)) {
                $sql = 'UPDATE ' . _DB_PREFIX_ . 'kbmobile_status_message SET status="' . (int) $status . '" '
                    . ', order_status_id = "' . (int) $order_status_id . ', date_updated = now() " WHERE kb_mobile_status_id =' . (int) $kb_mobile_status_id;
                $res = Db::getInstance()->execute($sql);
                foreach ($language as $lang) {
                    $description = Tools::getValue(
                        'kb_description_' . $lang['id_lang']
                    );
                    $sql = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_status_message_lang WHERE kb_mobile_status_id = '" . (int) $kb_mobile_status_id . "' AND lang_id = '" . (int) $lang['id_lang'] . "'";
                    $result = Db::getInstance()->getRow($sql);
                    if (empty($result)) {
                        $query = "INSERT INTO " . _DB_PREFIX_ . "kbmobile_status_message_lang (kb_mobile_status_id, lang_id, description) VALUES('" . (int) $kb_mobile_status_id . "', '" . (int) $lang['id_lang'] . "', '" . pSQL($description) . "')";
                        Db::getInstance()->execute($query);
                    } else {
                        if (!empty($description)) {
                            $query = "UPDATE " . _DB_PREFIX_ . "kbmobile_status_message_lang SET description = '" . pSQL($description) . "' WHERE kb_mobile_status_id = '" . (int) $kb_mobile_status_id . "' AND lang_id = '" . (int) $lang['id_lang'] . "'";
                            Db::getInstance()->execute($query);
                        }
                    }
                }
            } else {
                $sql = "Insert into  " . _DB_PREFIX_ . "kbmobile_status_message (order_status_id, status, date_added, date_updated ) values ('" . (int) $order_status_id . "', '" . (int) $status . "', now(), now())";
                $res = Db::getInstance()->execute($sql);
                $kb_mobile_status_id = Db::getInstance()->Insert_ID();
                foreach ($language as $lang) {
                    $description = Tools::getValue(
                        'kb_description_' . $lang['id_lang']
                    );
                    $query = "INSERT INTO " . _DB_PREFIX_ . "kbmobile_status_message_lang (kb_mobile_status_id, lang_id, description) VALUES('" . (int) $kb_mobile_status_id . "', '" . (int) $lang['id_lang'] . "', '" . pSQL($description) . "')";
                    Db::getInstance()->execute($query);
                }
            }
            $this->json = $res;
        }

        if ($method == 'getStatusMessageForm') {
            $kb_mobile_status_id = Tools::getValue('kb_mobile_status_id');
            $form = $this->getStatusMessageForm($kb_mobile_status_id);
            $this->json = $form;
        }

        header('Content-Type: application/json', true);
        echo json_encode($this->json);
        die;
    }

    /**
     * Get Status Message Form for every order status 
     * @param int $kb_mobile_status_id
     * @return string
     * @date 23-02-2023
     * @commenter Prvind Panday
     */
    public function getStatusMessageForm($kb_mobile_status_id = null)
    {
        $languages = Language::getLanguages(false);
        foreach ($languages as $k => $language) {
            $languages[$k]['is_default'] = ((int) ($language['id_lang'] == $this->context->language->id));
        }
        $statuses_array = array();
        $statuses = OrderState::getOrderStates((int) $this->context->language->id);
        $current_order_status_id = '';
        /**
         * If kb_mobile_status_id is not empty then get current order status id and prepare array for order status for the form
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (!Tools::isEmpty($kb_mobile_status_id)) {
            $query = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_status_message WHERE kb_mobile_status_id = '" . (int) $kb_mobile_status_id . "'";
            $service_data = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);
            $current_order_status_id = $service_data['order_status_id'];
        }
        foreach ($statuses as $status) {
            if ((!Tools::isEmpty($current_order_status_id)) && ($status['id_order_state'] == $current_order_status_id)) {
                $statuses_array[] = array('id_order_state' => $status['id_order_state'], 'name' => $status['name']);
            } else {
                $query = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_status_message WHERE order_status_id = '" . (int) $status['id_order_state'] . "'";
                $service_data = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);
                if ($service_data) {
                    continue;
                } else {
                    $statuses_array[] = array('id_order_state' => $status['id_order_state'], 'name' => $status['name']);
                }
            }
        }


        $this->fields_form = array(
            'form' => array(
                'id_form' => 'kb_status_message_form',
                'legend' => array(
                    'title' => $this->l('Order Status Messages'),
                ),
                'input' => array(
                    array(
                        'type' => 'hidden',
                        'name' => 'kb_mobile_status_id',
                    ),
                    array(
                        'label' => $this->l('Order State'),
                        'type' => 'select',
                        'name' => 'kb_order_status_id',
                        'hint' => $this->l('Selected name will be show on wheel and for email marketing it will be used..'),
                        'options' => array(
                            'query' => $statuses_array,
                            'id' => 'id_order_state',
                            'name' => 'name',
                        ),
                    ),
                    array(
                        'type' => 'textarea',
                        'lang' => true,
                        'label' => $this->l('SMS Message'),
                        'desc' => $this->l('This text will be sent as a message. you can use following keywords to replace with actual value. {firstname}, {lastname}, {email}, {mobile}, {shipping_address}, {orderid}, {price}, {discount}, {productid}, {productname}, {trackingid}, {transactionid}, {invoice}'),
                        'name' => 'kb_description',
                        'required' => true,
                        'maxlength' => 1000,
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enable'),
                        'hint' => $this->l('Enable/ Disable this service'),
                        'name' => 'kb_status',
                        'values' => array(
                            array(
                                'value' => 1,
                                'id' => 'kb_status_on'
                            ),
                            array(
                                'value' => 0,
                                'id' => 'kb_status_off'
                            ),
                        ),
                    ),
                ),
            ),
        );
        $field_value = array();
        if (!Tools::isEmpty($kb_mobile_status_id)) {
            $query = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_status_message WHERE kb_mobile_status_id = '" . (int) $kb_mobile_status_id . "'";
            $service_data = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);
            $field_value = array(
                'kb_status' => $service_data['status'],
                'kb_order_status_id' => $service_data['order_status_id'],
                'kb_mobile_status_id' => $kb_mobile_status_id
            );
            $service_label_lang = array();
            $query = "SELECT * FROM " . _DB_PREFIX_ . "kbmobile_status_message_lang WHERE kb_mobile_status_id = '" . (int) $kb_mobile_status_id . "'";
            $service_label_data = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
            foreach ($service_label_data as $service_label) {
                $service_label_lang['kb_description'][$service_label['lang_id']] = $service_label['description'];
            }
            foreach ($languages as $lang) {
                $field_value['kb_description'][$lang['id_lang']] = $service_label_lang['kb_description'][$lang['id_lang']];
            }
        } else {
            $field_value = array(
                'kb_status' => 0,
                'kb_order_status_id' => 0,
                'kb_mobile_status_id' => ''
            );
            foreach ($languages as $lang) {
                $field_value['kb_description'][$lang['id_lang']] = '';
            }
        }
        //Helper form to generate form
        $helper = new HelperForm();
        $helper->module = $this;
        $helper->table = 'kbmobile_status_message';
        $helper->fields_value = $field_value;
        $helper->name_controller = $this->name;
        $helper->languages = $languages;
        $helper->default_form_language = $this->context->language->id;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->title = 'statusMessageForm';
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->show_cancel_button = false;
        $helper->submit_action = 'submitStatusMessageForm';
        return $helper->generateForm(array($this->fields_form));
    }

    /**
     * Hook called automatically when order placed by user.
     *
     * @param order object $params
     */
    public function hookOrderConfirmation($params)
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $current_lang_id = $this->context->language->id;
        if (($module_setting['enable'] == 1) && ($module_setting['message_on_order_status_change'] == 1)) {
            $param = $params['order'];
            $order = new Order((int) $param->id);
            $statusid = ($order) ? $order->current_state : '';
            if ($statusid != '') {
                $template = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('SELECT ksml.description  FROM ' . _DB_PREFIX_ . 'kbmobile_status_message ksm JOIN ' . _DB_PREFIX_ . 'kbmobile_status_message_lang ksml  on (ksm.kb_mobile_status_id = ksml.kb_mobile_status_id) WHERE order_status_id = "' . (int) $statusid . '" and status = 1 and lang_id = "' . (int) $current_lang_id . '"');
                if ($template) {
                    $address = new Address((int) $order->id_address_delivery);
                    if ($order) {
                        $address = new Address((int) $order->id_address_delivery);
                        $legendstemp = $this->replaceOrderLegends($template['description'], $order, $address);
                        $legendstemp = preg_replace('/<br(\s+)?\/?>/i', "\n", $legendstemp);
                        $customer_id = $order->id_customer;
                        $mobile_number = $this->getCustomerMobileNumberById($customer_id);
                        $countryId = $this->getCustomerCountryIdById($customer_id);
                        if (!Tools::isEmpty($mobile_number) && !Tools::isEmpty($legendstemp)) {
                            $this->sendMessage($countryId, $mobile_number, $legendstemp);
                        }
                    }
                }
            }
        }
    }

    /**
     * Hook called automatically when order's status updated from Backend.
     *
     * @param order object $params
     */
    public function hookpostUpdateOrderStatus($params)
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $current_lang_id = $this->context->language->id;
        if (($module_setting['enable'] == 1) && ($module_setting['message_on_order_status_change'] == 1)) {
            $orderid = $params['id_order'];
            $order = new Order((int) $orderid);
            $statusid = ($order) ? $order->current_state : '';
            if ($statusid != '') {
                $template = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('SELECT ksml.description  FROM ' . _DB_PREFIX_ . 'kbmobile_status_message ksm JOIN ' . _DB_PREFIX_ . 'kbmobile_status_message_lang ksml  on (ksm.kb_mobile_status_id = ksml.kb_mobile_status_id) WHERE order_status_id = "' . (int) $statusid . '" and status = 1 and lang_id = "' . (int) $current_lang_id . '"');
                if ($template) {
                    $address = new Address((int) $order->id_address_delivery);
                    if ($order) {
                        $address = new Address((int) $order->id_address_delivery);
                        $legendstemp = $this->replaceOrderLegends($template['description'], $order, $address);
                        $legendstemp = preg_replace('/<br(\s+)?\/?>/i', "\n", $legendstemp);
                        $customer_id = $order->id_customer;
                        $mobile_number = $this->getCustomerMobileNumberById($customer_id);
                        $countryId = $this->getCustomerCountryIdById($customer_id);
                        if (!Tools::isEmpty($mobile_number) && !Tools::isEmpty($legendstemp)) {
                            $this->sendMessage($countryId, $mobile_number, $legendstemp);
                        }
                    }
                }
            }
        }
    }

    /**
     * Replace legends, placeholders for order template body.
     *
     * @return string
     */
    private function replaceOrderLegends($template, $order = '', $address = '')
    {
        $shippingAddr = '';
        $productid = '';
        $productname = '';
        $invoice = '';
        $ship_number = '';
        $tran_id = '';

        if ($address != '') {
            $shippingAddr .= $address->address1 . ' ' . $address->address2 . '<br>';
            $shippingAddr .= $address->postcode . ' ' . $address->city . ' ' . $address->country;
        }

        $productArray = $order->getProducts();
        $total_product_disc = 0;
        if ($productArray) {
            $idarray = array();
            $namearray = array();
            foreach ($productArray as $product) {
                array_push($namearray, $product['product_name']);
                array_push($idarray, $product['product_id']);
                $product_amt = (float) $product['total_price_tax_incl'];

                $reduction_precent = (float) $product['reduction_percent'];
                if ($reduction_precent > 0) {
                    $actual_amt = ($product_amt * 100) / (100 - $reduction_precent);
                    $total_product_disc += ($actual_amt - $product_amt);
                }

                $reduction_amount = (float) $product['reduction_amount_tax_incl'];
                if ($reduction_amount > 0) {
                    $total_product_disc += $reduction_amount;
                }
            }
            $productid = implode(', ', $idarray);
            $productname = implode(', ', $namearray);
        }

        $getOrderTrack = $this->getOrderTrackNTransID($order->id);
        $orderTrack = ($getOrderTrack !== null && sizeof($getOrderTrack) > 0) ? $getOrderTrack[0] : '';
        if ($orderTrack != '') {
            $invoiceNo = Tools::strlen($orderTrack['invoice_number']);
            if ((int) $invoiceNo > 0 && (int) $orderTrack['invoice_number'] > 0) {
                switch ($invoiceNo) {
                    case '1':
                        $invoicePre = '#IN00000';
                        break;
                    case '2':
                        $invoicePre = '#IN0000';
                        break;
                    case '3':
                        $invoicePre = '#IN000';
                        break;
                    case '4':
                        $invoicePre = '#IN00';
                        break;
                    case '5':
                        $invoicePre = '#IN0';
                        break;
                    default:
                        $invoicePre = '#IN';
                        break;
                }
                $invoice = $invoicePre . $orderTrack['invoice_number'];
            }
            /**
             * Start changes to fix the shipping_number deprecation issue in orders table
             * Replaced shipping_number with tracking_number
             * NAAug2023 shipping_number
             * @date 09-08-2023
             * @author Nikhil Aggarwal
             */
            $ship_number = $orderTrack['tracking_number'];
            // Changes end by Nikhil
            $tran_id = $orderTrack['transaction_id'];
        }

        $legends = array(
            "{firstname}",
            "{lastname}",
            "{email}",
            "{mobile}",
            "{shipping_address}",
            "{orderid}",
            "{price}",
            "{discount}",
            "{productid}",
            "{productname}",
            "{trackingid}",
            "{transactionid}",
            "{invoice}"
        );

        $customer = new Customer((int) $order->id_customer);

        $coupon_disc = (float) $order->total_discounts_tax_incl;
        $coupon_disc += $total_product_disc;

        $total_amt = number_format($order->total_paid_tax_incl, 2);
        $discount = number_format($coupon_disc, 2);
        $currencyInfo = new Currency((int) $order->id_currency);
        if ($currencyInfo != '') {
            $total_amt = $currencyInfo->iso_code . ' ' . $total_amt;
            $discount = $currencyInfo->iso_code . ' ' . $discount;
        }

        $replacedLegends = array(
            $customer->firstname,
            $customer->lastname,
            $customer->email,
            $address->phone_mobile,
            $shippingAddr,
            $order->id,
            $total_amt,
            $discount,
            $productid,
            $productname,
            $ship_number,
            $tran_id,
            $invoice
        );

        $NewReplacedTemp = str_replace($legends, $replacedLegends, $template);
        return $NewReplacedTemp;
    }

    /**
     * Get order tracking details from database.
     *
     * @param int $orderid
     * @return array
     */
    public function getOrderTrackNTransID($orderid)
    {
        $selSqlQuery = 'SELECT ordr.reference, ordrc.tracking_number,ordr.invoice_number, paymt.transaction_id';
        $selSqlQuery .= ' FROM ' . _DB_PREFIX_ . 'orders as ordr';
        $selSqlQuery .= ' LEFT JOIN ' . _DB_PREFIX_ . 'order_payment as paymt';
        $selSqlQuery .= ' ON paymt.order_reference = ordr.reference';
        /**
         * Start changes to fix the shipping_number deprecation issue in orders table
         * Replaced shipping_number with tracking_number
         * NAAug2023 shipping_number
         * @date 09-08-2023
         * @author Nikhil Aggarwal
         */
        $selSqlQuery .= ' LEFT JOIN ' . _DB_PREFIX_ . 'order_carrier as ordrc';
        $selSqlQuery .= ' ON ordr.id_order = ordrc.id_order';
        // Changes end by Nikhil
        $selSqlQuery .= ' WHERE ordr.id_order = "' . (int) $orderid . '"';
        $selSqlQuery .= ' order by paymt.id_order_payment desc';
        $getShippingDetails = Db::getInstance()->ExecuteS($selSqlQuery);
        return $getShippingDetails;
    }

    /*
     * Function to update Personal Information
     */

    public function hookActionOrderStatusPostUpdate($params)
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        $current_lang_id = $this->context->language->id;
        /**
         * if module is enabled and message on order status change is enabled then send message once the order status is changed
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (($module_setting['enable'] == 1) && ($module_setting['message_on_order_status_change'] == 1)) {
            $orderid = $params['id_order'];
            $order = new Order((int) $orderid);
            $statusid = ($order) ? $order->current_state : '';
            if ($statusid != '') {
                $template = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('SELECT ksml.description  FROM ' . _DB_PREFIX_ . 'kbmobile_status_message ksm JOIN ' . _DB_PREFIX_ . 'kbmobile_status_message_lang ksml on (ksm.kb_mobile_status_id = ksml.kb_mobile_status_id) WHERE order_status_id = "' . (int) $statusid . '" and status = 1 and lang_id = "' . (int) $current_lang_id . '"');
                if ($template) {
                    $address = new Address((int) $order->id_address_delivery);
                    if ($order) {
                        $address = new Address((int) $order->id_address_delivery);
                        $legendstemp = $this->replaceOrderLegends($template['description'], $order, $address);
                        $legendstemp = preg_replace('/<br(\s+)?\/?>/i', "\n", $legendstemp);
                        $customer_id = $order->id_customer;
                        /**
                         * getCustomerMobileNumberById function is used to get customer mobile number by customer id
                         * @date 23-03-2023
                         * @commenter Prvind Panday
                         */
                        $mobile_number = $this->getCustomerMobileNumberById($customer_id);
                        if ($mobile_number) {
                            $countryId = $this->getCustomerCountryIdById($customer_id);
                            if (!Tools::isEmpty($mobile_number) && !Tools::isEmpty($legendstemp)) {
                                $this->sendMessage($countryId, $mobile_number, $legendstemp);
                            }
                        }
                    }
                }
            }
        }
    }
    
    public function hookActionCustomerFormBuilderModifier(array $params)
    {
        $formBuilder = $params['form_builder'];
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            $current_lang_id = $this->context->language->id;
            $customer_id = (int)$params['id'];
            $mobilenumber_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"');
            $country_id = '';
            $mobilenumber = '';
            $verified = 0;
            if ($mobilenumber_details) {
                $country_id = $mobilenumber_details['country_id'];
                /**
                 * Type casting to int to avoid sql injection and avoid 0 in the beginning of mobile number
                 * @date 23-02-2023
                 * @commenter Prvind Panday
                 */
                $mobilenumber = (int) $mobilenumber_details['mobilenumber'];
                $verified = $mobilenumber_details['verified'];
            }
            $total_active_country = $this->getCountries($current_lang_id);
            $options = $total_active_country;

            $choices = array();
            $data = $country_id;
            foreach ($options as $key => $option) {
                $choices[$option['country'] . ' (+' . $option['prefix'] . ')'] = $option['id_country'];
            }

            $formBuilder->add('country_code', CountryChoiceType::class, [
                'label' => $this->l('Country Code'),
                'choices' => $choices,
                'data' => $data
            ]);
            $formBuilder->add('mobile_number_kb', TextType::class, [
                'label' => $this->l('Mobile Number'),
                'data' => $mobilenumber,
                'required' => false
            ]);

            $formBuilder->add('mobile_number_verifed', SwitchType::class, [
                'label' => $this->l('Mobile Number Verifed'),
                'choices' => [
                    'ON' => true,
                    'OFF' => false,
                ],
                'data' => $verified,
                'required' => false
            ]);
        }
    }
    
    /**
     * if customer is updated from my accounts page then this hook will be called and we will save the data
     * @param array $params
     * @return boolean
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function hookActionAfterUpdateCustomerFormHandler(array $params)
    {
        $id_customer = $params['id'];
        $customerFormData = $params['form_data'];
        $this->saveCustomerData($id_customer, $customerFormData);
    }
    
    /**
     * if customer is updated from my account then this hook will be called and we will save the data
     * @param int $id_customer
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function saveCustomerData($id_customer, $customerFormData = array())
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            if ($module_setting['show_mobile_on_registration']) {
                $customer_id = $id_customer;
                $country_id = (int) $customerFormData['country_code'];
                $mobilenumber = (int) $customerFormData['mobile_number_kb'];
                if (($country_id != '') || ($mobilenumber != '')) {
                    $SelectSQL = 'SELECT verified FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" AND country_id = ' . pSQL($country_id);
                    $verified_status = Db::getInstance()->getValue($SelectSQL);
                    $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"';
                    Db::getInstance()->execute($DeleteSQL);
                    $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($mobilenumber) . '" and country_id = "' . pSQL($country_id) . '"';
                    Db::getInstance()->execute($DeleteSQL);
                    Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_user_detail` (customer_id, country_id, mobilenumber, verified, date_add, date_upd)'
                            . ' VALUES ("' . pSQL($customer_id) . '" , "' . pSQL($country_id) . '" , "' . pSQL($mobilenumber) . '" , "' . (int) $verified_status . '" , now() , now())');
                }
            }
        }
    }
    
    /**
     * if customer is updated or deleted from back office then this hook will be called and we will save the data
     * @param array $params
     * @return boolean
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    public function hookActionObjectCustomerDeleteAfter($params)
    {
        /**
         * if the page is admin customer page then only we will delete the data
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if (isset($this->context->controller->controller_name) && ($this->context->controller->controller_name == 'AdminCustomers')) {
            $customer_id = $params['object']->id;
            $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"';
            $user_details = Db::getInstance()->executeS($sql);
            if (!empty($user_details)) {
                $DeleteSQL = 'Delete FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE customer_id = "' . (int) $customer_id . '"';
                Db::getInstance()->execute($DeleteSQL);
            }
        }
    }
}
