<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2015 knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class Sendinblue
{

//    public $sid;
//    public $token;
//    public $from;
    
    public $access_key;
    public $from;

    public function __construct($param)
    {
        $this->access_key = $param['Access_key'];
        $this->from = $param['From'];
    }

    /**
     * Send SMS using sendinblue API
     * @param type $call_prefix
     * @param type $mobile_number
     * @param type $message
     * @return boolean
     * changes start here by Kanishka Kannoujia on 22-04-2022 as the v2 api is deprecated
     * @date 23-03-2023
     * @author Kanishka Kannoujia
     * @commenter Prvind Panday
     */
    public function sendSMS($call_prefix, $mobile_number, $message)
    {
        $mobile_number = $call_prefix . '' . $mobile_number;
        $access_key = $this->access_key;
        $from = $this->from;
        /**
         * Start Changes to fix the sendinblue API Deprecation issue
         * Changed the URL from api.sendinblue to api.brevo
         * NAAug2023 Brevo
         * @date 18-08-2023
         * @modifier Nikhil Aggarwal 
         */
        $url = "https://api.brevo.com/v3/transactionalSMS/sms";
        // Changes end by Nikhil
        $data = array(
                    'sender' => $from,
                    'recipient' => $mobile_number,
                    //'number' => '919654457010',
                    'content' => $message
                );
        $headers = array(
                    'Accept: application/json',
                    'Content-Type: application/json',
                    'api-key:'.$access_key,
                );
        $post = json_encode($data);
        
        $curl_request_data = curl_init($url);
        
        curl_setopt($curl_request_data, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl_request_data, CURLOPT_POST, true);
        curl_setopt($curl_request_data, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl_request_data, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl_request_data, CURLOPT_POSTFIELDS, $post);
        $curl_response = curl_exec($curl_request_data);
        
        curl_close($curl_request_data);
        $response = json_decode($curl_response, true);
        
        $encode_response = json_encode($response);
        if (isset($response['messageId']) && ($response['messageId'] != '')) {
            // changes end here by Kanishka Kannoujia on 22-04-2022 as the v2 api is deprecated
            $message_id = $response['messageId'];
            Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_detail` (mobile_number, message, unique_sms_id, is_error, error_message, response, sms_gateway) VALUES ("' . pSQL($mobile_number) . '", "' . pSQL($message) . '", "' . pSQL($message_id) . '", "0", "", "' . pSQL($encode_response) . '", "sendinblue")');
            return true;
        } else {
            $error_message = $response['message'];
            Db::getInstance()->execute('INSERT INTO `' . _DB_PREFIX_ . 'kbmobile_sms_detail` (mobile_number, message, is_error, error_message, response, sms_gateway) VALUES ("' . pSQL($mobile_number) . '", "' . pSQL($message) . '", "1", "' . pSQL($error_message) . '", "' . pSQL($encode_response) . '", "sendinblue")');
            return false;
        }
    }
}
