/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2017 Knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 *
 */

/**
 * This file is used to validate the mobile number on the back office when any admin changes the mobile number of any customer.
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
$(document).ready(function() {
    $('input[name="kbmob_mobile_number"], select[name="kbmob_country_id"]').on('change', function() {
        checkMobileNumberExist();
    });
});

/**
 * checkMobileNumberExist() is used to check the mobile number exist or not in the database. If exist then it will show the error message.
 * @date 23-03-2023
 * @commenter Prvind Panday
 * @returns 
 */
function checkMobileNumberExist() {
    $("#customer_form_submit_btn").attr("disabled", "disabled");
    var kbMobileNumber = $.trim($('input[name="kbmob_mobile_number"]').val());
    var kbCountryId = $.trim($('select[name="kbmob_country_id"]').val());
    $('.mobilelogin_error').remove();
    var current_validation_element = $('input[name="kbmob_mobile_number"]');
    if ((kbMobileNumber != '')) {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            current_validation_element.after($('<p class="mobilelogin_error" style="color:red;">' + kb_mobile_number_error_mesage + '</p>'));
            return false;
        }

        if (current_error == true) {
            if (kbMobileNumber.length > 0) {
                if ((min_mobile_length != '0') && (kbMobileNumber.length < parseInt(min_mobile_length))) {
                    current_validation_element.after($('<p class="mobilelogin_error" style="color:red;">' + kb_mobile_number_length + ' ' + kb_minimum_text + ' ' + min_mobile_length + ' ' + kb_digit_text + '</p>'));
                    return false;
                }
                if ((max_mobile_length != '0') && (kbMobileNumber.length > parseInt(max_mobile_length))) {
                    current_validation_element.after($('<p class="mobilelogin_error" style="color:red;">' + kb_mobile_number_length + ' ' + kb_maximum_text + ' ' + max_mobile_length + ' ' + kb_digit_text + '</p>'));
                    return false;
                }
            }
        }
        /**
         * Ajax call to check the mobile number exist or not in the database.
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        $.ajax({
            url: kbmobile_front_url,
            type: 'post',
            data: {
                "ajax": true,
                "method": "checkMobileNumberExist",
                "currentCustomerId": current_customer_id,
                "kbMobileNumber": kbMobileNumber,
                "kbCountryId": kbCountryId
            },
            dataType: 'json',
            beforeSend: function() {},
            success: function(json) {
                if (json) {
                    alert(kbmobile_exist_message);
                } else {
                    $("#customer_form_submit_btn").removeAttr("disabled");
                }
            },
            complete: function() {}
        });
    }
}
