/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2017 Knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 *
 */

/**
 * Admin validation js file for the module.
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
$(document).ready(function () {

    /**
     * configuration form validation on submit and on change of the input fields.
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    $('#configuration_form').addClass('col-lg-10 col-md-9');
    $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').show();
    $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
    $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
    $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
    $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
    $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
    $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
    $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();
    $('#form-kbmobile_status_message').hide();

    /**
     * to show hide the last selected tab on page load.
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    var last_selected_tab = getCookie("tab");
    if (last_selected_tab != null) {
        if (last_selected_tab == 1) {
            $('#link-General_Settings').trigger('click');
        } else if (last_selected_tab == 2) {
            $('#link-Registration_Page_Settings').trigger('click');
            showHideRegistrationSetting();
        } else if (last_selected_tab == 3) {
            $('#link-Login_Page_Settings').trigger('click');
        } else if (last_selected_tab == 4) {
            $('#link-Sms_Notification_Settings').trigger('click');
        } else if (last_selected_tab == 5) {
            $('#link-Otp_settings').trigger('click');
        } else if (last_selected_tab == 6) {
            $('#link-Sms_Gateway_Settings').trigger('click');
        } else if (last_selected_tab == 7) {
            $('#link-Mobile_Details_Settings').trigger('click');
        }
    }

    /**
     * to show mobile number field on registration page on change of the checkbox.
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    $('[name="kbmoblogin[show_mobile_on_registration]"], [name="kbmoblogin[register_without_email]"]').on('change', function () {
        showHideRegistrationSetting();
    });
    $('[name="kbmoblogin[message_on_registration]"]').on('change', function () {
        showHideSMSNotificationSetting();
    });
    $('[name="kbmoblogin[otp_limit_request]"], [name="kbmoblogin[otp_wrong_limit]"]').on('change', function () {
        showHideOTPSetting();
    });

    /**
     * to show hide the sms gateway provider fields on change of the sms gateway provider.
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    $('#service_save_btn').on('click', function () {
        var kb_mobile_status_id = $(this).val();
        $('.mobilelogin_error').remove();
        var error_edit = 0;
        /*Knowband validation start*/
        var first_err_flag_payment_name = 0;
        $("textarea[name^=kb_description]").each(function () {
            var banner1 = $.trim($(this).val()).length;
            if (banner1 < 1) {
                if (first_err_flag_payment_name == 0) {
                    error_edit = 1;
                    $('textarea[name="kb_description_' + language_id + '"]').addClass('error_field');
                    $('textarea[name="kb_description_' + language_id + '"]').parent().parent().after('<span class="mobilelogin_error">' + check_for_all_lang + '</span>');
                }
                first_err_flag_payment_name = 1;
            }
        });
        if (error_edit == 1) {
            return false;
        } else {
            /**
             * ajax call to save the status message data.
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            $.ajax({
                url: module_path,
                type: 'post',
                data: $('#kbmobile_status_message_form').serialize() + '&ajax=true&method=updateStatusMessageData&kb_mobile_status_id=' + kb_mobile_status_id,
                dataType: 'json',
                beforeSend: function () {
                    $('#service_save_btn').attr('disabled', true);
                    $('#kbsw_service_show_loader').show();
                },
                success: function (json) {
                    if (json === true) {
                        showSuccessMessage(update_success_msg);
                        $('#kbsw_service_show_loader').show();
                        refreshStatusMessageList();
                        $('#kbsw_show_loader').hide();
                    } else {
                        showErrorMessage(update_error_msg);
                    }

                },
                complete: function () {
                    $('#kbsw_service_show_loader').hide();
                    $('#service_save_btn').attr('disabled', false);
                    $('#serviceModalForm').modal('hide');
                }
            });
        }
    });

    /**
     * allowpolicyServiceButton() function is used to allow the policy service button for the selected gateway. Update the edit button.
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    addNewPolicyServiceButton();
    updateEditButton();

});

/**
 * getcookie() function is used to get the cookie value.
 * @param {*} name 
 * @returns 
 */
function getCookie(name) {
    var dc = document.cookie;
    var prefix = name + "=";
    var begin = dc.indexOf("; " + prefix);
    var end = 5;
    if (begin == -1) {
        begin = dc.indexOf(prefix);
        if (begin != 0)
            return null;
    } else {
        begin += 2;
        var end = document.cookie.indexOf(";", begin);
        if (end == -1) {
            end = dc.length;
        }
    }
    return decodeURI(dc.substring(begin + prefix.length, end));
}

/**
 * change_tab() function is used to change the tab on click of the tab. hide if the tab is not selected.
 * @param {*} a 
 * @param {*} b 
 * @returns
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function change_tab(a, b) {
    $('#configuration_form').show();
    $('#kb_add_order_state').remove();
    $('#form-kbmobile_status_message').hide();
    if (b == 1) {
        document.cookie = 'tab=1';
        $('.kpi-container').hide();
        $("[id^='fieldset'] h3").html(general_settings);
        $(".panel-heading").html(general_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').show();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();
    } else if (b == 2) {
        document.cookie = 'tab=2';
        $("[id^='fieldset'] h3").html(registration_page_settings);
        $(".panel-heading").html(registration_page_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').hide();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').show();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();
        showHideRegistrationSetting();

    } else if (b == 3) {
        document.cookie = 'tab=3';
        $("[id^='fieldset'] h3").html(login_page_settings);
        $(".panel-heading").html(login_page_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').hide();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').show();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();

    } else if (b == 4) {
        document.cookie = 'tab=4';
        $("[id^='fieldset'] h3").html(sms_notification_settings);
        $(".panel-heading").html(sms_notification_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').hide();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').show();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').show();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();
        showHideSMSNotificationSetting();
    } else if (b == 5) {
        document.cookie = 'tab=5';
        $("[id^='fieldset'] h3").html(otp_settings);
        $(".panel-heading").html(otp_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').hide();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').show();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').show();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();
        showHideOTPSetting();
    } else if (b == 6) {
        document.cookie = 'tab=6';
        $("[id^='fieldset'] h3").html(sms_gateway_settings);
        $(".panel-heading").html(sms_gateway_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').hide();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').show();
        $('select[name="kbmoblogin[sms_gateway_provider]"]').trigger('change');
    } else if (b == 7) {
        document.cookie = 'tab=7';
        $("[id^='fieldset'] h3").html(mobile_details_settings);
        $(".panel-heading").html(mobile_details_settings);
        $("[name='kbmoblogin[enable]'], [name='kbmoblogin[min_mobile_length]'], [name='kbmoblogin[max_mobile_length]']").closest('.form-group').hide();
        $("[name='kbmoblogin[show_mobile_on_registration]'], [name='kbmoblogin[register_without_email]'], [name='kbmoblogin[mobile_number_required]'], [name='kbmoblogin[show_email_on_registration]'], [name='kbmoblogin[verify_mobile_on_registration]'], [name='kbmoblogin[temp_email_format]']").closest('.form-group').hide();
        $("[name='kbmoblogin[login_by_mobile]'], [name='kbmoblogin[login_mobile_verified]'], [name='kbmoblogin[login_by_otp]']").closest('.form-group').hide();
        $("[name='kbmoblogin[message_on_registration]'], [name='kbmoblogin[message_on_order_status_change]']").closest('.form-group').hide();
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
        $("[name='kbmoblogin[otp_length]'],[name='kbmoblogin[otp_resend_duration]'],[name='kbmoblogin[otp_expiration_duration]'],[name='kbmoblogin[otp_request_count]'], [name='kbmoblogin[otp_limit_request]'],[name='kbmoblogin[otp_request_block_duration]'],[name='kbmoblogin[otp_wrong_limit]'],[name='kbmoblogin[otp_wrong_count]'],[name='kbmoblogin[otp_wrong_block_duration]']").closest('.form-group').hide();
        $("[name^='otp_message']").parents('.form-group').parents('.form-group').hide();
        $('select[name="kbmoblogin[sms_gateway_provider]"], [class^="sms_gateway_provider_"]').closest('.form-group').hide();
        $('#configuration_form').hide();
        $('#form-kbmobile_status_message').show();
        addNewPolicyServiceButton();
        var AddNewOrderStateMessageHtml = '<li id="kb_add_order_state">' +
                '  <a href="#" onclick="addNewService();" data-toggle="modal" data-target="#serviceModalForm" class="toolbar_btn  pointer">' +
                '	<i class="process-icon-new"></i>' +
                '	<div>' + AddNewOrderStateMessage + '</div>' +
                '  </a>' +
                '</li>';
        $('#desc-module-back').parent().before(AddNewOrderStateMessageHtml);
    }
    $('.list-group-item').attr('class', 'list-group-item');
    $(a).attr('class', 'list-group-item active');

}

/**
 * displays the sms gateway option based on the selected gateway
 * @param {*} selectObject 
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function showHideGateWayOption(selectObject) {
    var value = selectObject.value;
    $('*[class^="sms_gateway_provider_"]').closest('.form-group').hide();
    $('.sms_gateway_provider_' + value).closest('.form-group').show();
}

/**
 * displays the sms notification setting based on the selected option
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function showHideSMSNotificationSetting() {
    if (document.getElementById('kbmoblogin[message_on_registration]_on').checked) {
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').show();
    } else {
        $("[name^='registration_message']").parents('.form-group').parents('.form-group').hide();
    }
}

/**
 * displays the otp setting based on the selected option
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function showHideOTPSetting() {
    if (document.getElementById('kbmoblogin[otp_limit_request]_on').checked) {
        $("[name='kbmoblogin[otp_request_count]']").parents('.form-group').show();
        $("[name='kbmoblogin[otp_request_block_duration]']").parents('.form-group').show();
    } else {
        $("[name='kbmoblogin[otp_request_count]']").parents('.form-group').hide();
        $("[name='kbmoblogin[otp_request_block_duration]']").parents('.form-group').hide();
    }

    if (document.getElementById('kbmoblogin[otp_wrong_limit]_on').checked) {
        $("[name='kbmoblogin[otp_wrong_count]']").parents('.form-group').show();
        $("[name='kbmoblogin[otp_wrong_block_duration]']").parents('.form-group').show();
    } else {
        $("[name='kbmoblogin[otp_wrong_count]']").parents('.form-group').hide();
        $("[name='kbmoblogin[otp_wrong_block_duration]']").parents('.form-group').hide();
    }
}

/**
 * displays the registration setting based on the selected option
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function showHideRegistrationSetting() {
    if (document.getElementById('kbmoblogin[show_mobile_on_registration]_on').checked) {
        $('input[name="kbmoblogin[register_without_email]"]').closest('.form-group').show();
        $('input[name="kbmoblogin[mobile_number_required]"]').closest('.form-group').show();

        $('input[name="kbmoblogin[verify_mobile_on_registration]"]').closest('.form-group').show();

        if (document.getElementById('kbmoblogin[register_without_email]_on').checked) {
            $('input[name="kbmoblogin[show_email_on_registration]"]').closest('.form-group').show();
            document.getElementById('kbmoblogin[mobile_number_required]_on').checked = true;
            document.getElementById('kbmoblogin[mobile_number_required]_off').checked = false;
            document.getElementById('kbmoblogin[mobile_number_required]_on').disabled = 'disabled';
            document.getElementById('kbmoblogin[mobile_number_required]_off').disabled = 'disabled';
        } else {
            $('input[name="kbmoblogin[show_email_on_registration]"]').closest('.form-group').hide();
            document.getElementById('kbmoblogin[mobile_number_required]_on').disabled = '';
            document.getElementById('kbmoblogin[mobile_number_required]_off').disabled = '';
        }

    } else {
        $('input[name="kbmoblogin[register_without_email]"]').closest('.form-group').hide();
        $('input[name="kbmoblogin[mobile_number_required]"]').closest('.form-group').hide();
        $('input[name="kbmoblogin[show_email_on_registration]"]').closest('.form-group').hide();
        $('input[name="kbmoblogin[verify_mobile_on_registration]"]').closest('.form-group').hide();
        //$('input[name=""]').closest('.form-group').hide();
    }
}

/**
 * delete the service from the list of gateways
 * @param {*} kb_mobile_status_id 
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function deleteService(kb_mobile_status_id) {
    if (confirm(delete_service_confirmation_text)) {
        $.ajax({
            url: module_path,
            type: 'post',
            data: 'ajax=true&method=deleteService&kb_mobile_status_id=' + kb_mobile_status_id,
            dataType: 'json',
            beforeSend: function () {
                $('#kbpbloadingIcon').show();
            },
            success: function (json) {
                $('#kbsw_service_data_form').html('');
                refreshStatusMessageList();
                showSuccessMessage(delete_success_msg);
            },
            complete: function (data) {
                $('#kbpbloadingIcon').hide();
            },
        });
    }
}

/**
 * refresh the list of status messages of orders
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function refreshStatusMessageList() {
    $('#kbpbloadingIcon').show();
    $.ajax({
        url: module_path,
        type: 'post',
        data: 'ajax=true&method=refreshStatusMessageList',
        dataType: 'json',
        async: false,
        success: function (json) {
            $('.list_status_message').html(json);
            $('.velsof_spinwheel_admin_overlay').remove();
            var i = 1;
            updateEditButton();
        }
    });
    $('#kbpbloadingIcon').hide();
    addNewPolicyServiceButton();
}

/**
 * save the gateway service details for otp
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
$('#service_save_btn').on('click', function () {
    var kb_mobile_status_id = $(this).val();
    $('.mobilelogin_error').remove();
    var error_edit = 0;
    /*Knowband validation start*/
    var first_err_flag_payment_name = 0;
    $("input[name^=kbsw_service_label_]").each(function () {
        var banner1 = $.trim($(this).val()).length;
        if (banner1 < 1) {
            if (first_err_flag_payment_name == 0) {
                error_edit = 1;
                $('input[name="kbsw_service_label_' + language_id + '"]').addClass('error_field');
                $('input[name="kbsw_service_label_' + language_id + '"]').parent().parent().after('<span class="mobilelogin_error">' + check_for_all_lang + '</span>');
            }
            first_err_flag_payment_name = 1;
        }
    });
    if (error_edit == 1) {
        return false;
    } else {
        /**
         * if no errors found then save the data using ajax call
         * @returns {undefined}
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        $.ajax({
            url: module_path,
            type: 'post',
            data: $('#wheel_service_form').serialize() + '&ajax=true&method=updateServiceData&kb_mobile_status_id=' + kb_mobile_status_id,
            dataType: 'json',
            beforeSend: function () {
                $('#service_save_btn').attr('disabled', true);
                $('#kbsw_service_show_loader').show();
                $('#kbpbloadingIcon').show();
            },
            success: function (json) {
                if (json === true) {
                    showSuccessMessage(update_success_msg);
                    $('#kbsw_service_show_loader').show();
                    refreshStatusMessageList();
                    $('#kbsw_show_loader').hide();
                } else {
                    showErrorMessage(update_error_msg);
                }

            },
            complete: function () {
                $('#kbsw_service_show_loader').hide();
                $('#service_save_btn').attr('disabled', false);
                $('#serviceModalForm').modal('hide');
                $('#kbpbloadingIcon').hide();
            }
        });
    }

});

/**
 * get the form for adding new service for otp
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function addNewService() {
    $('#service_save_btn').val('');
    $.ajax({
        url: module_path,
        type: 'post',
        data: 'ajax=true&method=getStatusMessageForm',
        dataType: 'json',
        beforeSend: function () {
            $('#kbpbloadingIcon').show();
        },
        success: function (json) {
            $('#kbsw_service_data_form').html('');
            $(json).appendTo('#kbsw_service_data_form');

        },
        complete: function (data) {
            $('#kbpbloadingIcon').hide();
        },
    });
}

/**
 * addNewPolicyServiceButton function is used to add the button for adding new service
 * @date 23-03-2023
 * @commenter Prvind Panday
 * @returns 
 */
function addNewPolicyServiceButton() {
    var addNewPolicyServiceHtml = '<span class="panel-heading-action">		' + '		<a class="list-toolbar-btn" href="#"  onclick="addNewService();"  data-toggle="modal" data-target="#serviceModalForm">' + '			<span class="label-tooltip" data-toggle="tooltip" data-original-title="Add new" data-html="true" data-placement="top">' + '		<i class="process-icon-new"></i>' + '		</span>' + '		</a>' + '    </span>';
    $('#form-kbmobile_status_message .panel .panel-heading').append(addNewPolicyServiceHtml);
    return true;
}

/**
 * updateEditButton function is used to update the edit and delete button for each row
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function updateEditButton() {
    $('table.kbmobile_status_message td.text-right').each(function () {
        var kb_mobile_status_id = $(this).siblings().first().text().trim();
        $('table.kbmobile_status_message .edit').remove();
        $('table.kbmobile_status_message .delete').remove();
        $(this).find('.pull-right').html('<button type="button" value="' + kb_mobile_status_id + '" class="btn btn-info kbsw_service_edit_btn" data-toggle="modal" onclick="editService(' + kb_mobile_status_id + ');" data-target="#serviceModalForm">' + edit + '</button>' + '&nbsp; <button type="button" value="' + kb_mobile_status_id + '" class="btn btn-info kbsw_service_delete_btn" onclick="deleteService(' + kb_mobile_status_id + ');">' + delete_text + '</button>');
    });
}

/**
 * editService function is used to edit the service details
 * @param {*} kb_mobile_status_id 
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function editService(kb_mobile_status_id) {
    $('#service_save_btn').val(kb_mobile_status_id);
    $.ajax({
        url: module_path,
        type: 'post',
        data: 'ajax=true&method=getStatusMessageForm&kb_mobile_status_id=' + kb_mobile_status_id,
        dataType: 'json',
        beforeSend: function () {
            $('#kbpbloadingIcon').show();
        },
        success: function (json) {
            $('#kbsw_service_data_form').html('');
            $(json).appendTo('#kbsw_service_data_form');
        },
        complete: function (data) {
            $('#kbpbloadingIcon').hide();
        },
    });
}
