/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2017 Knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 *
 */

/**
 * This file is used to validate the module from backoffice
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
$(document).ready(function() {
    $(".velovalidation_mobilelogin").on('click', function() {
        if (form_validation() == false) {
            return false;
        }
        /*Knowband button validation start*/
        document.getElementById('kbmoblogin[mobile_number_required]_on').disabled = '';
        document.getElementById('kbmoblogin[mobile_number_required]_off').disabled = '';
        $('.velovalidation_mobilelogin').attr("disabled", "disabled");
        /*Knowband button validation end*/
        $('#configuration_form').submit();
    });
});

/**
 * Validation of the module settings from backoffice once the admin clicks on the save button.
 * @date 23-03-2023
 * @commenter Prvind Panday
 * @returns 
 */
function form_validation() {
    $('.vel_error_msg').remove();
    $('.error_field').removeClass('error_field');
    $('.velsof_error_label').hide();
    $('.enter_text_mand').remove();
    $('.mobilelogin_error').remove();

    var general_settings_tab = 0;
    var registration_setting_tab = 0;
    var login_setting_tab = 0;
    var sms_setting_tab = 0;
    var otp_setting_tab = 0;
    var sms_gateway_setting_tab = 0;
    var mobile_detail_setting_tab = 0;

    var error = false;

    var current_validation_element = $("input[name='kbmoblogin[min_mobile_length]']");
    var current_error = velovalidation.checkMandatory(current_validation_element);
    if (current_error !== true) {
        error = true;
        current_validation_element.addClass('error_field');
        current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
        general_settings_tab = 1;
    } else {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            general_settings_tab = 1;
        } else {
            current_error = velovalidation.isBetween(current_validation_element, 0, 50);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                general_settings_tab = 1;
            }
        }
    }

    current_validation_element = $("input[name='kbmoblogin[max_mobile_length]']");
    var current_error = velovalidation.checkMandatory(current_validation_element);
    if (current_error !== true) {
        error = true;
        current_validation_element.addClass('error_field');
        current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
        general_settings_tab = 1;
    } else {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            general_settings_tab = 1;
        } else {
            current_error = velovalidation.isBetween(current_validation_element, 0, 50);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                general_settings_tab = 1;
            } else {

                var min_length_val = $.trim($("input[name='kbmoblogin[min_mobile_length]']").val());
                var max_length_val = $.trim($("input[name='kbmoblogin[max_mobile_length]']").val());

                if ((min_length_val != '') && (max_length_val != '0') && (max_length_val != '') && (max_length_val != '0')) {
                    if (parseInt(min_length_val) > parseInt(max_length_val)) {
                        error = true;

                        current_validation_element.addClass('error_field');
                        current_validation_element.after($('<p class="mobilelogin_error">' + mobile_min_max_error + '</p>'));
                        general_settings_tab = 1;
                    }
                }

            }
        }

    }

    current_validation_element = $("input[name='kbmoblogin[temp_email_format]']");
    var current_error = velovalidation.checkMandatory(current_validation_element);
    if (current_error !== true) {
        error = true;
        current_validation_element.addClass('error_field');
        current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
        registration_setting_tab = 1;
    } else {
        current_error = velovalidation.checkEmail(current_validation_element);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            registration_setting_tab = 1;
        }
    }

    if (document.getElementById('kbmoblogin[message_on_registration]_on').checked) {
        current_validation_element = $("textarea[name^=registration_message]");
        var multi_language_err = false;
        current_validation_element.each(function() {
            var current_error = velovalidation.checkMandatory($(this));
            if (current_error != true) {
                error = true;
                multi_language_err = true;
                sms_setting_tab = 1;
            }
        });
        if (multi_language_err) {
            current_validation_element.addClass('error_field');
            current_validation_element.after('<span class="mobilelogin_error">' + check_for_all_lang + '</span>');
        }
    }

    current_validation_element = $("input[name='kbmoblogin[otp_length]']");
    var current_error = velovalidation.checkMandatory(current_validation_element);
    if (current_error !== true) {
        error = true;
        current_validation_element.addClass('error_field');
        current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
        otp_setting_tab = 1;
    } else {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        } else {
            current_error = velovalidation.isBetween(current_validation_element, 1, 20);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                otp_setting_tab = 1;
            }
        }
    }

    current_validation_element = $("textarea[name^=otp_message]");
    var multi_language_err = false;
    current_validation_element.each(function() {
        var current_error = velovalidation.checkMandatory($(this));
        if (current_error != true) {
            error = true;
            multi_language_err = true;
            otp_setting_tab = 1;
        }
    });
    if (multi_language_err) {
        current_validation_element.addClass('error_field');
        current_validation_element.after('<span class="mobilelogin_error">' + check_for_all_lang + '</span>');
    }

    current_validation_element = $("input[name='kbmoblogin[otp_resend_duration]']");
    var current_error = velovalidation.checkMandatory(current_validation_element);
    if (current_error !== true) {
        error = true;
        current_validation_element.addClass('error_field');
        current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
        otp_setting_tab = 1;
    } else {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        }
    }

    current_validation_element = $("input[name='kbmoblogin[otp_expiration_duration]']");
    var current_error = velovalidation.checkMandatory(current_validation_element);
    if (current_error !== true) {
        error = true;
        current_validation_element.addClass('error_field');
        current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
        otp_setting_tab = 1;
    } else {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        }
    }
    if (document.getElementById('kbmoblogin[otp_limit_request]_on').checked) {
        current_validation_element = $("input[name='kbmoblogin[otp_request_count]']");
        var current_error = velovalidation.checkMandatory(current_validation_element);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        } else {
            current_error = velovalidation.isNumeric(current_validation_element, true);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                otp_setting_tab = 1;
            } else {
                current_error = velovalidation.isBetween(current_validation_element, 1, 1000);
                if (current_error !== true) {
                    error = true;
                    current_validation_element.addClass('error_field');
                    current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                    otp_setting_tab = 1;
                }
            }
        }

        current_validation_element = $("input[name='kbmoblogin[otp_request_block_duration]']");
        var current_error = velovalidation.checkMandatory(current_validation_element);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        } else {
            current_error = velovalidation.isNumeric(current_validation_element, true);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                otp_setting_tab = 1;
            } else {
                current_error = velovalidation.isBetween(current_validation_element, 1, 1000000);
                if (current_error !== true) {
                    error = true;
                    current_validation_element.addClass('error_field');
                    current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                    otp_setting_tab = 1;
                }
            }
        }
    }

    if (document.getElementById('kbmoblogin[otp_wrong_limit]_on').checked) {
        current_validation_element = $("input[name='kbmoblogin[otp_wrong_count]']");
        var current_error = velovalidation.checkMandatory(current_validation_element);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        } else {
            current_error = velovalidation.isNumeric(current_validation_element, true);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                otp_setting_tab = 1;
            } else {
                current_error = velovalidation.isBetween(current_validation_element, 1, 1000);
                if (current_error !== true) {
                    error = true;
                    current_validation_element.addClass('error_field');
                    current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                    otp_setting_tab = 1;
                }
            }
        }
        current_validation_element = $("input[name='kbmoblogin[otp_wrong_block_duration]']");
        var current_error = velovalidation.checkMandatory(current_validation_element);
        if (current_error !== true) {
            error = true;
            current_validation_element.addClass('error_field');
            current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
            otp_setting_tab = 1;
        } else {
            current_error = velovalidation.isNumeric(current_validation_element, true);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                otp_setting_tab = 1;
            } else {
                current_error = velovalidation.isBetween(current_validation_element, 1, 1000000);
                if (current_error !== true) {
                    error = true;
                    current_validation_element.addClass('error_field');
                    current_validation_element.parent().after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                    otp_setting_tab = 1;
                }
            }
        }
    }
    if ($('select[name="kbmoblogin[sms_gateway_provider]"]').val() != '') {
        var selected_gateway = $('select[name="kbmoblogin[sms_gateway_provider]"]').val();
        $('.sms_gateway_provider_' + selected_gateway).each(function() {
            current_validation_element = $(this);
            var current_error = velovalidation.checkMandatory(current_validation_element);
            if (current_error !== true) {
                error = true;
                current_validation_element.addClass('error_field');
                current_validation_element.after($('<p class="mobilelogin_error">' + current_error + '</p>'));
                sms_gateway_setting_tab = 1;
            }
        });

    }

    /**
     * if error is true then show error label and icon
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    if (error === true) {
        //alert('test');
        if (general_settings_tab === 1) {
            $('#link-General_Settings').children('.velsof_error_label').show();
            $('#link-General_Settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        if (registration_setting_tab === 1) {
            $('#link-Registration_Page_Settings').children('.velsof_error_label').show();
            $('#link-Registration_Page_Settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        if (login_setting_tab === 1) {
            $('#link-Login_Page_Settings').children('.velsof_error_label').show();
            $('#link-Login_Page_Settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        if (sms_setting_tab === 1) {
            $('#link-Sms_Notification_Settings').children('.velsof_error_label').show();
            $('#link-Sms_Notification_Settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        if (otp_setting_tab === 1) {
            $('#link-Otp_settings').children('.velsof_error_label').show();
            $('#link-Otp_settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        if (sms_gateway_setting_tab === 1) {
            $('#link-Sms_Gateway_Settings').children('.velsof_error_label').show();
            $('#link-Sms_Gateway_Settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        if (mobile_detail_setting_tab === 1) {
            $('#link-Mobile_Details_Settings').children('.velsof_error_label').show();
            $('#link-Mobile_Details_Settings').children().children('#velsof_error_icon').css('display', 'inline');
        }
        return false;
    }
}
