/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 * We offer the best and most useful modules PrestaShop and modifications for your online store.
 *
 * @author    knowband.com <support@knowband.com>
 * @copyright 2017 Knowband
 * @license   see file: LICENSE.txt
 * @category  PrestaShop Module
 *
 *
 * Description
 *
 */

$(document).ready(function () {
    //Code for signup page
    if (typeof kb_form_name !== 'undefined') {
        /**
         * Added a condition to check if the page is registration page or not only applicable for prestashop 8.0.0
         * @date 15-03-2023
         * @author Prvind Panday
         */
        if ((kb_form_name == 'authentication') || (kb_form_name == 'registration') || (kb_form_name == 'identity') || (kb_form_name == 'order')) {
            if (show_mobile_on_registration == '1') {
                if (typeof register_without_email !== 'undefined') {
                    if (register_without_email == 1) {
                        /**
                         * if email is not required then we need to add a text to show that email is optional
                         * @date 23-03-2023
                         * @commenter Prvind Panday
                         */
                        var optionalHtml = '<div class="col-md-3 form-control-comment">' + optionalText + '</div>';
                        $('#customer-form input[name="email"]').parent().after(optionalHtml);
                        $('#customer-form input[name="email"]').removeAttr('required');
                        if (show_email_on_registration != '1') {
                            $('#customer-form input[name="email"]').closest('.form-group').hide();
                            $('#customer-form input[name="email"]').removeAttr('required');
                        }
                    }
                }
                $('#customer-form input[name="email"]').closest('.form-group').after($('#kb_mobile_login_field_block'));
                $('input[name="kbmob_mobile_number"], select[name="kbmob_country_id"]').on('change', function () {
                    /**
                     * check mobile number exist or not once user enter mobile number on registration page or checkout page
                     * @returns {undefined}
                     * @date 23-03-2023
                     * @commenter Prvind Panday
                     */
                    checkMobileNumberExist();
                });
                $('#sendOTP').on('click', function () {
                    /**
                     * send OTP to user mobile number once user click on send OTP button
                     * @returns {undefined}
                     * @date 23-03-2023
                     * @commenter Prvind Panday
                     */
                    sendOTP();
                });
                $('#kbVerifyOTP').on('click', function () {
                    /**
                     * verify OTP once user enter OTP and click on verify OTP button
                     * @returns {undefined}
                     * @date 23-03-2023
                     * @commenter Prvind Panday
                     */
                    kbVerifyOTP();
                });
                /**
                 * if mobile number verification is enabled then we need to disable the submit button on registration page
                 * @date 23-03-2023
                 * @commenter Prvind Panday
                 */
                if (verify_mobile_on_registration == '1') {
                    if (kb_form_name == 'order'){
                        $('#customer-form .form-footer .continue').attr('disabled', 'disabled'); 
                    } else{
                        $('.form-control-submit').attr('disabled', 'disabled');
                    }
                }
                /**
                 * if mobile number is verified then we need to enable the submit button on registration page
                 * @date 23-03-2023
                 * @commenter Prvind Panday
                 */
                if (kb_mobile_verified == '1') {
                    $('#status_valid').show();
                    if (kb_form_name == 'order') {
                        /**
                         * Start changes to fix the submit button disable issue on registration page
                         * NAAug2023 disabled
                         * @date 07-08-2023
                         * @author Nikhil Aggarwal
                         */
                        $('#customer-form .form-footer .continue').removeAttr('disabled');
                        // Changes end by Nikhil
                    } else{
                    $('.form-control-submit').removeAttr('disabled');
                }
                    
            }
            }

            if ($('#login-form').length) {
                if (login_by_mobile == '1') {
                     /**
                     * Start Changes to fix the issue of email being shown when page is reloading in case of authentication failure 
                     * On Page load making the email field blank for the login-page only
                     * NAFeb2024 disabled_email
                     * @date 13-02-2024
                     * @modifier Nikhil Aggarwal
                     */
                    $('#login-form input[name="email"]').val('');
                    // Changes end by Nikhil
                    $('#login-form input[name="email"]').closest('.form-group').find('label').text(email_label_text);
                    $('#login-form input[name="email"]').attr('type', 'text');
                    /**
                     * Following code line was commented as we are passing the value after ajax request 
                     * ASFeb2024 Post_Change
                     * @date 08-02-2024
                     * @modifier Amit Singh
                     */
                    // $('#login-form input[name="email"]').val(customer_email);
                    // End of change

                }
            }
        } else if (kb_form_name == 'password') {
            $reset_password_html = '';
            $('section #main form').append($('#kb_reset_password_otp_link').html());
        }
    }
    
    //changes by vishal
    if (!(typeof kb_add_required_js === 'undefined')) {
        if (prestashop.customer.email == null) {
            $(".no-account").appendTo("#checkout-login-form");
            $(".no-account").css('text-align', 'center');
            $(".no-account").css('margin-top', '2%');
        } else {
            $('#kb_mobile_login').hide();
        }
    }
    //changes end
});

/**
 * function to check mobile number exist or not once user enter mobile number on registration page or checkout page
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function checkMobileNumberExist() {

    if ((verify_mobile_on_registration == '1') || (mobile_number_required == '1')) {
        $('#customer-form button[type="submit"]').attr('disabled', 'disabled');
    }
    $('#customer-form #sendOTP').attr('disabled', 'disabled');
    var kbMobileNumber = $.trim($('input[name="kbmob_mobile_number"]').val());
    var current_validation_element = $('input[name="kbmob_mobile_number"]');
    var kbCountryId = $.trim($('select[name="kbmob_country_id"]').val());
    if ((kbMobileNumber != '')) {
        current_error = velovalidation.isNumeric(current_validation_element, true);
        if (current_error !== true) {
            $('.kb-help-block').html('<ul><li class="alert alert-danger">' + kb_mobile_number_error_mesage + '</li></ul>');
        } else {
            $('.kb-help-block').html('');
        }

        if (current_error == true) {
            if (kbMobileNumber.length > 0) {
                if ((min_mobile_length != '0') && (kbMobileNumber.length < parseInt(min_mobile_length))) {
                    $('.kb-help-block').html('<ul><li class="alert alert-danger">' + kb_mobile_number_length + ' ' + kb_minimum_text + ' ' + min_mobile_length + ' ' + kb_digit_text + '</li></ul>');
                    return false;
                }
                if ((max_mobile_length != '0') && (kbMobileNumber.length > parseInt(max_mobile_length))) {
                    $('.kb-help-block').html('<ul><li class="alert alert-danger">' + kb_mobile_number_length + ' ' + kb_maximum_text + ' ' + max_mobile_length + ' ' + kb_digit_text + '</li></ul>');
                    return false;
                }
            }
        }

        if ((kbMobileNumber != '') && (kbCountryId != '')) {
            current_error = velovalidation.isNumeric(current_validation_element, true);
            if (current_error == true) {
                $('#sendOTP').show();
                $('#status_valid').hide();
                if (verify_mobile_on_registration == '1') {
                    if (kb_form_name == 'order'){
                        /**
                         * Start changes to fix the submit button disable issue on registration page
                         * NAAug2023 disabled
                         * @date 07-08-2023
                         * @author Nikhil Aggarwal
                         */
                        $('#customer-form .form-footer .continue').attr('disabled', 'disabled');
                        // Changes end by Nikhil 
                    } else{
                    $('.form-control-submit').attr('disabled', 'disabled');
                }
                }
                kb_mobile_verified = 0;
                $.ajax({
                    url: kbmobile_front_url,
                    type: 'post',
                    //             async: false,
                    data: {
                        "ajax": true,
                        "method": "checkMobileNumberExist",
                        "currentCustomerId": current_customer_id,
                        "kbMobileNumber": kbMobileNumber,
                        "kbCountryId": kbCountryId
                    },
                    dataType: 'json',
                    async:false,
                    beforeSend: function () {
                        $('#kb_otp_loading').show();
                    },
                    success: function (json) {
                        if (json) {
                            $('#sendOTP').hide();
                            $('.kb-help-block').html('<ul><li class="alert alert-danger">' + kbmobile_exist_message + '</li></ul>');
                            $('#status_valid').hide();
                            $('#kb_verify_otp').hide();
                            $('#customer-form button[type="submit"]').attr('disabled', 'disabled');
                        } else {
                            if ((verify_mobile_on_registration != '1')) {
                                $('#customer-form button[type="submit"]').removeAttr('disabled');
                            }
                            $('#customer-form #sendOTP').removeAttr('disabled');


                            $('.kb-help-block').html('');
                            $('#sendOTP').show();
                        }
                    },
                    complete: function () {
                        $('#kb_otp_loading').hide();
                    }
                });
            }
        } else {
            $('#sendOTP').hide();
        }
    }

}

/**
 * Send OTP to customer mobile number for verification
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function sendOTP() {
    var kbMobileNumber = $.trim($('input[name="kbmob_mobile_number"]').val());
    var kbCountryId = $.trim($('select[name="kbmob_country_id"]').val());
    /**
     * Check if mobile number is not empty and country is selected then send OTP
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    if ((kbMobileNumber != '') && (kbCountryId != '')) {
        $.ajax({
            url: kbmobile_front_url,
            type: 'post',
            data: {
                "ajax": true,
                "method": "sendOTP",
                "kbMobileNumber": kbMobileNumber,
                "kbCountryId": kbCountryId
            },
            dataType: 'json',
            async:false,
            beforeSend: function () {
                $('#kb_otp_loading').show();
            },
            success: function (json) {
                if (json.success) {
                    $('.kb-help-block').html('<ul><li class="alert alert-success">' + json.message + '</li></ul>');
                    $('#kb_verify_otp').show();
                    $('input[name="kbotp"]').val('');
                } else {
                    $('.kb-help-block').html('<ul><li class="alert alert-danger">' + json.message + '</li></ul>');
                }
            },
            complete: function () {
                $('#kb_otp_loading').hide();
            }
        });
    }
}

/**
 * Function to verify OTP when customer clicks on verify button
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function kbVerifyOTP() {
    var kbMobileNumber = $.trim($('input[name="kbmob_mobile_number"]').val());
    var kbCountryId = $.trim($('select[name="kbmob_country_id"]').val());
    var kbCurrentOTP = $.trim($('input[name="kbotp"]').val());
    /**
     * If OTP, mobile number and country id is not empty then send an ajax request to verify OTP
     * @date 23-03-2023
     * @commenter Prvind Panday
     */
    if ((kbMobileNumber != '') && (kbCountryId != '') && (kbCurrentOTP != '')) {
        $('.kb-otp-help-block').html('');
        $.ajax({
            url: kbmobile_front_url,
            type: 'post',
            data: {
                "ajax": true,
                "method": "verifyOTP",
                "kbMobileNumber": kbMobileNumber,
                "kbCountryId": kbCountryId,
                "kbCurrentOTP": kbCurrentOTP
            },
            dataType: 'json',
            beforeSend: function () {
                $('#kb_verify_otp_loading').show();
            },
            success: function (json) {
                if (json.success) {
                    $('#status_valid').show();
                    $('#kb_verify_otp').hide();
                    $('#sendOTP').hide();
                    $('.kb-help-block').html('');
                    $('.form-control-submit').removeAttr('disabled');
                    /**
                     * Start changes to fix the submit button disable issue on registration page
                     * NAAug2023 disabled
                     * @date 07-08-2023
                     * @author Nikhil Aggarwal
                     */
                    $('#customer-form .form-footer .continue').removeAttr('disabled');
                    // Changes end by Nikhil
                    kb_mobile_verified = 1;
                } else {
                    $('.kb-help-block').html('<ul><li class="alert alert-danger">' + json.message + '</li></ul>');
                    $('#status_valid').hide();
                }
            },
            complete: function () {
                $('#kb_verify_otp_loading').hide();
            }
        });
    } else if (kbCurrentOTP == '') {
        /**
         * If OTP is empty then show error message to user
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        $('.kb-otp-help-block').html('<ul><li class="alert alert-danger">' + otp_empty_error_message + '</li></ul>');
    }
}

/**
 * Function to resend OTP when customer clicks on resend button and show timer to user
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
if ((typeof next_otp != "undefined") && next_otp) {
    $('#kbResendOTP').hide();
    $('#kbResendOTP').prop('disabled', true);
    $('#waiting-message').show();

    var seconds = next_otp;
    tick(seconds);
}

/**
 * function to delete timer and show resend button once the time is up.
 * @param {*} seconds 
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function tick(seconds) {
    if (seconds > 0) {
        showTimer(seconds);
        seconds--;
        setTimeout(tick, 1000, seconds);
    } else {
        deleteTimer();
    }
}

/**
 * show timer on the page to show the user how much time is left to resend the OTP.
 * @param {*} seconds 
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function showTimer(seconds) {
    var secondText = (seconds > 1) ? ' seconds' : ' second';
    if ($('#waiting-message').length) {
        $('#waiting-message').show();
        $('#waiting-message').html(waiting_msg + ' ' + seconds + secondText);
    }
}

/**
 * Delete timer and show resend button once the time is up.
 * @returns {undefined}
 * @date 23-03-2023
 * @commenter Prvind Panday
 */
function deleteTimer() {
    if ($('#waiting-message').length) {
        $('#waiting-message').remove();
    }
    $('#kbResendOTP').show();
    $('#kbResendOTP').prop('disabled', false);
}

/**
 *  Added new code to check if mobile number exist or not through the Ajax requet
 *  And the email id will be passed on place of mobile number 
 *  To remove the use of POST
 *  ASFeb2024 Post_Change
 *  @date 08-02-2024
 *  @modifier Amit Singh
 */
$('#customer-form').submit(function () {
    // Check if the email field is blank
    var emailValue = $('#field-email').val().trim();
    if (emailValue === '') {
        var firstname = $.trim($('input[name="firstname"]').val());
        var lastname = $.trim($('input[name="lastname"]').val());
        var tempEmailFormat = temp_email_format;
        
        // Generate the email value
        var generatedEmail = firstname + '_' + lastname + '_' + generateUniqueId('mob_') + tempEmailFormat;
        $('#field-email').val(generatedEmail);
          
        $('#customer-form input[name="email"]').closest('.form-group').hide();
        var newInputField ='<div class="form-group row ">'+
                '<label class="col-md-3 form-control-label" for="field-email"> Email </label>'+
            '<div class="col-md-6 js-input-column">'
            +'<input id="field-email" class="form-control" name="kbemail" type="email" value="'+ emailValue +'">'
            +'</div>'+'<div class="col-md-3 form-control-comment">'+ optionalText +'</div>'
            +'<div class="col-md-3 form-control-comment"></div>'+'</div>';

            $(newInputField).insertAfter($('#customer-form input[name="email"]').closest('.form-group'));


    }
    this.submit();
});

function generateUniqueId(prefix) {
    return prefix + Math.random().toString(36).substr(2, 9);
}

$('#login-form').submit(function () {

        var kbMobileNumber = $('input[name="email"]').val();
    
        // Check if the email field is blank
        $.ajax({
            url: kbmobile_front_url,
            type: 'post',
            data: {
                "ajax": true,
                "method": "checkMobileNumberemail",
                "kbMobileNumber": kbMobileNumber,
            },
            dataType: 'json',
            async:false,
            beforeSend: function () {
                $('#kb_otp_loading').show();
            },
            success: function (json) {
                if (json.success) {
                    var customer_email = json.email;
                    //Amit
                    $('#login-form input[name="email"]').closest('.form-group').find('label').text(email_label_text);
                    $('#login-form input[name="email"]').attr('type', 'text');
                    $('#login-form input[name="email"]').val(customer_email);

                    $('#login-form input[name="email"]').closest('.form-group').hide();

                    // Add new input field for kbemail
                    var newInputField = '<div class="form-group row" style="display: block">' +
                    '<label class="col-md-3 form-control-label" for="field-kbemail">'+ email_label_text +'</label>' +
                    '<div class="col-md-6 js-input-column">' +
                    '<input id="field-kbemail" class="form-control" name="kbemail" type="text" value="' + kbMobileNumber + '">' +
                    '</div>' +
                    '</div>';
                   $('#login-form').prepend(newInputField);
               
                   
                } else{
        
                }
            },
        });
    
        // Submit the form
        this.submit();
    });

