{extends file=$layout}
{block name = 'content'}
    <style>
        /* For Firefox */
        input[type='number'] {
            -moz-appearance:textfield;
        }
        /* Webkit browsers like Safari and Chrome */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        {*    {$kb_custom_css nofilter}*}
    </style>
    {if isset($kb_mob_configuration) && is_array($kb_mob_configuration)}

        {if isset($cookie_error) && ($cookie_error neq '')}
            <div class="alert alert-danger">
                {foreach $cookie_error as $error}
                    <p>{$error nofilter}</p>{*variable Can not escape *}
                {/foreach}
            </div>
        {/if}
        {if isset($cookie_success) && ($cookie_success neq '')}

            <div class="alert alert-success">
                <p>{$cookie_success nofilter}</p>{*variable Can not escape *}
            </div>
        {/if}

        <section id="main">
            <header class="page-header">
                <h1>
                    {if $login_reset eq 'login'}
                        {l s='Login by OTP with registered mobile number' mod='kbmobilelogin'}
                    {else}
                        {l s='Reset your password by OTP on your registered mobile number' mod='kbmobilelogin'}
                    {/if}
                </h1>

            </header>
            {if $otp_type eq 'login'}
                <section id="content kb-phone-verification-section" class="offset-md-3 col-md-6 page-content card card-block">
                    <p>{l s='Enter your mobile number which you had given at the time of registration.' mod='kbmobilelogin'}</p>
                    <section>
                        <form action="{$link->getModuleLink('kbmobilelogin','verification')|escape:'html':'UTF-8'}{if $link->getModuleLink('kbmobilelogin','verification')|strstr:'?'}&login_reset=1{else}?login_reset=1{/if}" method="post">
                            <section>
                                <div class="form-group row">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='Select Country' mod='kbmobilelogin'}
                                    </label>
                                    <div class="col-md-6">
                                        <select class="form-control form-control-select" name="kbmob_country_id"  required>
                                            <option value="" disabled="" selected="">{l s='-- Please choose --' mod='kbmobilelogin'}</option>
                                            {if is_array($total_active_country) && !empty($total_active_country)}
                                                {foreach $total_active_country as $country_details}
                                                    <option value="{$country_details['id_country'] nofilter}">{$country_details['country'] nofilter} (+{$country_details['prefix'] nofilter}) </option>{*variable Can not escape *}
                                                {/foreach}
                                            {/if}
                                        </select>
                                    </div>
                                    <div class="col-md-3 form-control-comment">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='Mobile' mod='kbmobilelogin'}
                                    </label>
                                    <div class="col-md-6">
                                        <input class="form-control" name="kbmob_mobile_number" type="number" value="" {if ($kb_mob_configuration['min_mobile_length'] neq '') ||($kb_mob_configuration['min_mobile_length'] neq '0')} minlength="{$kb_mob_configuration['min_mobile_length'] nofilter}" {/if} {if ($kb_mob_configuration['max_mobile_length'] neq '') ||($kb_mob_configuration['max_mobile_length'] neq '0')} maxlength="{$kb_mob_configuration['max_mobile_length'] nofilter}" {/if}   required> {*variable Can not escape *}
                                    </div>
                                </div> 
                            </section>
                            <footer class="form-footer text-xs-center clearfix">
                                <button id="kbSendOTP" class="btn btn-primary" type="submit" name="kbSendOTP" >{l s='Send OTP' mod='kbmobilelogin'}</button>
                            </footer>
                        </form>
                    </section>

                    <hr>
                    <div style="font-size: 1rem; text-align: center; margin-bottom: 0.4rem;">
                        {l s='Already have a verified account?' mod='kbmobilelogin'} 
                        <a href="{$urls.pages.authentication}">{l s='Log in instead!' mod='kbmobilelogin'}</a>{*variable contains HTML content, Can not escape this*}
                    </div>
                    <div style="font-size: 1rem; text-align: center; margin-bottom:0.4rem;">
                        <a href="{$urls.pages.register}">{l s='No account? Create one here' mod='kbmobilelogin'}</a>{*variable contains HTML content, Can not escape this*}
                    </div>
                </section>
            {else  if $otp_type eq 'verifyotp'}
                <section id="content kb-phone-verification-section" class="offset-md-3 col-md-6 page-content card card-block">
                    <p>{l s='Please enter OTP to verify mobile number.' mod='kbmobilelogin'}</p>
                    <section>
                    {$url = $link->getModuleLink('kbmobilelogin','verification')}
                    {$login_reset_param = 'reset=1'}
                        <form action="{$url|escape:'html':'UTF-8'}{if $url|strstr:'?'}&verifyotp=1&{$login_reset_param}{else}?verifyotp=1&{$login_reset_param}{/if}" method="post">{*variable contains HTML content, Can not escape this*}
                            <input type='hidden' name="kbmob_country_id" value="{$kbmob_country_id nofilter}" required="" type="text" hidden="">{*variable Can not escape *}
                            <input type='hidden' name="kbmob_mobile_number" value="{$kbmob_mobile_number nofilter}" required="" type="text" hidden="">{*variable Can not escape *}
                            <section>
                                <div class="form-group row">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='OTP' mod='kbmobilelogin'}
                                    </label>
                                    <div class="col-md-6">
                                        <input class="form-control" name="kbmob_otp" type="number" value="" {if ($kb_mob_configuration['min_mobile_length'] neq '') ||($kb_mob_configuration['min_mobile_length'] neq '0')} minlength="{$kb_mob_configuration['min_mobile_length'] nofilter}" {/if} {if ($kb_mob_configuration['max_mobile_length'] neq '') ||($kb_mob_configuration['max_mobile_length'] neq '0')} maxlength="{$kb_mob_configuration['max_mobile_length'] nofilter}" {/if}   required> {*variable Can not escape *}
                                    </div>
                                </div> 
                            </section>
                            <footer class="form-footer text-xs-center clearfix">
                                <button id="kbVerifyOTP" class="btn btn-primary" type="submit" name="kbVerifyOTP" >{l s='Verify OTP' mod='kbmobilelogin'}</button>
                            </footer>
                        </form>
                    </section>

                    <hr>

                    <div style="text-align:  center;">
                    {$url = $link->getModuleLink('kbmobilelogin','verification')}
                    {$login_reset_param = 'reset=1'}
                        <form action="{$url|escape:'html':'UTF-8'}{if $url|strstr:'?'}&verifyotp=1&{$login_reset_param}{else}?verifyotp=1&{$login_reset_param}{/if}" method="post">{*variable Can not escape *}
                            <input type='hidden' name="kbmob_country_id" value="{$kbmob_country_id nofilter}" required="" type="text" hidden="">{*variable Can not escape *}
                            <input type='hidden' name="kbmob_mobile_number" value="{$kbmob_mobile_number nofilter}" required="" type="text" hidden="">{*variable Can not escape *}

                            {l s='Didn\'t receive OTP?' mod='kbmobilelogin'}

                            <button id="kbResendOTP" class="btn-link form-group" type="submit" name="kbResendOTP" style="cursor: pointer;">{l s='Resend OTP' mod='kbmobilelogin'}</button>
                            <div class="form-group" id="waiting-message" style="">{l s='You can request for another OTP after 12 seconds' mod='kbmobilelogin'}</div>

                        </form>
                    </div>

                    <div style="font-size: 1rem; text-align: center; margin-bottom: 0.4rem;">
                        {* Start Changes to fix the URL issue
                        Added condition to check if ? already exist in URL then, append & otherwise ?
                        NAAug2023 URL
                        @date 18-08-2023
                        @modifier Nikhil Aggarwal
                        *}
                        {l s='Entered the wrong mobile number?' mod='kbmobilelogin'} <a href="{if strpos($link->getModuleLink('kbmobilelogin', 'verification'), '?') !== false}
                            {$link->getModuleLink('kbmobilelogin', 'verification')|escape:'html':'UTF-8'}&{$login_reset nofilter}=1{else} {*variable Can not escape *}
                            {$link->getModuleLink('kbmobilelogin', 'verification')|escape:'html':'UTF-8'}?{$login_reset nofilter}=1{*variable Can not escape *}
                        {/if}" >{l s='Change mobile number' mod='kbmobilelogin'}</a>
                        {*Changes end by Nikhil*}
                    </div>
                </section>
            {/if}
        </section>
    {/if}
    <script>
        var next_otp = "{$kb_mob_configuration['otp_resend_duration'] nofilter}";{*variable Can not escape *}
        var waiting_msg = "{l s='You can request for another OTP after ' mod='kbmobilelogin'}";
    </script>
{/block}



{*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer tohttp://www.prestashop.com for more information.
* We offer the best and most useful modules PrestaShop and modifications for your online store.
*
* @category  PrestaShop Module
* @author    knowband.com <support@knowband.com>
* @copyright 2017 Knowband
* @license   see file: LICENSE.txt
*
*}