<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Accrual extends ObjectModel
{
    public $id;

    public $id_object;

    public $type;

    public $increased;

    public static $definition = array(
        'table' => 'bonus_accrual',
        'primary' => 'id_accrual',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            'increased' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice', 'required' => true),
            'id_object' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'type' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'size' => 20
            )
        )
    );

    public function add($autodate = false, $null_values = true)
    {
        $success = parent::add($autodate, $null_values);
        return $success;
    }

    public function update($null_values = true)
    {
        $success = parent::update($null_values);
        return $success;
    }

    public static function getAccrual($product)
    {
        $procent = 0;

        if (isset($product['id_product']) && $product['id_product']) {
            $procent = Db::getInstance()->getValue('
                SELECT `increased`
                FROM '._DB_PREFIX_.'bonus_accrual
                WHERE `id_object` = '.(int)$product['id_product'].'
                AND `type` = "product"
            ');

            if ($procent) {
                return $procent;
            }
        }

        if (isset($product['id_category_default']) && $product['id_category_default']) {
            $procent = Db::getInstance()->getValue('
                SELECT `increased`
                FROM '._DB_PREFIX_.'bonus_accrual
                WHERE `id_object` = '.(int)$product['id_category_default'].'
                AND `type` = "category"
            ');

            if ($procent) {
                return $procent;
            }
        }

        if (isset($product['id_manufacturer']) && $product['id_manufacturer']) {
            $procent = Db::getInstance()->getValue('
                SELECT `increased`
                FROM '._DB_PREFIX_.'bonus_accrual
                WHERE `id_object` = '.(int)$product['id_manufacturer'].'
                AND `type` = "brand"
            ');

            if ($procent) {
                return $procent;
            }
        }

        return $procent;
    }
}
