<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Actions extends ObjectModel
{
    public $id;

    public $type;

    public $point;

    public $point_self = 0;

    public $status;

    public $many_days;

    public $date_from;

    public $date_to;

    public static $definition = array(
        'table' => 'bonus_actions',
        'primary' => 'id_bonusactions',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            'point' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice','required' => true),
            'point_self' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice','required' => false),
            'status' => array('type' => self::TYPE_BOOL,'validate' => 'isBool'),
            'date_from' => array('type' => self::TYPE_DATE,'validate' => 'isDate','required' => true),
            'date_to' => array('type' => self::TYPE_DATE,'validate' => 'isDate','required' => true),
            'many_days' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt','required' => true),
            'type' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'size' => 255
            )
        )
    );

    public static function getBonusActions($type, $id_customer)
    {
        if ($type == 'birthday') {
            $exist = Db::getInstance()->getValue('
                SELECT id_bonusaccount
                FROM ' . _DB_PREFIX_ . 'bonus_account
                WHERE id_customer = '.(int)$id_customer.'
                AND type = "birthday"
                AND DATE_FORMAT( `date_add` , "%Y") = "'.date('Y').'"');
        } else {
            $exist = Db::getInstance()->getValue('
                SELECT id_bonusaccount
                FROM ' . _DB_PREFIX_ . 'bonus_account
                WHERE id_customer = '.(int)$id_customer.'
                AND type = "'.$type.'"');
        }
        if (!$exist) {
            return Db::getInstance()->getRow('
                SELECT point,many_days,point_self
                FROM '._DB_PREFIX_.'bonus_actions
                WHERE type = "'.$type.'"
                AND status = 1
                AND date_from <= "'.date('Y-m-d H:i:s').'"
                AND date_to >= "'.date('Y-m-d H:i:s').'"');
        }
    }

    public static function getAction($type)
    {
        return Db::getInstance()->getValue('
            SELECT id_bonusactions
            FROM '._DB_PREFIX_.'bonus_actions
            WHERE type = "'.$type.'"
            AND status = 1
            AND date_from <= "'.date('Y-m-d H:i:s').'"
            AND date_to >= "'.date('Y-m-d H:i:s').'"');
    }

    public function add($autodate = false, $null_values = true)
    {
        $success = parent::add($autodate, $null_values);
        return $success;
    }

    public function update($null_values = true)
    {
        $success = parent::update($null_values);
        return $success;
    }
}
