<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class BonusaccountObj extends ObjectModel
{
    public $id;

    public $id_customer;

    public $id_order;

    public $id_cart_rule;

    public $points;

    public $comment;

    public $status;

    public $paid;

    public $type;

    public $date_add;

    public $date_bonus_to;

    public static $definition = array(
        'table' => 'bonus_account',
        'primary' => 'id_bonusaccount',
        'fields' => array(
            'id_customer' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt','required' => true),
            'id_order' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt','required' => true),
            'id_cart_rule' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt','required' => true),
            'points' => array('type' => self::TYPE_FLOAT, 'required' => true),
            'comment' => array('type' => self::TYPE_STRING,'validate' => 'isCleanHtml','size' => 65000),
            'status' => array('type' => self::TYPE_BOOL,'validate' => 'isUnsignedInt','required' => true),
            'paid' => array('type' => self::TYPE_BOOL,'validate' => 'isBool'),
            'type' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'size' => 255
            ),
            'date_add' => array('type' => self::TYPE_DATE,'validate' => 'isDate'),
            'date_bonus_to' => array('type' => self::TYPE_DATE,'validate' => 'isDate')
        ));

    public function add($autodate = true, $null_values = false)
    {
        $this->date_add = date('Y-m-d H:i:s');
        $success = parent::add($autodate, $null_values);
        return $success;
    }

    public function update($null_values = true)
    {
        $success = parent::update($null_values);
        return $success;
    }

    public static function getCount($id_customer)
    {
        return  Db::getInstance()->getRow('
                SELECT COUNT(*) AS count
                FROM ' . _DB_PREFIX_ . 'bonus_account WHERE id_customer = '.(int)$id_customer);
    }

    public static function getPointsByCustomer($id_customer)
    {
        $balance = Db::getInstance()->getValue('
            SELECT 
            SUM(IF(`status` = 1, `points`, - `points`) -
            IF(
            `status` = 1 AND `date_bonus_to` < NOW(),
            GREATEST(0, ba.`points` - (
                SELECT SUM(`points`)
                FROM `'._DB_PREFIX_.'bonus_account` `used`
                WHERE  
                `used`.`id_customer` = ba.`id_customer` AND `status` = 2 AND
                `paid` = 1 AND `used`.`date_add` < ba.`date_bonus_to`
            )), 
            0)) `balance`
            FROM `'._DB_PREFIX_.'bonus_account` AS ba
            WHERE  
                `id_customer` = '.(int)$id_customer.' AND
                `paid` = 1 
            GROUP BY ba.`id_customer`');
        return $balance > 0 ? $balance : 0;
    }

    public static function getListByCustomerPay($id_customer, $p = 1, $n = 5)
    {
        if ($p < 1) {
            $p = 1;
        }
        return Db::getInstance()->executeS('
            SELECT *
            FROM '._DB_PREFIX_.'bonus_account l
            LEFT JOIN `' . _DB_PREFIX_ . 'orders` oc ON l.id_order = oc.id_order
            WHERE l.id_customer = '.(int)$id_customer.'
            ORDER BY l.date_add DESC LIMIT '.(((int)$p - 1) * (int)$n).','.(int)$n);
    }

    public static function getListByCustomerPayone($id_order)
    {
        return Db::getInstance()->executeS('
            SELECT *
            FROM '._DB_PREFIX_.'bonus_account 
            WHERE id_order = '.(int)$id_order);
    }

    public static function bonusUpdate($id_customer, $price)
    {
        $context = Context::getContext();
        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            $hash = Tools::hash((int)$context->customer->id);
        } else {
            $hash = ToolsBonus::hash16((int)$context->customer->id);
        }
        return Db::getInstance()->update(
            'cart_rule',
            array(
                'reduction_amount' => pSQL($price),
            ),
            'id_customer = '.(int)$id_customer.' AND code = \'' . pSQL($hash) . '\''
        );
    }
}
