<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Increased extends ObjectModel
{
    public $id;

    public $increased;

    public $id_product;

    public $id_category = 0;

    public $status;

    public $date_from;

    public $date_to;

    public static $definition = array(
        'table' => 'bonus_increased',
        'primary' => 'id_increased',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            'increased' => array('type' => self::TYPE_FLOAT,'validate' => 'isPrice','required' => true),
            'id_product' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt'),
            'id_category' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt'),
            'status' => array('type' => self::TYPE_BOOL,'validate' => 'isBool'),
            'date_from' => array('type' => self::TYPE_DATE,'validate' => 'isDate','required' => true),
            'date_to' => array('type' => self::TYPE_DATE,'validate' => 'isDate','required' => true)
        )
    );

    public static function getTemplateLang($id_increased)
    {
        $ret = Db::getInstance()->getValue('
            SELECT id_category
            FROM '._DB_PREFIX_.'bonus_increased
            WHERE id_increased = '.(int)$id_increased);
        return $ret;
    }

    public static function getIncreased($id_product = 0)
    {
        $product = Db::getInstance()->getValue('SELECT increased
            FROM '._DB_PREFIX_.'bonus_increased
            WHERE status = 1
            AND id_product = ' . (int)$id_product .'
            AND date_from <= "'.date('Y-m-d H:i:s').'"
            AND date_to >= "'.date('Y-m-d H:i:s').'"');

        if (!$product) {
            $idis = Product::getProductCategories($id_product);
            $category = Db::getInstance()->getValue('SELECT increased
                FROM '._DB_PREFIX_.'bonus_increased
                WHERE status = 1
                AND id_category IN (' . implode(',', $idis) . ')
                AND date_from <= "'.date('Y-m-d H:i:s').'"
                AND date_to >= "'.date('Y-m-d H:i:s').'"');
            return $category;
        } else {
            return $product;
        }
    }

    public static function getActiveProduct($id_product)
    {
        $id_lang = Context::getContext()->language->id;
        $query = 'SELECT p.`id_product`, p.`reference`, pl.name
            FROM `'._DB_PREFIX_.'product` p
            LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (pl.`id_product` = p.`id_product` AND pl.`id_lang` = '.(int) $id_lang.')
            '.Shop::addSqlRestrictionOnLang('pl').'
            WHERE p.`id_product` = '.(int)$id_product.'
            ORDER BY p.`id_product`';

        $row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($query);
        return $row;
    }
}
