<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Levels extends ObjectModel
{
    public $id;

    public $return;

    public $min_range;

    public $max_range;

    public $name;

    public $description;

    public static $definition = array(
        'table' => 'bonus_levels',
        'primary' => 'id_bonuslevels',
        'multilang' => true,
        'multilang_shop' => false,
        'fields' => array(
            'return' => array('type' => self::TYPE_INT,'validate' => 'isUnsignedInt','required' => true),
            'min_range' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice','required' => true),
            'max_range' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice','required' => true),
            'name' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'size' => 255,
                'lang' => true
            ),
            'description' => array(
                'type' => self::TYPE_STRING,
                'required' => false,
                'validate' => 'isCleanHtml',
                'size' => 65000,
                'lang' => true
            )
        )
    );

    public function add($autodate = false, $null_values = true)
    {
        $success = parent::add($autodate, $null_values);
        return $success;
    }

    public function update($null_values = true)
    {
        $success = parent::update($null_values);
        return $success;
    }

    public static function getLevelPercent($product, $customer)
    {
        $default_percentage = (int)Configuration::get('PS_LOYALTY_LEVEL_DEFAULT');
        $percentage = Accrual::getAccrual($product);
        if ((int)$percentage > 0) {
            $default_percentage = $percentage;
        }

        $level = false;
        $increased = 0;
        if (isset($product['id_product']) && $product['id_product']) {
            $increased = Increased::getIncreased((int)$product['id_product']);
        }

        if (Validate::isLoadedObject($customer)) {
            $customer = new Customer((int)$customer->id);
            $total_orders = $customer->getStats();
            $level = Db::getInstance()->getValue('
                SELECT `return`
                FROM '._DB_PREFIX_.'bonus_levels
                WHERE `min_range` <= '.(float)$total_orders['total_orders'].'
                AND `max_range` >= '.(float)$total_orders['total_orders']);
        }

        if ($level) {
            return array(
                'return' => (int)($default_percentage + $level + $increased),
                'isFlash' => $increased > 0 ? true : false
            );
        } else {
            return array(
                'return' => (int)($default_percentage + $increased),
                'isFlash' => $increased > 0 ? true : false
            );
        }
    }

    public static function getLevelInfo($id_customer, $id_lang)
    {
        $customer = new Customer((int)$id_customer);
        $total_orders = $customer->getStats();
        $level = Db::getInstance()->getRow('
            SELECT *
            FROM '._DB_PREFIX_.'bonus_levels bl
            LEFT JOIN `' . _DB_PREFIX_ . 'bonus_levels_lang` bll 
            ON (bll.id_bonuslevels = bl.id_bonuslevels AND bll.`id_lang` = ' . (int) $id_lang . ')
            WHERE bl.`min_range` <= '.(float)$total_orders['total_orders'].'
            AND bl.`max_range` >= '.(float)$total_orders['total_orders']);
        return $level;
    }
}
