<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class ToolsBonus
{
    public static function getTotalcart()
    {
        $context = Context::getContext();
        $cart = new Cart((int)$context->cart->id);
        if (Validate::isLoadedObject($cart)) {
            $total_prod = self::getProductsPriceCart((int)$cart->id);
            $total_price = 0;

            foreach ($total_prod as $value) {
                $total_price += $value['total_wt'];
            }
            if ($total_price < 0) {
                return 0;
            } else {
                return $total_price;
            }
        } else {
            return false;
        }
    }

    public static function getTotalCartRule($id_cart_rule, $cart, $customer)
    {
        $cart = new Cart((int)$cart->id);
        if (Validate::isLoadedObject($cart)) {
            $cart_cart_rule = Db::getInstance()->getRow('
                SELECT *
                FROM '._DB_PREFIX_.'cart_cart_rule
                WHERE id_cart = '.(int)$cart->id.'
                AND id_cart_rule = '.(int)$id_cart_rule);
            $total_prod = self::getProductsPriceCart((int)$cart->id);

            $total_price = 0;
            foreach ($total_prod as $value) {
                $level_procent = Levels::getLevelPercent(
                    $value,
                    $customer
                );
                if ($level_procent['return'] > 0) {
                    $total_price += ($value['total_wt'] * $level_procent['return']) / 100;
                }
            }
            if ($cart_cart_rule) {
                $cart_rule = new CartRule((int)$id_cart_rule);
                $procent = ($cart_rule->reduction_amount * 100) / self::getTotalcart();
                return $total_price - ($total_price * $procent / 100);
            } else {
                return $total_price;
            }
        } else {
            return false;
        }
    }

    public static function getProductsPriceCart($id_cart)
    {
        $sql = new DbQuery();
        $sql->select('p.`id_manufacturer`, cp.`id_product_attribute`, cp.`id_product`, cp.`id_customization`, cp.`quantity` AS cart_quantity, cp.id_shop, product_shop.`id_category_default`');
        $sql->from('cart_product', 'cp');
        $sql->leftJoin('product', 'p', 'p.`id_product` = cp.`id_product`');
        $sql->innerJoin('product_shop', 'product_shop', '(product_shop.`id_shop` = cp.`id_shop` AND product_shop.`id_product` = p.`id_product`)');
        $sql->join(Product::sqlStock('cp', 'cp'));
        $sql->where('cp.`id_cart` = ' . (int) $id_cart);
        $sql->where('p.`id_product` IS NOT NULL');
        $result = Db::getInstance()->executeS($sql);
        foreach ($result as $key => $value) {
            $combination_specific_price = null;
            $result[$key]['total_wt'] = self::getPriceStaticBonus(
                (int)$value['id_product'],
                (bool)Configuration::get('PS_LOYALTY_TYPE_TAX'),
                (int)$value['id_product_attribute'],
                6,
                null,
                false,
                true,
                1,
                null,
                null,
                null,
                $combination_specific_price,
                true,
                true,
                null,
                true,
                (int)$value['id_customization']
            ) * (int)$value['cart_quantity'];
        }
        return $result;
    }

    public static function getPriceStaticBonus(
        $id_product,
        $usetax = true,
        $id_product_attribute = null,
        $decimals = 6,
        $divisor = null,
        $only_reduc = false,
        $usereduc = true,
        $quantity = 1,
        $id_customer = null,
        $id_cart = null,
        $id_address = null,
        &$specific_price_output = null,
        $with_ecotax = true,
        $use_group_reduction = true,
        Context $context = null,
        $use_customer_price = true,
        $id_customization = null
    ) {
        if (!$context) {
            $context = Context::getContext();
        }
        $cur_cart = $context->cart;
        if ($divisor !== null) {
            Tools::displayParameterAsDeprecated('divisor');
        }
        if (!Validate::isBool($usetax) || !Validate::isUnsignedId($id_product)) {
            die(Tools::displayError());
        }
        $id_group = null;
        if ($id_customer) {
            $id_group = Customer::getDefaultGroupId((int) $id_customer);
        }

        if (!$id_group) {
            $id_group = (int) Group::getCurrent()->id;
        }
        if (!is_object($cur_cart) || (Validate::isUnsignedInt($id_cart) && $id_cart && $cur_cart->id != $id_cart)) {
            if (!$id_cart && !isset($context->employee)) {
                die(Tools::displayError());
            }
            $cur_cart = new Cart($id_cart);
            if (!Validate::isLoadedObject($context->cart)) {
                $context->cart = $cur_cart;
            }
        }
        $cart_quantity = 0;
        if ((int) $id_cart) {
            $cache_id = 'Product::getPriceStatic_' . (int) $id_product . '-' . (int) $id_cart;
            if (!Cache::isStored($cache_id) || ($cart_quantity = Cache::retrieve($cache_id) != (int) $quantity)) {
                $sql = 'SELECT SUM(`quantity`)
                FROM `' . _DB_PREFIX_ . 'cart_product`
                WHERE `id_product` = ' . (int) $id_product . '
                AND `id_cart` = ' . (int) $id_cart;
                $cart_quantity = (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql);
                Cache::store($cache_id, $cart_quantity);
            } else {
                $cart_quantity = Cache::retrieve($cache_id);
            }
        }
        $id_currency = (int) Configuration::get('PS_CURRENCY_DEFAULT');
        if (!$id_address && Validate::isLoadedObject($cur_cart)) {
            $id_address = $cur_cart->{Configuration::get('PS_TAX_ADDRESS_TYPE')};
        }
        $address = Address::initialize($id_address, true);
        $id_country = (int) $address->id_country;
        $id_state = (int) $address->id_state;
        $zipcode = $address->postcode;
        if (Tax::excludeTaxeOption()) {
            $usetax = false;
        }
        if ($usetax != false
            && !empty($address->vat_number)
            && $address->id_country != Configuration::get('VATNUMBER_COUNTRY')
            && Configuration::get('VATNUMBER_MANAGEMENT')) {
            $usetax = false;
        }
        if (null === $id_customer && Validate::isLoadedObject($context->customer)) {
            $id_customer = $context->customer->id;
        }
        $return = Product::priceCalculation(
            $context->shop->id,
            $id_product,
            $id_product_attribute,
            $id_country,
            $id_state,
            $zipcode,
            $id_currency,
            $id_group,
            $quantity,
            $usetax,
            $decimals,
            $only_reduc,
            $usereduc,
            $with_ecotax,
            $specific_price_output,
            $use_group_reduction,
            $id_customer,
            $use_customer_price,
            $id_cart,
            $cart_quantity,
            $id_customization
        );
        return $return;
    }

    public static function dsCrypt($input, $decrypt = false)
    {
        $o = $s1 = $s2 = array();
        $basea = array('?', '(', '@', ';', '$', '#', "]", "&", '*');
        $basea = array_merge($basea, range('a', 'z'), range('A', 'Z'), range(0, 9));
        $basea = array_merge($basea, array('!', ')', '_', '+', '|', '%', '/', '[', '.', ' '));
        $dimension = 9;
        for ($i = 0; $i < $dimension; $i++) {
            for ($j = 0; $j < $dimension; $j++) {
                $s1[$i][$j] = $basea[$i * $dimension + $j];
                $s2[$i][$j] = str_rot13($basea[($dimension * $dimension - 1) - ($i * $dimension + $j)]);
            }
        }
        unset($basea);
        $m = floor(Tools::strlen($input) / 2) * 2;
        $symbl = $m == Tools::strlen($input) ? '' : $input[Tools::strlen($input) - 1];
        $al = array();
        for ($ii = 0; $ii < $m; $ii += 2) {
            $symb1 = $symbn1 = (string)$input[$ii];
            $symb2 = $symbn2 = (string)$input[$ii + 1];
            $a1 = $a2 = array();
            for ($i = 0; $i < $dimension; $i++) {
                for ($j = 0; $j < $dimension; $j++) {
                    if ($decrypt) {
                        if ($symb1 === (string)$s2[$i][$j]) {
                            $a1 = array($i, $j);
                        }
                        if ($symb2 === (string)$s1[$i][$j]) {
                            $a2 = array($i, $j);
                        }
                        if (!empty($symbl) && $symbl === (string)$s2[$i][$j]) {
                            $al = array($i, $j);
                        }
                    } else {
                        if ($symb1 === (string)$s1[$i][$j]) {
                            $a1 = array($i, $j);
                        }
                        if ($symb2 === (string)$s2[$i][$j]) {
                            $a2 = array($i, $j);
                        }
                        if (!empty($symbl) && $symbl === (string)$s1[$i][$j]) {
                            $al = array($i, $j);
                        }
                    }
                }
            }
            if (sizeof($a1) && sizeof($a2)) {
                $symbn1 = $decrypt ? $s1[$a1[0]][$a2[1]] : $s2[$a1[0]][$a2[1]];
                $symbn2 = $decrypt ? $s2[$a2[0]][$a1[1]] : $s1[$a2[0]][$a1[1]];
            }
            $o[] = $symbn1.$symbn2;
        }
        if (!empty($symbl) && sizeof($al)) {
            $o[] = $decrypt ? $s1[$al[1]][$al[0]] : $s2[$al[1]][$al[0]];
        }
        return implode('', $o);
    }

    public static function andomNumber($length)
    {
        $characters = "0123456789";
        $strlength = Tools::strlen($characters);
        $random = '';
        for ($i = 0; $i < $length; $i++) {
            $random .= $characters[rand(0, $strlength - 1)];
        }
        return $random;
    }

    public static function reductionAmount()
    {
        $context = Context::getContext();
        $hash = Tools::hash((int)$context->customer->id);
        $cart_rule = Db::getInstance()->getRow('
            SELECT id_cart_rule, reduction_amount
            FROM '._DB_PREFIX_.'cart_rule
            WHERE id_customer = '.(int)$context->customer->id.'
            AND code = \''.pSQL($hash).'\'');

        if ($cart_rule) {
            $cart_cart_rule = Db::getInstance()->getValue('
                SELECT id_cart_rule
                FROM '._DB_PREFIX_.'cart_cart_rule
                WHERE id_cart = '.(int)$context->cookie->id_cart.' 
                AND id_cart_rule = '.(int)$cart_rule['id_cart_rule']);

            if ($cart_cart_rule) {
                return $cart_rule['reduction_amount'];
            }
        }
        return false;
    }

    public static function hash16($string)
    {
        return md5(_COOKIE_KEY_ . $string);
    }

    public static function ballAmount()
    {
        $context = Context::getContext();
        $total_cart = ToolsBonus::getTotalcart();
        if ($context->customer->isLogged()) {
            $offs_ball = ($total_cart * (int)Configuration::get('PS_CASHBACK')) / 100;
            $bonus_user = BonusaccountObj::getPointsByCustomer(
                (int)$context->customer->id
            );

            return $offs_ball <= $bonus_user ? $offs_ball : $bonus_user;
        }
        return false;
    }

    public static function resetCartRule()
    {
        $context = Context::getContext();
        $hash = Tools::hash((int)$context->customer->id);
        $id_cart_rule = Db::getInstance()->getValue('
            SELECT id_cart_rule
            FROM '._DB_PREFIX_.'cart_rule
            WHERE id_customer = '.(int)$context->customer->id.'
            AND code = \'' . pSQL($hash) . '\'');
        $total_cart = self::getTotalcart();
        $ball_amount = Tools::ps_round(
            self::ballAmount(),
            self::getComputingPrecision()
        );
        $reduction_amount = self::reductionAmount();
        $bonus_user = BonusaccountObj::getPointsByCustomer(
            (int)$context->customer->id
        );
        if ($total_cart == 0 || $reduction_amount > $ball_amount || $bonus_user == 0) {

            $cart_cart_rule = Db::getInstance()->getRow('
            SELECT *
            FROM '._DB_PREFIX_.'cart_cart_rule
            WHERE id_cart = '.(int)$context->cart->id.' 
            AND id_cart_rule = '.(int)$id_cart_rule);
            if ($cart_cart_rule) {
                $sql = 'DELETE FROM '._DB_PREFIX_.'cart_cart_rule 
                WHERE id_cart = '.(int)$context->cart->id.' 
                AND id_cart_rule = '.(int)$id_cart_rule;
                Db::getInstance()->execute($sql);
            }
        }
    }

    public static function deleteCartBonus()
    {
        $context = Context::getContext();
        $hash = Tools::hash((int)$context->customer->id);
        $id_cart_rule = Db::getInstance()->getValue('
            SELECT id_cart_rule
            FROM '._DB_PREFIX_.'cart_rule
            WHERE id_customer = '.(int)$context->customer->id.'
            AND code = \'' . pSQL($hash) . '\'');
        $sql = 'DELETE FROM '._DB_PREFIX_.'cart_cart_rule 
            WHERE id_cart = '.(int)$context->cookie->id_cart.' 
            AND id_cart_rule = '.(int)$id_cart_rule;
        Db::getInstance()->execute($sql);
    }

    public static function getComputingPrecision()
    {
        if (version_compare(_PS_VERSION_, '1.7.7.6', '>=')) {
            return Context::getContext()->getComputingPrecision();
        } else {
            return _PS_PRICE_COMPUTE_PRECISION_;
        }
    }
}
