<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/Accrual.php');
class AdminPsbonusSystemAccrualController extends ModuleAdminController
{
    public $active = true;
    public $title;
    protected $_category = null;
    public function __construct()
    {
        $this->bootstrap  = true;
        $this->table      = 'bonus_accrual';
        $this->list_id    = 'id_accrual';
        $this->identifier = 'id_accrual';
        parent::__construct();
        $this->className  = 'Accrual';
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->allow_export    = true;
        $this->allow_add       = false;
        $this->context         = Context::getContext();
        $this->_orderBy        = 'id_accrual';
        $this->_orderWay       = 'DESC';
        $this->toolbar_title   = $this->title;
        $this->_use_found_rows = true;
        $this->fields_list     = array(
            'id_accrual' => array(
                'title' => $this->trans('ID', [], 'Modules.Psbonussystem.Admin'),
                'search' => false
            ),
            'id_object' => array(
                'title' => $this->trans('Id Object', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setObjectName',
            ),
            'type' => array(
                'title' => $this->trans('Type', [], 'Modules.Psbonussystem.Admin'),
            ),
            'increased' => array(
                'title' => $this->trans('Return percentage', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'align' => 'text-right',
                'callback' => 'setIncreased',
            )
        );
    }

    public static function setIncreased($increased)
    {
        return (float)$increased.' %';
    }

    public static function setObjectName($id_object, $row)
    {
        $name = '';
        if ($row['type'] == 'product') {
            $object = new Product((int)$id_object, false, Context::getContext()->language->id);
            $name = $object->name;
        }

        if ($row['type'] == 'category') {
            $object = new Category((int)$id_object, Context::getContext()->language->id);
            $name = $object->name;
        }

        if ($row['type'] == 'brand') {
            $object = new Manufacturer((int)$id_object);
            $name = $object->name;
        }

        if ($name) {
            return $id_object.' | '.$name;
        } else {
            return '-';
        }
    }

    public function renderForm()
    {
        $fields = array(
            'query' => array(
                array('id' => 'product', 'name' => $this->trans('Product', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 'brand', 'name' => $this->trans('Brand', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 'category', 'name' => $this->trans('Category', [], 'Modules.Psbonussystem.Admin'))
            ),
            'id' => 'id',
            'name' => 'name',
        );
        $this->fields_form = array(
            'tinymce' => true,
            'legend' => array(
                'title' => $this->trans('Add', [], 'Modules.Psbonussystem.Admin')
            ),
            'input' => array(
                array(
                    'type' => 'select',
                    'label' => $this->trans('Type Object', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'type',
                    'options' => $fields,
                    'required' => true,
                ),
                array(
                    'type' => 'products_autocomplete',
                    'label' => $this->trans(
                        'Search Product',
                        array(),
                        'Modules.Psbonussystem.Admin'
                    ),
                    'name' => 'id_object',
                    'ajax_path' => self::$currentIndex.'&ajax=1&type=product&action=objectListProducts&token='.Tools::getAdminTokenLite('AdminPsbonusSystemAccrual'),
                    'form_group_class' => 'block_type_object block_type_product',
                ),
                array(
                    'type' => 'brands_autocomplete',
                    'label' => $this->trans(
                        'Search Brand',
                        array(),
                        'Modules.Psbonussystem.Admin'
                    ),
                    'name' => 'id_object',
                    'ajax_path' => self::$currentIndex.'&ajax=1&type=brand&action=objectListBrands&token='.Tools::getAdminTokenLite('AdminPsbonusSystemAccrual'),
                    'form_group_class' => 'block_type_object block_type_brand',
                ),
                array(
                    'type' => 'category_autocomplete',
                    'label' => $this->trans(
                        'Search Category',
                        array(),
                        'Modules.Psbonussystem.Admin'
                    ),
                    'name' => 'id_object',
                    'ajax_path' => self::$currentIndex.'&ajax=1&type=category&action=objectListCategories&token='.Tools::getAdminTokenLite('AdminPsbonusSystemAccrual'),
                    'form_group_class' => 'block_type_object block_type_category',
                ),
                array(
                    'type' => 'id_object',
                    'name' => 'id_object',
                    'label' => ''
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Return percentage', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'increased',
                    'class' => 'fixed-width-sm',
                    'suffix' => '%',
                    'required' => true,
                    'desc' => $this->trans('Returned percentage for the order', [], 'Modules.Psbonussystem.Admin'),
                )
            ),
            'submit' => array(
                'title' => $this->trans('Save', [], 'Modules.Psbonussystem.Admin'),
                'class' => 'btn btn-default pull-right'
            )
        );

        return parent::renderForm();
    }

    protected function ajaxProcessObjectListCategories()
    {
        $query = Tools::getValue('q', false);
        if (!$query || $query == '' || Tools::strlen($query) < 1) {
            die();
        }

        $sql = 'SELECT c.`id_category`, cl.`name`
            FROM `'._DB_PREFIX_.'category` c
            LEFT JOIN `'._DB_PREFIX_.'category_lang` cl
                ON (cl.id_category = c.id_category
                AND cl.id_lang = '.(int) Context::getContext()->language->id.Shop::addSqlRestrictionOnLang('cl').')
            WHERE (cl.name LIKE \'%'.pSQL($query).'%\'
                OR c.id_category = '.(int) $query.')
            GROUP BY c.`id_category`';

        $items = Db::getInstance()->executeS($sql);

        if ($items) {
            foreach ($items as $item) {
                $item['name'] = str_replace('|', '-', $item['name']);
                echo trim($item['name']).'|'.(int) $item['id_category']."\n";
            }
        } else {
            json_encode(new stdClass());
        }
    }

    protected function ajaxProcessObjectListBrands()
    {
        $query = Tools::getValue('q', false);
        if (!$query || $query == '' || Tools::strlen($query) < 1) {
            die();
        }

        $sql = 'SELECT m.`id_manufacturer`,  m.`name`
            FROM `'._DB_PREFIX_.'manufacturer` m
            WHERE (m.name LIKE \'%'.pSQL($query).'%\'
                OR m.id_manufacturer = '.(int) $query.')
            GROUP BY m.`id_manufacturer`';

        $items = Db::getInstance()->executeS($sql);

        if ($items) {
            foreach ($items as $item) {
                $item['name'] = str_replace('|', '-', $item['name']);
                echo trim($item['name']).'|'.(int) $item['id_manufacturer']."\n";
            }
        } else {
            json_encode(new stdClass());
        }
    }

    protected function ajaxProcessObjectListProducts()
    {
        $query = Tools::getValue('q', false);
        if (!$query || $query == '' || Tools::strlen($query) < 1) {
            die();
        }

        $sql = 'SELECT p.`id_product`, pl.`name`
            FROM `'._DB_PREFIX_.'product` p
            LEFT JOIN `'._DB_PREFIX_.'product_lang` pl
                ON (pl.id_product = p.id_product
                AND pl.id_lang = '.(int) Context::getContext()->language->id.Shop::addSqlRestrictionOnLang('pl').')
            WHERE (pl.name LIKE \'%'.pSQL($query).'%\'
                OR p.reference LIKE \'%'.pSQL($query).'%\'
                OR p.id_product = '.(int) $query.')
            GROUP BY p.`id_product`';

        $items = Db::getInstance()->executeS($sql);

        if ($items) {
            foreach ($items as $item) {
                $item['name'] = str_replace('|', '-', $item['name']);
                echo trim($item['name']).'|'.(int) $item['id_product']."\n";
            }
        } else {
            json_encode(new stdClass());
        }
    }

    public function renderKpis()
    {
        return $this->context->smarty->fetch(
            _PS_MODULE_DIR_.'psbonussystem/views/templates/admin/info_accrual.tpl'
        );
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_banner'] = array(
                'href' => self::$currentIndex.'&addbonus_accrual&token='.$this->token,
                'desc' => $this->trans('Add new', [], 'Modules.Psbonussystem.Admin'),
                'icon' => 'process-icon-new'
            );
        }
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJqueryPlugin(array('autocomplete', 'typewatch', 'highlight'));
    }
}
