<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/Actions.php');
class AdminPsbonusSystemActionsController extends ModuleAdminController
{
    public $active = true;
    public $title;
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = false;
        $this->table = 'bonus_actions';
        $this->list_id = 'id_bonusactions';
        $this->identifier = 'id_bonusactions';
        parent::__construct();
        $this->className = 'Actions';
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->allow_export = true;
        $this->allow_add = false;
        $this->context = Context::getContext();
        $this->_orderBy = 'id_bonusactions';
        $this->_orderWay = 'DESC';
        $this->toolbar_title = $this->title;
        $this->_use_found_rows = true;
        $this->fields_list = array(
            'id_bonusactions' => array(
                'title' => $this->trans('ID', [], 'Modules.Psbonussystem.Admin'),
                'search' => false
            ),
            'type' => array(
                'title' => $this->trans('Type action', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setType',
            ),
            'point' => array(
                'title' => $this->trans('Value', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'align' => 'text-right',
                'type' => 'price',
                'currency' => true,
                'callback' => 'setCurrency',
            ),
            'status' => array(
                'title' => $this->trans('Status', [], 'Modules.Psbonussystem.Admin'),
                'active' => 'status',
                'type' => 'bool',
                'class' => 'fixed-width-xs',
                'align' => 'center',
                'ajax' => true,
                'orderby' => false,
                'search' => false,
            ),
            'many_days' => array(
                'title' => $this->trans('The duration of the bonuses', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setManyDays',
            ),
            'date_from' => array(
                'title' => $this->trans('Start date', [], 'Modules.Psbonussystem.Admin'),
                'type' => 'datetime',
                'class' => 'fixed-width-lg',
                'search' => false,
            ),
            'date_to' => array(
                'title' => $this->trans('End date', [], 'Modules.Psbonussystem.Admin'),
                'type' => 'datetime',
                'class' => 'fixed-width-lg',
                'search' => false,
            ),
        );
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->context->controller->addJquery();
        $this->context->controller->addJS(_MODULE_DIR_.$this->module->name.'/views/js/actions.js');
        $this->context->controller->addCSS(_MODULE_DIR_.$this->module->name.'/views/css/actions.css');
    }

    public static function setCurrency($point, $data)
    {
        if ($data['type'] == 'friend') {
            $price_one = Tools::displayPrice($point, (int)Configuration::get('PS_CURRENCY_DEFAULT'));
            $price_two = Tools::displayPrice($data['point_self'], (int)Configuration::get('PS_CURRENCY_DEFAULT'));
            return  $price_one.' / '. $price_two;
        } else {
            return Tools::displayPrice($point, (int)Configuration::get('PS_CURRENCY_DEFAULT'));
        }
    }

    public static function setType($type)
    {
        if ($type == 'registration') {
            return Context::getContext()->getTranslator()->trans('Registration bonus', [], 'Modules.Psbonussystem.Admin');
        } elseif ($type == 'newsletter') {
            return Context::getContext()->getTranslator()->trans('Subscribe to newsletter', [], 'Modules.Psbonussystem.Admin');
        } elseif ($type == 'friend') {
            return Context::getContext()->getTranslator()->trans('Bonus for inviting a friend', [], 'Modules.Psbonussystem.Admin');
        } elseif ($type == 'birthday') {
            return Context::getContext()->getTranslator()->trans('Bonus on your birthday', [], 'Modules.Psbonussystem.Admin');
        } elseif ($type == 'first_order') {
            return Context::getContext()->getTranslator()->trans('First order bonus', [], 'Modules.Psbonussystem.Admin');
        }
    }

    public static function setManyDays($many_days)
    {
        return $many_days.' '.Context::getContext()->getTranslator()->trans('Day(s)', [], 'Modules.Psbonussystem.Admin');
    }

    public function renderForm()
    {
        $fields = array(
            'query' => array(
                array('id' => 'registration', 'name' => $this->trans('Registration bonus', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 'newsletter', 'name' => $this->trans('Subscribe to newsletter', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 'friend', 'name' => $this->trans('Bonus for inviting a friend', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 'birthday', 'name' => $this->trans('Bonus on your birthday', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 'first_order', 'name' => $this->trans('First order bonus', [], 'Modules.Psbonussystem.Admin')),
            ),
            'id' => 'id',
            'name' => 'name',
        );
        $this->fields_form = array(
            'tinymce' => true,
            'legend' => array(
                'title' => $this->trans('Add action', [], 'Modules.Psbonussystem.Admin')
            ),
            'input' => array(
                array(
                    'type' => 'select',
                    'label' => $this->trans('Type action', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'type',
                    'options' => $fields,
                    'required' => true,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Value', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'point',
                    'class' => 'fixed-width-sm',
                    'required' => true,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Bonus for inviting a friend', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'point_self',
                    'class' => 'fixed-width-sm',
                    'form_group_class' => 'point_self',
                    'desc' => $this->trans('Bonus amount to the user who invited the friend', [], 'Modules.Psbonussystem.Admin'),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('How many days are bonuses valid', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'many_days',
                    'class' => 'fixed-width-sm',
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->trans('From', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'date_from',
                    'autocomplete' => 'off',
                    'required' => true
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->trans('To', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'date_to',
                    'required' => true
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->trans('Status', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'status',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'status_on',
                            'value' => true,
                            'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin'),
                        ),
                        array(
                            'id' => 'status_off',
                            'value' => false,
                            'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin'),
                        ),
                    ),
                ),
            ),
            'submit' => array(
                'title' => $this->trans('Save', [], 'Modules.Psbonussystem.Admin'),
                'class' => 'btn btn-default pull-right'
            )
        );


        return parent::renderForm();
    }

    public function renderKpis()
    {
        return $this->context->smarty->fetch(
            _PS_MODULE_DIR_.'psbonussystem/views/templates/admin/info_actions.tpl'
        );
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_banner'] = array(
                'href' => self::$currentIndex.'&addbonus_actions&token='.$this->token,
                'desc' => $this->trans('Add new action', [], 'Modules.Psbonussystem.Admin'),
                'icon' => 'process-icon-new'
            );
        }
    }
}
