<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminPsbonusSystemControlController extends ModuleAdminController
{
    public $active = true;
    public $title;
    public function __construct()
    {
        $this->bootstrap  = true;
        $this->table      = 'bonus_account';
        $this->identifier = 'id_bonusaccount';
        $this->className  = 'BonusaccountObj';
        $this->allow_export    = true;
        $this->addRowAction('edit');

        $this->allow_add       = false;
        parent::__construct();
        $this->context         = Context::getContext();
        $this->_orderBy        = 'id_bonusaccount';
        $this->_orderWay       = 'DESC';
        $this->toolbar_title   = $this->title;
        $this->_use_found_rows = true;
        $this->_select = '
        (CASE
            WHEN a.status = 1 and a.paid = 1 THEN "#32CD32"
            WHEN a.status = 2 and a.paid = 1 THEN "#ec2e15"
            WHEN a.status = 1 and a.paid = 0 THEN "#FF8C00"
            WHEN a.status = 2 and a.paid = 0 THEN "#FF8C00"
            WHEN a.status = 3 THEN "#adadad"
        END) AS color,
        (CASE
            WHEN a.status = 1 and a.paid = 1 THEN "#32CD32"
            WHEN a.status = 2 and a.paid = 1 THEN "#ec2e15"
            WHEN a.status = 1 and a.paid = 0 THEN "#FF8C00"
            WHEN a.status = 2 and a.paid = 0 THEN "#FF8C00"
            WHEN a.status = 3 THEN "#adadad"
        END) AS badge_success';
        $this->fields_list     = array(
            'id_bonusaccount' => array(
                'title' => $this->trans('ID', [], 'Modules.Psbonussystem.Admin'),
                'search' => false
            ),
            'id_customer' => array(
                'title' => $this->trans('Customer', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setCustomer',
            ),
            'id_order' => array(
                'title' => $this->trans('Order', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setOrder',
            ),
            'points' => array(
                'title' => $this->trans('Points', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'type' => 'price',
                'color' => 'color',
                'currency' => true,
                'callback' => 'setPoint'
            ),
            'status' => array(
                'title' => $this->trans('Status', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'color' => 'color',
                'callback' => 'setStatus',
            ),
            'comment' => array(
                'title' => $this->trans('Comment', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
            ),
            'date_add' => array(
                'title' => $this->trans('Date add', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'type' => 'datetime',
            ),
            'date_bonus_to' => array(
                'title' => $this->trans('Valid to', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'type' => 'datetime',
            )
        );
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        Media::addJsDef(array(
            'curent_url_bs' => $this->context->link->getAdminLink('AdminPsbonusSystemControl'),
            'curent_url_customer' => $this->context->link->getAdminLink('AdminCustomers', true, [], ['viewcustomer' => 1, 'liteDisplaying' => 1, 'id_customer' => 0])
        ));

        $this->addJqueryPlugin(array('autocomplete', 'typewatch', 'highlight'));
    }

    public function initToolbar()
    {
        parent::initToolbar();
        unset($this->toolbar_btn['new']);
    }

    public function setCustomer($id_customer)
    {
        $customer = new Customer((int) $id_customer);
        return  $customer->firstname . ' ' . $customer->lastname . ' | #'.$id_customer;
    }

    public function setOrder($id_order)
    {
        if ((int)$id_order > 0) {
            $order = new Order((int)$id_order);
            return $order->reference. ' | #'.$id_order;
        }
    }

    public function setPoint($echo, $tr)
    {
        if ($tr['status'] == 1) {
            return '+'. Tools::displayPrice($echo, (int)Configuration::get('PS_CURRENCY_DEFAULT')) . '';
        }
        if ($tr['status'] == 2) {
            return '-'. Tools::displayPrice($echo, (int)Configuration::get('PS_CURRENCY_DEFAULT')) . '';
        }
        if ($tr['status'] == 3) {
            return ''. Tools::displayPrice($echo, (int)Configuration::get('PS_CURRENCY_DEFAULT')) . '';
        }
    }

    public function setStatus($echo, $tr)
    {
        //Начислен 1 статус
        if ($echo == 1 && $tr['paid'] == 1) {
            return $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin');
        }
        //Списанно 2 статус
        if ($echo == 2 && $tr['paid'] == 1) {
            return  $this->trans('Written off', [], 'Modules.Psbonussystem.Admin');
        }
        //На проверке
        if ($echo == 1 && $tr['paid'] == 0) {
            return $this->trans('Validate', [], 'Modules.Psbonussystem.Admin');
        }

        //На проверке
        if ($echo == 2 && $tr['paid'] == 0) {
            return $this->trans('Validate', [], 'Modules.Psbonussystem.Admin');
        }
        //Отменено
        if ($echo == 3) {
            return  $this->trans('Cancelled', [], 'Modules.Psbonussystem.Admin');
        }
    }

    public function renderForm()
    {
        $fields = array(
            'query' => array(
                array('id' => 1, 'name' => $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 2, 'name' => $this->trans('Written off', [], 'Modules.Psbonussystem.Admin')),
                array('id' => 3, 'name' => $this->trans('Cancelled', [], 'Modules.Psbonussystem.Admin')),
            ),
            'id' => 'id',
            'name' => 'name',
        );

        $this->fields_form = array(
            'tinymce' => true,
            'input' => array(
                array(
                    'type' => 'select',
                    'label' => $this->trans('Status', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'status',
                    'options' => $fields,
                    'required' => true,
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->trans('Paid', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'paid',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'status_on',
                            'value' => true,
                            'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin'),
                        ),
                        array(
                            'id' => 'status_off',
                            'value' => false,
                            'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin'),
                        ),
                    ),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Transition amount', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'points',
                    'class' => 'fixed-width-sm',
                    'suffix' => '¤',
                    'required' => true,
                ),
                array(
                    'type' => 'textarea',
                    'label' => $this->trans('Comment', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'comment',
                    'required' => true,
                ),
            ),
            'submit' => array(
                'title' => $this->trans('Save', [], 'Modules.Psbonussystem.Admin'),
                'class' => 'btn btn-default pull-right'
            )
        );


        return parent::renderForm();
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_bonus'] = array(
                'href' => '#',
                'desc' => $this->trans('Accrue bonuses', [], 'Modules.Psbonussystem.Admin'),
                'icon' => 'process-icon-new',
                'class' => 'asas'
            );
        }
    }

    public function initFooter()
    {
        parent::initFooter();

        $this->tpl_view_vars = array(
            'customersSearchUrl' => $this->context->link->getAdminLink('AdminPsbonusSystemControl'),
            'select_order' => $this->trans('Select order', [], 'Modules.Psbonussystem.Admin'),
            'accrual_amount' => $this->trans('Accrual amount', [], 'Modules.Psbonussystem.Admin'),
            'bonuses_valid' => $this->trans('How many days are bonuses valid', [], 'Modules.Psbonussystem.Admin'),
            'accrue_bonuses' => $this->trans('Accrue bonuses', [], 'Modules.Psbonussystem.Admin'),
            'without_order' => $this->trans('Without order (accrue bonus not on order)', [], 'Modules.Psbonussystem.Admin'),
            'comment' => $this->trans('Comment', [], 'Modules.Psbonussystem.Admin'),
        );
        $this->modals[] = array(
            'modal_id' => 'modal-bonuses',
            'modal_class' => 'modal-md',
            'modal_title' => $this->trans('Accrue bonuses', [], 'Modules.Psbonussystem.Admin'),
            'modal_content' => $this->context->smarty->fetch(
                _PS_MODULE_DIR_ . 'psbonussystem/views/templates/admin/modal.tpl',
                $this->tpl_view_vars
            )
        );
        $this->context->smarty->assign(array(
            'modals' => $this->renderModal(),
        ));
    }

    public function renderModal()
    {
        $modal_render = '';
        if (is_array($this->modals) && count($this->modals)) {
            foreach ($this->modals as $modal) {
                $this->context->smarty->assign($modal);
                $modal_render .= $this->context->smarty->fetch('modal.tpl');
            }
        }

        return $modal_render;
    }

    public function ajaxProcessSaveBonus()
    {
        $customer = new Customer((int)Tools::getValue('id_customer'));
        if (!is_numeric(Tools::getValue('points')) || !is_numeric(Tools::getValue('many_days'))) {
            die(json_encode(array(
                'result' => false,
                'error' => $this->trans('Check the entered data', [], 'Modules.Psbonussystem.Admin'),
            )));
        }
        if (Validate::isLoadedObject($customer)) {
            $cuctomer = new Customer((int)Tools::getValue('id_customer'));
            $date = new DateTime();
            $date->add(new DateInterval('P'.(int)Tools::getValue('many_days').'D'));
            $bonus = new BonusaccountObj();
            $bonus->id_customer = (int)Tools::getValue('id_customer');
            $bonus->id_order = (int)Tools::getValue('id_order');
            $bonus->id_cart_rule = (int)Tools::getValue('id_cart_rule');
            $bonus->points = pSQL(Tools::getValue('points'));
            $bonus->comment = pSQL(Tools::getValue('comment'));
            $bonus->paid = (int)1;
            $bonus->status = (int)1;
            $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
            $bonus->type = (int)Tools::getValue('id_order') == 0 ? 'no_order' : 'order';
            if ($bonus->save()) {
                if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                    $info_bonus = '';
                    $info_bonus .= '<span style="color:#333"><strong>'.$this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').'</strong></span> '.Tools::getValue('comment').' <br /><br />';
                    $info_bonus .= '<span style="color:#333"><strong>'.$this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').'</strong></span> '.Tools::displayPrice(
                        Tools::getValue('points'),
                        (int)Configuration::get('PS_CURRENCY_DEFAULT')
                    ).' <br /><br />';
                    $info_bonus .= '<span style="color:#333"><strong>'.$this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').'</strong></span> '.$date->format('Y-m-d H:i:s').' <br /><br />';
                    $this->emailSend($info_bonus, $cuctomer);
                }
                die(json_encode(array(
                    'result' => true,
                    'message' => $this->trans('Bonuses have been successfully added', [], 'Modules.Psbonussystem.Admin'),
                )));
            } else {
                die(json_encode(array(
                    'result' => false,
                    'error' => $this->trans('Add error, please try later', [], 'Modules.Psbonussystem.Admin'),
                )));
            }
        } else {
            die(json_encode(array(
                'result' => false,
                'error' => $this->trans('Add error, please try later', [], 'Modules.Psbonussystem.Admin'),
            )));
        }
    }

    public function ajaxProcessSearchOrders()
    {
        $id_customer = Tools::getValue('id_customer');

        die(json_encode(array(
            'id_cart_rule' => $this->getCustomerCartRulesById(
                (int)$id_customer
            ),
            'orders' => Order::getCustomerOrders((int)$id_customer),
        )));
    }

    public function getCustomerCartRulesById($id_customer)
    {
        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            $hash = Tools::hash((int)$id_customer);
        } else {
            $hash = ToolsBonus::hash16((int)$id_customer);
        }
        $cart_rule = Db::getInstance()->getValue('
            SELECT id_cart_rule
            FROM '._DB_PREFIX_.'cart_rule
            WHERE id_customer = '.(int)$id_customer.'
            AND code = \'' . pSQL($hash) . '\'');
        return $cart_rule;
    }

    public function renderKpis()
    {
        $kpis = array();

        /* The data generation is located in AdminStatsControllerCore */

        $helper = new HelperKpi();
        $helper->id = 'box-cart';
        $helper->icon = 'icon-money';
        $helper->color = 'color4';
        $helper->title = $this->trans('Total bonuses issued', [], 'Modules.Psbonussystem.Admin');
        $helper->source = $this->context->link->getAdminLink('AdminPsbonusSystemControl').'&ajax=1&action=getKpi&kpi=total_bonus';
        $kpis[] = $helper->generate();

        $helper = new HelperKpi();
        $helper->id = 'box-product';
        $helper->icon = 'icon-shopping-cart';
        $helper->color = 'color3';
        $helper->title = $this->trans('Total of bonuses for orders', [], 'Modules.Psbonussystem.Admin');
        $helper->source = $this->context->link->getAdminLink('AdminPsbonusSystemControl') . '&ajax=1&action=getKpi&kpi=total_order';
        $kpis[] = $helper->generate();

        $helper = new HelperKpi();
        $helper->id = 'box-registered';
        $helper->icon = 'icon-check-square';
        $helper->color = 'color1';
        $helper->title = $this->trans('Other bonus accruals', [], 'Modules.Psbonussystem.Admin');
        $helper->source = $this->context->link->getAdminLink('AdminPsbonusSystemControl') . '&ajax=1&action=getKpi&kpi=other_bonus';
        $kpis[] = $helper->generate();

        $helper = new HelperKpi();
        $helper->id = 'box-guest';
        $helper->icon = 'icon-minus-circle';
        $helper->color = 'color2';
        $helper->title = $this->trans('Total bonuses written off', [], 'Modules.Psbonussystem.Admin');
        $helper->source = $this->context->link->getAdminLink('AdminPsbonusSystemControl') . '&ajax=1&action=getKpi&kpi=bonuses_written';
        $kpis[] = $helper->generate();

        $helper = new HelperKpiRow();
        $helper->kpis = $kpis;

        return $helper->generate();
    }

    public function displayAjaxGetKpi()
    {
        $result = '';
        switch (Tools::getValue('kpi')) {
            case 'total_bonus':
                $count = Db::getInstance()->getValue('
                    SELECT SUM(points)
                    FROM '._DB_PREFIX_.'bonus_account 
                    WHERE paid = 1
                    AND status = 1');
                $result = array('value' => Tools::displayPrice($count ? $count : 0, (int)Configuration::get('PS_CURRENCY_DEFAULT'))
                );

                break;
            case 'total_order':
                $count = Db::getInstance()->getValue('
                    SELECT SUM(points)
                    FROM '._DB_PREFIX_.'bonus_account 
                    WHERE type = "order"
                    AND paid = 1
                    AND status = 1');
                $result = array('value' => Tools::displayPrice($count ? $count : 0, (int)Configuration::get('PS_CURRENCY_DEFAULT'))
                );

                break;
            case 'other_bonus':
                $count = Db::getInstance()->getValue('
                    SELECT SUM(points)
                    FROM '._DB_PREFIX_.'bonus_account 
                    WHERE type NOT IN ("order")
                    AND paid = 1
                    AND status = 1');
                $result = array('value' => Tools::displayPrice($count ? $count : 0, (int)Configuration::get('PS_CURRENCY_DEFAULT'))
                );

                break;
            case 'bonuses_written':
                $count = Db::getInstance()->getValue('
                    SELECT SUM(points)
                    FROM '._DB_PREFIX_.'bonus_account 
                    WHERE paid = 1
                    AND status = 2');
                $result = array('value' => Tools::displayPrice($count ? $count : 0, (int)Configuration::get('PS_CURRENCY_DEFAULT'))
                );

                break;

            default:
                $result = array('value' => false);
        }
        die(json_encode($result));
    }

    public function ajaxProcessSearchCustomers()
    {
        $searches = explode(' ', Tools::getValue('customer_search'));
        $customers = array();
        $searches = array_unique($searches);
        foreach ($searches as $search) {
            if (!empty($search) && $results = Customer::searchByName($search, 50)) {
                foreach ($results as $result) {
                    if ($result['active']) {
                        $customers[$result['id_customer']] = $result;
                    }
                }
            }
        }

        if (count($customers)) {
            $to_return = array(
                'customers' => $customers,
                'found' => true
            );
        } else {
            $to_return = array('found' => false);
        }

        $this->content = json_encode($to_return);
    }

    public function emailSend($info_bonus, $user)
    {
        Mail::Send(
            $this->context->language->id,
            'psbonussystem_mail',
            Mail::l('Bonus system', $this->context->language->id),
            array(
                '{info_bonus}' => $info_bonus,
                '{info_bonus_title}' => $user->firstname .' '. $user->lastname.' '. $this->trans('you have received bonuses', [], 'Modules.Psbonussystem.Admin'),
            ),
            $user->email,
            null,
            null,
            null,
            null,
            null,
            dirname(__FILE__).'/mails/',
            null,
            (int)$this->context->shop->id
        );
    }
}
