<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/Actions.php');
class AdminPsbonusSystemIncreasedController extends ModuleAdminController
{
    public $active = true;
    public $title;
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = false;
        $this->table = 'bonus_increased';
        $this->list_id = 'id_increased';
        $this->identifier = 'id_increased';
        parent::__construct();
        $this->className = 'Increased';
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->allow_export = true;
        $this->allow_add = false;
        $this->context = Context::getContext();
        $this->_orderBy = 'id_increased';
        $this->_orderWay = 'DESC';
        $this->toolbar_title = $this->title;
        $this->_use_found_rows = true;
        $this->fields_list = array(
            'id_increased' => array(
                'title' => $this->trans('ID', [], 'Modules.Psbonussystem.Admin'),
                'search' => false
            ),
            'increased' => array(
                'title' => $this->trans('Return Cash Back', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setIncreased'
            ),
            'id_product' => array(
                'title' => $this->trans('Product', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setProduct',
            ),
            'id_category' => array(
                'title' => $this->trans('Category', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'callback' => 'setCategory',
            ),
            'status' => array(
                'title' => $this->trans('Status', [], 'Modules.Psbonussystem.Admin'),
                'active' => 'status',
                'type' => 'bool',
                'class' => 'fixed-width-xs',
                'align' => 'center',
                'ajax' => true,
                'orderby' => false,
                'search' => false,
            ),
            'date_from' => array(
                'title' => $this->trans('Start date', [], 'Modules.Psbonussystem.Admin'),
                'type' => 'datetime',
                'class' => 'fixed-width-lg',
                'search' => false,
            ),
            'date_to' => array(
                'title' => $this->trans('End date', [], 'Modules.Psbonussystem.Admin'),
                'type' => 'datetime',
                'class' => 'fixed-width-lg',
                'search' => false,
            ),
        );
    }

    public static function setIncreased($increased)
    {
        return '+ '.(float)$increased.' %';
    }

    public function setProduct($id)
    {
        if ((int)$id != 0) {
            $categor = new Product((int)$id);
            return '#'.$id.' | '.$categor->name[Configuration::get('PS_LANG_DEFAULT')];
        } else {
            return '-';
        }
    }

    public function setCategory($id)
    {
        if ((int)$id != 0) {
            $categor = new Category((int)$id);
            return '#'.$id.' | '.$categor->name[Configuration::get('PS_LANG_DEFAULT')];
        } else {
            return '-';
        }
    }

    public function renderForm()
    {
        if (!$this->loadObject(true)) {
            return;
        }

        $obj = $this->loadObject(true);

        $selected_categories = array();
        if (Tools::getIsset('updatebonus_increased') && !Tools::getValue('updatebonus_increased')) {
            $link = Increased::getTemplateLang((int)Tools::getValue('id_increased'));
            $selected_categories = array('0' => $link );
        }
        $active_product = array();
        if (Validate::isLoadedObject($obj)) {
            $active_product = Increased::getActiveProduct($obj->id_product);
        }


        $this->fields_form = array(
            'tinymce' => true,
            'legend' => array(
                'title' => $this->trans('Add promo', [], 'Modules.Psbonussystem.Admin')
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->trans('Value', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'increased',
                    'class' => 'fixed-width-sm',
                    'required' => true,
                ),
                array(
                    'type' => 'product_autocomplete',
                    'label' => $this->trans('Select the Product', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'id_product',
                    'active_product' => $active_product,
                    'form_group_class' => 'block_type_product filter_selected_products',
                    'ajax_path' => $this->context->link->getAdminLink('AdminPsbonusSystemIncreased', false).'&ajax=1&action=productsList&token='.Tools::getAdminTokenLite('AdminPsbonusSystemIncreased'),
                    'hint' => $this->trans('Begin typing the First Letters of the Product Name, then select the Product from the Drop-down List.', [], 'Modules.Psbonussystem.Admin'),
                ),
                array(
                    'type'  => 'categories',
                    'label' => $this->trans('Category', [], 'Modules.Psbonussystem.Admin'),
                    'name'  => 'id_category',
                    'required' => false,
                    'desc'    => $this->trans('Show products of the selected category', [], 'Modules.Psbonussystem.Admin'),
                    'tree'  => array(
                        'id' => 'categories-tree',
                        'selected_categories' => $selected_categories,
                    ),
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->trans('From', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'date_from',
                    'autocomplete' => 'off',
                    'required' => true
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->trans('To', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'date_to',
                    'required' => true
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->trans('Status', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'status',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'status_on',
                            'value' => true,
                            'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin'),
                        ),
                        array(
                            'id' => 'status_off',
                            'value' => false,
                            'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin'),
                        ),
                    ),
                ),
            ),
            'submit' => array(
                'title' => $this->trans('Save', [], 'Modules.Psbonussystem.Admin'),
                'class' => 'btn btn-default pull-right'
            )
        );


        return parent::renderForm();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->context->controller->addJquery();
        $this->context->controller->addJs(_PS_JS_DIR_ . 'jquery/plugins/autocomplete/jquery.autocomplete.js');
        $this->context->controller->addCss(_PS_JS_DIR_ . 'jquery/plugins/autocomplete/jquery.autocomplete.css');
    }


    public function displayAjaxProductsList()
    {
        $query = Tools::getValue('q', false);
        if (!$query || $query == '' || Tools::strlen($query) < 1) {
            die();
        }

        $sql = 'SELECT p.`id_product`, pl.`link_rewrite`, p.`reference`, pl.`name`
            FROM `'._DB_PREFIX_.'product` p
            LEFT JOIN `'._DB_PREFIX_.'product_lang` pl
                ON (pl.id_product = p.id_product
                AND pl.id_lang = '.(int) Context::getContext()->language->id.Shop::addSqlRestrictionOnLang('pl').')
            WHERE (pl.name LIKE \'%'.pSQL($query).'%\'
                OR p.reference LIKE \'%'.pSQL($query).'%\'
                OR p.id_product = '.(int) $query.')
            GROUP BY p.`id_product`';

        $items = Db::getInstance()->executeS($sql);

        if ($items) {
            foreach ($items as $item) {
                $item['name'] = str_replace('|', '-', $item['name']);
                echo trim($item['name']).(!empty($item['reference']) ? ' (ref: '.$item['reference'].')' : '').'|'.(int) $item['id_product']."\n";
            }
        } else {
            json_encode(new stdClass());
        }
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_banner'] = array(
                'href' => self::$currentIndex.'&addbonus_increased&token='.$this->token,
                'desc' => $this->trans('Add new promo', [], 'Modules.Psbonussystem.Admin'),
                'icon' => 'process-icon-new'
            );
        }
    }
}
