<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/Levels.php');
class AdminPsbonusSystemLevelsController extends ModuleAdminController
{
    public $active = true;
    public $title;
    protected $_category = null;
    public function __construct()
    {
        $this->bootstrap  = true;
        $this->lang       = true;
        $this->table      = 'bonus_levels';
        $this->list_id    = 'id_bonuslevels';
        $this->identifier = 'id_bonuslevels';
        parent::__construct();
        $this->className  = 'Levels';
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->allow_export    = true;
        $this->allow_add       = false;
        $this->context         = Context::getContext();
        $this->_orderBy        = 'id_bonuslevels';
        $this->_orderWay       = 'DESC';
        $this->toolbar_title   = $this->title;
        $this->_use_found_rows = true;
        $this->fields_list     = array(
            'id_bonuslevels' => array(
                'title' => $this->trans('ID', [], 'Modules.Psbonussystem.Admin'),
                'search' => false
            ),
            'name' => array(
                'title' => $this->trans('Level name', [], 'Modules.Psbonussystem.Admin'),
                'search' => false
            ),
            'return' => array(
                'title' => $this->trans('Return percentage', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'align' => 'text-right',
                'callback' => 'setReturn',
            ),
            'min_range' => array(
                'title' => $this->trans('Min Range', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'align' => 'text-right',
                'type' => 'price',
                'currency' => true,
                'callback' => 'setCurrency',
            ),
            'max_range' => array(
                'title' => $this->trans('Max Range', [], 'Modules.Psbonussystem.Admin'),
                'search' => false,
                'align' => 'text-right',
                'type' => 'price',
                'currency' => true,
                'callback' => 'setCurrency',
            ),
        );
    }

    public static function setCurrency($total_amount)
    {
        return Tools::displayPrice($total_amount, (int)Configuration::get('PS_CURRENCY_DEFAULT'));
    }

    public static function setReturn($return)
    {
        return '+' . $return . ' %';
    }

    public function renderForm()
    {
        $this->fields_form = array(
            'tinymce' => true,
            'legend' => array(
                'title' => $this->trans('Add level', [], 'Modules.Psbonussystem.Admin')
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->trans('Level name', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'name',
                    'lang' => true,
                    'required' => true,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Return percentage', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'return',
                    'class' => 'fixed-width-sm',
                    'suffix' => '%',
                    'required' => true,
                    'desc' => $this->trans('Returned percentage for the order', [], 'Modules.Psbonussystem.Admin'),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Transition amount', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'min_range',
                    'class' => 'fixed-width-sm',
                    'suffix' => '¤',
                    'required' => true,
                    'desc' => $this->trans('Minimum amount to go', [], 'Modules.Psbonussystem.Admin'),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->trans('Max Range', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'max_range',
                    'class' => 'fixed-width-sm',
                    'suffix' => '¤',
                    'required' => true,
                    'desc' => $this->trans('Maximum number to go', [], 'Modules.Psbonussystem.Admin'),
                ),
                array(
                    'type' => 'textarea',
                    'label' => $this->trans('Description', [], 'Modules.Psbonussystem.Admin'),
                    'name' => 'description',
                    'required' => false,
                    'lang' => true,
                ),
            ),
            'submit' => array(
                'title' => $this->trans('Save', [], 'Modules.Psbonussystem.Admin'),
                'class' => 'btn btn-default pull-right'
            )
        );

        return parent::renderForm();
    }

    public function renderKpis()
    {
        return $this->context->smarty->fetch(
            _PS_MODULE_DIR_.'psbonussystem/views/templates/admin/info_levels.tpl'
        );
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_banner'] = array(
                'href' => self::$currentIndex.'&addbonus_levels&token='.$this->token,
                'desc' => $this->trans('Add new level', [], 'Modules.Psbonussystem.Admin'),
                'icon' => 'process-icon-new'
            );
        }
    }
}
