<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Adapter\Presenter\Cart\CartPresenter;

class PsbonusSystemAjaxModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $this->ajax = true;
    }

    public function displayAjax()
    {
        if ((int)Configuration::get('PS_CURRENCY_DEFAULT') != (int)$this->context->cookie->id_currency) {
            die(json_encode('false'));
        }

        if ($this->context->customer->isLogged()) {
            if (Tools::getValue('action') == 'display') {
                $total_cart = ToolsBonus::getTotalcart();
                $bonus_user = BonusaccountObj::getPointsByCustomer(
                    (int)$this->context->customer->id
                );
                $hash = Tools::hash((int)$this->context->customer->id);
                $id_cart_rule = Db::getInstance()->getValue('
                    SELECT id_cart_rule
                    FROM '._DB_PREFIX_.'cart_rule
                    WHERE id_customer = '.(int)$this->context->customer->id.'
                    AND code = \'' . pSQL($hash) . '\'');
                $price = ToolsBonus::getTotalCartRule(
                    (int)$id_cart_rule,
                    $this->context->cart,
                    $this->context->customer
                );

                if ((float)$total_cart > 0 || (float)$bonus_user > 0) {
                    $cms_page = false;
                    if ((int)Configuration::get('PS_LOYALTY_BONUS_PAGE_SYSTEM')) {
                        $cms_page = new CMS((int)Configuration::get('PS_LOYALTY_BONUS_PAGE_SYSTEM'));
                    }
                    $exist_type = Db::getInstance()->getValue(
                        '
                        SELECT type
                        FROM ' . _DB_PREFIX_ . 'bonus_type_cart
                        WHERE id_customer = '.(int)$this->context->customer->id.'
                        AND id_cart = '.(int)$this->context->cart->id
                    );
                    if (Tools::getIsset('setType') && (int)Tools::getValue('setType') > 0 && Configuration::get('PS_LOYALTY_TYPE')) {
                        $this->context->cart->removeCartRule(CartRule::getIdByCode($hash));
                        if ($exist_type) {
                            Db::getInstance()->update(
                                'bonus_type_cart',
                                array(
                                    'type' => (int)Tools::getValue('setType'),
                                ),
                                'id_customer = '.(int)$this->context->customer->id.'
                                AND id_cart = '.(int)$this->context->cart->id
                            );
                        } else {
                            Db::getInstance()->insert('bonus_type_cart', [
                                'id_customer' => (int)$this->context->customer->id,
                                'id_cart' => (int)$this->context->cart->id,
                                'type' => (int)Tools::getValue('setType'),
                            ]);
                        }
                    }

              
                    $this->tpl_cart = array(
                        'link_ajax' => $this->context->link->getModuleLink(
                            'psbonussystem',
                            'ajax',
                            array(
                                'ajax' => 1,
                                'action' => 'display',
                                'setType' => ''
                            ),
                            true
                        ),
                        'loyalty_type' => Configuration::get('PS_LOYALTY_TYPE'),
                        'ball' => Tools::displayPrice(
                            $bonus_user,
                            (int)Configuration::get('PS_CURRENCY_DEFAULT')
                        ),
                        'ball_full' => $bonus_user,
                        'get_total_cart_rule' => $price,
                        'price' => Tools::displayPrice(
                            $price,
                            (int)Configuration::get('PS_CURRENCY_DEFAULT')
                        ),
                        'isAutch' => true,
                        'link_bs' => Validate::isLoadedObject($cms_page) ? $this->context->link->getCMSLink($cms_page) : false,
                        'id_user' => (int)$this->context->customer->id,
                        'token' => $hash,
                        'ball_amount' => Tools::ps_round(
                            ToolsBonus::ballAmount(),
                            ToolsBonus::getComputingPrecision()
                        ),
                        'reduction_amount' => ToolsBonus::reductionAmount(),
                        'bonus_type_decision' => $exist_type,
                        'total_cart' => $total_cart
                    );

                    $cartPresenter = new CartPresenter();
                    $presentedCart = $cartPresenter->present($this->context->cart);

                    // filter product output
                    $presentedCart['products'] = $this->get('prestashop.core.filter.front_end_object.product_collection')
                        ->filter($presentedCart['products']);

                    $this->ajaxRender(json_encode([
                        'cart_return' => $presentedCart,
                        'cart' => $this->context->smarty->fetch(
                            _PS_MODULE_DIR_ . 'psbonussystem/views/templates/hook/displayShoppingCartAjax.tpl',
                            $this->tpl_cart
                        )
                    ]));
                } else {
                    die(json_encode('false'));
                }
            } elseif (Tools::getValue('action') == 'apply' && (float)Tools::getValue('point') > 0) {
                $hash = Tools::hash((int)$this->context->customer->id);
                $total_cart = ToolsBonus::getTotalcart();
                $offs_ball = ($total_cart * (int)Configuration::get('PS_CASHBACK')) / 100;
                $offs_ball = Tools::ps_round(
                    $offs_ball,
                    ToolsBonus::getComputingPrecision()
                );
                $bonus_user = BonusaccountObj::getPointsByCustomer(
                    (int)$this->context->customer->id
                );
                if ((float)Tools::getValue('point') > 0 && $total_cart > 0) {
                    $offs_ball_end = 0;
                    if ($offs_ball >= $bonus_user || $offs_ball >= Tools::getValue('point')) {
                        $offs_ball_end = Tools::getValue('point');
                    } else {
                        $offs_ball_end = $bonus_user;
                    }
                    $offs_ball_end = str_replace(' ', '', $offs_ball_end);
                    BonusaccountObj::bonusUpdate(
                        (int)$this->context->customer->id,
                        $offs_ball_end
                    );
                } else {
                    die(json_encode('false'));
                }
                if (($code = trim($hash)) && Validate::isCleanHtml($code)) {
                    if (($cartRule = new CartRule(CartRule::getIdByCode($code))) && Validate::isLoadedObject($cartRule)) {
                        if ($cartRule->checkValidity($this->context, false, true)) {
                            die(json_encode($cartRule->checkValidity($this->context, false, true)));
                        } else {
                            $this->context->cart->addCartRule($cartRule->id);
                            die(json_encode('true'));
                        }
                    }
                } else {
                    die(json_encode('false'));
                }
            } else {
                die(json_encode('false'));
            }
        } else {
            die(json_encode('false'));
        }
    }
}
