<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/BonusaccountObj.php');
require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/ToolsBonus.php');
require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/Actions.php');

class PsbonussystemBonusaccountModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $auth = true;
    public function initContent()
    {
        $this->display_column_right = false;
        $this->display_column_left  = false;

        parent::initContent();

        $bonus_user = BonusaccountObj::getPointsByCustomer(
            (int)$this->context->customer->id
        );
        $p = Tools::getValue('p');
        $n = 15;
        if ($p < 1) {
            $p = 1;
        }
        $pages_nb = ceil(BonusaccountObj::getCount($this->context->customer->id)['count'] / (int)$n);
        $range = 2;
        $start = (int) ($p - $range);
        if ($start < 1) {
            $start = 1;
        }
        $stop = (int) ($p + $range);
        if ($stop > $pages_nb) {
            $stop = (int) $pages_nb;
        }
        if (!$p) {
            $p = 1;
        }
        $cms_page = false;
        if ((int)Configuration::get('PS_LOYALTY_BONUS_PAGE_REF')) {
            $cms_page = new CMS((int)Configuration::get('PS_LOYALTY_BONUS_PAGE_REF'));
        }

        $this->context->smarty->assign(array(
            'pages_nb' => $pages_nb,
            'link_ref' => $this->context->link->getBaseLink(
                $this->context->shop->id
            ).'?r='.ToolsBonus::dsCrypt(
                ToolsBonus::andomNumber(5).$this->context->customer->id.ToolsBonus::andomNumber(5)
            ),
            'isActionRef' => Actions::getAction('friend'),
            'link_a' => Validate::isLoadedObject($cms_page) ? $this->context->link->getCMSLink($cms_page) : false,
            'info' => Levels::getLevelInfo($this->context->customer->id, $this->context->language->id),
            'prev_p' => $p != 1 ? $p - 1 : 1,
            'next_p' => (int)$p + 1  > $pages_nb ? $pages_nb : $p + 1,
            'requestPage' => $this->context->link->getModuleLink('psbonussystem', 'bonusaccount', array(), true),
            'p' => $p,
            'n' => $n,
            'range' => $range,
            'start' => $start,
            'stop' => $stop,
            'ball' => Tools::displayPrice($bonus_user, (int)Configuration::get('PS_CURRENCY_DEFAULT')),
            'list_bonus' => BonusaccountObj::getListByCustomerPay(
                (int)$this->context->customer->id,
                $p,
                $n
            )
        ));
        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            $this->setTemplate('module:psbonussystem/views/templates/front/bonusaccountaccount.tpl');
        } else {
            $this->setTemplate('bonusaccountaccount16.tpl');
        }
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        $breadcrumb['links'][] = $this->addMyAccountToBreadcrumb();
        $breadcrumb['links'][] = array('title' => $this->trans('Bonus account', [], 'Modules.Psbonussystem.Shop'), 'url' => false );
        return $breadcrumb;
    }
}
