<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/ToolsBonus.php');
require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/BonusaccountObj.php');
require_once(_PS_MODULE_DIR_ . 'psbonussystem/classes/Actions.php');

class PsbonusSystemCronModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $this->ajax = true;
    }

    public function displayAjax()
    {
        if (Tools::substr(Tools::encrypt('psbonussystem/index'), 0, 10) != Tools::getValue('token') || !Module::isInstalled('psbonussystem')) {
            die('Bad token');
        }
        if (Actions::getAction('birthday') && !Tools::getValue('action')) {
            $select = Db::getInstance()->executeS('
                SELECT id_customer, email, firstname, lastname, birthday
                FROM `' . _DB_PREFIX_ . 'customer`
                WHERE DATE_FORMAT( `birthday` , "%m-%d") = "'.date('m-d').'"');
            foreach ($select as $value) {
                $action = Actions::getBonusActions(
                    'birthday',
                    (int)$value['id_customer']
                );
                $date = new DateTime();
                if ($action) {
                    $date->add(new DateInterval('P'.(int)$action['many_days'].'D'));
                    $bonus = new BonusaccountObj();
                    $bonus->id_customer = (int)$value['id_customer'];
                    $bonus->id_order = (int)0;
                    $bonus->id_cart_rule = (int)0;
                    $bonus->points = $action['point'];
                    $bonus->comment = $this->trans('Bonus on your birthday', [], 'Modules.Psbonussystem.Shop');
                    $bonus->status = 1;
                    $bonus->paid = 1;
                    $bonus->type = pSQL('birthday');
                    $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                    $bonus->save();
                    if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                        $info_bonus = '';
                        $info_bonus .= '<span style="color:#333"><strong>'.$this->trans('Bonus type', [], 'Modules.Psbonussystem.Shop').'</strong></span> '.$this->trans('Bonus on your birthday').' <br /><br />';
                        $info_bonus .= '<span style="color:#333"><strong>'.$this->trans('Accrued').'</strong></span> '.Tools::displayPrice(
                            $action['point'],
                            (int)Configuration::get('PS_CURRENCY_DEFAULT')
                        ).' <br /><br />';
                        $info_bonus .= '<span style="color:#333"><strong>'.$this->trans('Valid until', [], 'Modules.Psbonussystem.Shop').'</strong></span> '.$date->format('Y-m-d H:i:s').' <br /><br />';
                        $this->emailSend($info_bonus, $value);
                    }
                }
            }
        } elseif (Tools::getValue('action') == 'reminder' &&
        Configuration::get('PS_LOYALTY_REMINDER') &&
        (int)Configuration::get('PS_LOYALTY_REMINDER_TIME') > 0) {
            $reminder_time = (int) Configuration::get('PS_LOYALTY_REMINDER_TIME');
            $customers = Db::getInstance()->executeS(
                '
                SELECT o.`id_customer`, c.`email`
                FROM `' . _DB_PREFIX_ . 'orders` o
                LEFT JOIN `' . _DB_PREFIX_ . 'customer` c ON o.id_customer = c.id_customer
                WHERE DATE(o.`date_add`) = DATE(NOW() - INTERVAL '.$reminder_time.' DAY)'
            );

            foreach ($customers as $customer) {
                $bonus_user = BonusaccountObj::getPointsByCustomer($customer['id_customer']);
                if ($bonus_user > 0) {
                    $this->emailSendReminder(
                        Tools::displayPrice($bonus_user, (int)Configuration::get('PS_CURRENCY_DEFAULT')),
                        $customer
                    );
                }
            }
        }


        die('1');
    }

    public function emailSend($info_bonus, $user)
    {
        $language = new Language($this->context->language->id);
        if (!Validate::isLoadedObject($language)) {
            $locale = $language->getLocale();
        } else {
            $locale = $this->context->language->getLocale();
        }
        Mail::Send(
            $this->context->language->id,
            'psbonussystem_mail',
            $this->trans('Bonus system', [], 'Emails.Subject', $locale),
            array(
                '{info_bonus}' => $info_bonus,
                '{info_bonus_title}' => $user['firstname'] .' '. $user['lastname'].' '. $this->trans('you have received bonuses', [], 'Modules.Psbonussystem.Shop'),
            ),
            $user['email'],
            null,
            null,
            null,
            null,
            null,
            dirname(__FILE__).'/mails/',
            null,
            (int)$this->context->shop->id
        );
    }

    public function emailSendReminder($point, $user)
    {
        Mail::Send(
            $this->context->language->id,
            'psbonussystem_reminder',
            Mail::l('Remaining bonuses', $this->context->language->id),
            array(
                '{point}' => $point
            ),
            'tim9898@ya.ru',
            null,
            null,
            null,
            null,
            null,
            dirname(__FILE__).'/mails/',
            null,
            (int)$this->context->shop->id
        );
    }
}
