<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once dirname(__FILE__).'/classes/BsRequiredClasses.php';
class PsbonusSystem extends Module
{
    public $total_cart;
    public $offs_ball;
    public $bonus_user;
    protected $html = '';

    public function __construct()
    {
        $this->name = 'psbonussystem';
        $this->tab = 'pricing_promotion';
        $this->module_key = '130d838c058157e985718f0a47e82bec';
        $this->version = '3.1.1';
        $this->author = 'Ewonta';
        $this->need_instance = 0;

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->trans('Bonus cashback sustem', [], 'Modules.Psbonussystem.Admin');
        $this->description = $this->trans('Bonus system with a wide range of features', [], 'Modules.Psbonussystem.Admin');

        $this->confirmUninstall = $this->trans('All information will be deleted, are you sure?', [], 'Modules.Psbonussystem.Admin');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        Configuration::updateValue('PS_LOYALTY_BONUS_STATUS_BACK', 3);
        Configuration::updateValue('PS_LOYALTY_BONUS_INT', false);
        Configuration::updateValue('PS_LOYALTY_LEVEL_DEFAULT', 5);
        Configuration::updateValue('PS_CASHBACK', 40);
        Configuration::updateValue('PS_LOYALTY_DAY', 365);
        Configuration::updateValue('PS_LOYALTY_BONUS_PAGE_SYSTEM', 0);
        Configuration::updateValue('PS_LOYALTY_BONUS_PAGE_REF', 0);
        Configuration::updateValue('PS_LOYALTY_BONUS_EMAIL_SEND', true);
        Configuration::updateValue('PS_LOYALTY_TYPE_TAX', true);
        Configuration::updateValue('PS_LOYALTY_SHOW_PRICE', true);
        Configuration::updateValue('PS_LOYALTY_SHOW_ONE_PRODUCE_INFO', true);
        Configuration::updateValue('PS_LOYALTY_TYPE', true);
        Configuration::updateValue('PS_LOYALTY_POSITION_CART', 1);
        Configuration::updateValue('PS_LOYALTY_CHECKOUT', true);
        Configuration::updateValue('PS_LOYALTY_REMINDER', true);
        Configuration::updateValue('PS_LOYALTY_REMINDER_TIME', 30);


        include(dirname(__FILE__).'/sql/install.php');
        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('displayShoppingCart') &&
            $this->registerHook('displayProductPriceBlock') &&
            $this->registerHook('displayProductCartBlockLine') &&
            $this->registerHook('displayCustomerAccount') &&
            $this->registerHook('displayProductAdditionalInfo') &&
            $this->registerHook('displayOrderDetail') &&
            $this->registerHook('displayAdminOrder') &&
            $this->registerHook('displayAdminCustomers') &&
            $this->registerHook('actionOrderStatusPostUpdate') &&
            $this->registerHook('actionValidateOrder') &&
            $this->registerHook('actionCartSave') &&
            $this->registerHook('moduleRoutes') &&
            $this->registerHook('actionObjectCustomerAddAfter') &&
            $this->registerHook('actionObjectCustomerUpdateBefore') &&
            $this->registerHook('displayShoppingCartFooter') &&
            $this->registerHook('displayPaymentTop') &&
            $this->createMailLangDirectoryWithFiles() &&
            $this->installModuleTab();
    }

    public function uninstall()
    {
        Configuration::deleteByName('PS_LOYALTY_BONUS_STATUS_BACK');
        Configuration::deleteByName('PS_LOYALTY_LEVEL_DEFAULT');
        Configuration::deleteByName('PS_CASHBACK');
        Configuration::deleteByName('PS_LOYALTY_DAY');
        Configuration::deleteByName('PS_LOYALTY_BONUS_INT');
        Configuration::deleteByName('PS_LOYALTY_BONUS_PAGE_SYSTEM');
        Configuration::deleteByName('PS_LOYALTY_BONUS_PAGE_REF');
        Configuration::deleteByName('PS_LOYALTY_BONUS_EMAIL_SEND');
        Configuration::deleteByName('PS_LOYALTY_TYPE_TAX');
        Configuration::deleteByName('PS_LOYALTY_SHOW_PRICE');
        Configuration::deleteByName('PS_LOYALTY_SHOW_ONE_PRODUCE_INFO');
        Configuration::deleteByName('PS_LOYALTY_TYPE');
        Configuration::deleteByName('PS_LOYALTY_POSITION_CART');
        Configuration::deleteByName('PS_LOYALTY_CHECKOUT');
        Configuration::deleteByName('PS_LOYALTY_REMINDER');
        Configuration::deleteByName('PS_LOYALTY_REMINDER_TIME');

        $this->uninstallModuleTab();
        include(dirname(__FILE__).'/sql/uninstall.php');

        return parent::uninstall();
    }

    protected function installModuleTab()
    {
        $langs = Language::getLanguages();
        $bonustab = new Tab();
        $bonustab->class_name = 'AdminIm' .get_class($this);
        $bonustab->module = "psbonussystem";
        $bonustab->icon = 'account_balance_wallet';
        $bonustab->id_parent = (int)Tab::getIdFromClassName('SELL');
        foreach (Language::getLanguages(false) as $lang) {
            $bonustab->name[(int)$lang['id_lang']] = $this->trans('Bonus cashback', [], 'Modules.Psbonussystem.Admin');
        }
        $bonustab->save();
        $tab_id = $bonustab->id;
        $tabvalue = array(
            array(
                'class_name' => 'AdminPsbonusSystemLevels',
                'module' => 'psbonussystem',
                'name' => $this->trans('Levels', [], 'Modules.Psbonussystem.Admin'),
            ),
            array(
                'class_name' => 'AdminPsbonusSystemActions',
                'module' => 'psbonussystem',
                'name' => $this->trans('Actions', [], 'Modules.Psbonussystem.Admin'),
            ),
            array(
                'class_name' => 'AdminPsbonusSystemControl',
                'module' => 'psbonussystem',
                'name' => $this->trans('Control', [], 'Modules.Psbonussystem.Admin'),
            ),
            array(
                'class_name' => 'AdminPsbonusSystemIncreased',
                'module' => 'psbonussystem',
                'name' => $this->trans('Increased Cash Back', [], 'Modules.Psbonussystem.Admin'),
            ),
            array(
                'class_name' => 'AdminPsbonusSystemAccrual',
                'module' => 'psbonussystem',
                'name' => $this->trans('Accrual Percentage', [], 'Modules.Psbonussystem.Admin'),
            ),
            array(
                'class_name' => 'AdminPsbonusSystemSettings',
                'module' => 'psbonussystem',
                'name' => $this->trans('Settings', [], 'Modules.Psbonussystem.Admin'),
            ),
        );
        foreach ($tabvalue as $tab) {
            $newtab = new Tab();
            $newtab->class_name = $tab['class_name'];
            $newtab->id_parent = $tab_id;
            $newtab->module = $tab['module'];
            foreach ($langs as $l) {
                $newtab->name[$l['id_lang']] = $this->trans($tab['name'], [], 'Modules.Psbonussystem.Admin');
            }
            $newtab->save();
        }
        return true;
    }

    protected function uninstallModuleTab()
    {
        $moduleTabs = Tab::getCollectionFromModule($this->name);
        if (!empty($moduleTabs)) {
            foreach ($moduleTabs as $moduleTab) {
                $moduleTab->delete();
            }
        }
        return true;
    }

    public function createMailLangDirectoryWithFiles()
    {
        $mailEnDir = _PS_MODULE_DIR_.'psbonussystem/mails/en/';
        if (is_dir($mailEnDir)) {
            $allFiles = scandir($mailEnDir);
            $allLanguages = Language::getLanguages(false, $this->context->shop->id);
            if ($allLanguages) {
                $moduleMailDir = _PS_MODULE_DIR_.'psbonussystem/mails/';
                foreach ($allLanguages as $language) {
                    $langISO = $language['iso_code'];
                    if ($langISO != 'en' || $langISO != 'ru') {
                        //create lang dir if not exist in module mails directory
                        if (!file_exists($moduleMailDir.$langISO)) {
                            @mkdir($moduleMailDir.$langISO, 0777, true);
                        }

                        //Now if lang dir is exist or created by above code
                        if (is_dir($moduleMailDir.$langISO)) {
                            foreach ($allFiles as $fileName) {
                                if ($fileName != '.' && $fileName != '..') {
                                    $source = $mailEnDir.$fileName;
                                    $destination = $moduleMailDir.$langISO.'/'.$fileName;
                                    //if file not exist in desti directory then create that file
                                    if (!file_exists($destination) && file_exists($source)) {
                                        Tools::copy($source, $destination);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return true;
    }


    /**
     * Load the configuration form
     */
    public function getContent()
    {
        /**
         * If values have been submitted in the form, process.
         */
        $this->context->smarty->assign(
            array(
                'link_cron' => $this->context->link->getModuleLink(
                    'psbonussystem',
                    'cron',
                    array(
                       'token' => Tools::substr(Tools::encrypt('psbonussystem/index'), 0, 10)
                    ),
                    true
                ),
                'link_cron_reminder' => $this->context->link->getModuleLink(
                    'psbonussystem',
                    'cron',
                    array(
                        'action' => 'reminder',
                        'token' => Tools::substr(Tools::encrypt('psbonussystem/index'), 0, 10)
                    ),
                    true
                )
            )
        );
        $this->html .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
        if (((bool)Tools::isSubmit('submitPsbonussystemModule')) == true) {
            if (is_numeric(Tools::getValue('PS_LOYALTY_LEVEL_DEFAULT')) &&
            is_numeric(Tools::getValue('PS_LOYALTY_DAY')) &&
            is_numeric(Tools::getValue('PS_CASHBACK'))) {
                $this->postProcess();
                $_errors = array();
                if (!count($_errors)) {
                    $this->html .= $this->displayConfirmation($this->trans('Settings updated.', [], 'Modules.Psbonussystem.Admin'));
                } else {
                    $errors = '';
                    foreach ($_errors as $error) {
                        $errors .= $error;
                    }
                    $this->html .= $this->displayError($errors);
                }
            } else {
                $this->html .= $this->displayError($this->trans('Check the entered data', [], 'Modules.Psbonussystem.Admin'));
            }
        }

        $this->context->smarty->assign('module_dir', $this->_path);



        $this->smarty->assign(array(
            'alert' => $this->html,
            'action' => Tools::getValue('action', 'general'),
            'panel_href' => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
            'settings_form' => $this->renderSettingsForm(),
        ));

        return $this->display(__FILE__, 'views/templates/admin/settings_form.tpl');
    }

    protected function renderSettingsForm()
    {
        $action = Tools::getValue('action');
        if ($action == 'modules') {
            $this->context->controller->addCSS($this->_path.'views/css/modules.css');
            $this->getDashboardModule();
            $result = $this->context->smarty->fetch($this->local_path.'views/templates/admin/modules.tpl');
        } else {
            $result = $this->renderForm();
        }

        return $result;
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitPsbonussystemModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    protected function getConfigForm()
    {
        $order_states = OrderState::getOrderStates($this->context->language->id);
        $page_system = CMS::listCms($this->context->language->id);

        $options = array(
            array(
              'id_option' => '1',
              'name' => $this->trans('In the right column', [], 'Modules.Psbonussystem.Admin')
            ),
            array(
                'id_option' => '2',
                'name' => $this->trans('Under the products', [], 'Modules.Psbonussystem.Admin')
            )
        );

        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->trans('Settings', [], 'Modules.Psbonussystem.Admin'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Enable reminder of remaining bonuses', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_REMINDER',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'reminder_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'reminder_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        ),
                        'desc' => $this->trans('Do I need to send users that they have bonuses left and they can be spent.', [], 'Modules.Psbonussystem.Admin'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Number of days', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_REMINDER_TIME',
                        'desc' => $this->trans('After how many days to send a reminder letter about the remaining bonuses', [], 'Modules.Psbonussystem.Admin'),
                        'class' => 'fixed-width-sm',
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Accumulate / Write off', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_TYPE',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'equal_price_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'equal_price_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        ),
                        'desc' => $this->trans('When the function is enabled, the client will be able to choose only one, either Accumulate either Write off', [], 'Modules.Psbonussystem.Admin'),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Show on checkout page', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_CHECKOUT',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'equal_price_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'equal_price_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        ),
                        'desc' => $this->trans('Display on the checkout page in the payment block', [], 'Modules.Psbonussystem.Admin'),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->trans('Position in the cart', [], 'Modules.Psbonussystem.Admin'),
                        'desc' => $this->trans('Where exactly the information for writing off bonuses in the basket will be displayed', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_POSITION_CART',
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Display cashback information next to the price', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_SHOW_PRICE',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'equal_price_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'equal_price_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        )
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Display information in the product card', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_SHOW_ONE_PRODUCE_INFO',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'equal_main_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'equal_main_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        )
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Write off only in equal parts', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_BONUS_INT',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'equal_parts_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'equal_parts_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        ),
                        'desc' => $this->trans('Bonuses can be written off with whole numbers or with a number with a dot', [], 'Modules.Psbonussystem.Admin'),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Send email about new bonus', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_BONUS_EMAIL_SEND',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'email_send_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'email_send_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Default accrual percentage', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_LEVEL_DEFAULT',
                        'desc' => $this->trans('If you do not need levels and need one percent of the accrual', [], 'Modules.Psbonussystem.Admin'),
                        'class' => 'fixed-width-sm',
                        'suffix' => '%',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('How many days are bonuses valid', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_DAY',
                        'desc' => $this->trans('For the standard behavior of the bonus system (Bonus for order)', [], 'Modules.Psbonussystem.Admin'),
                        'class' => 'fixed-width-sm',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Write-off percentage', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_CASHBACK',
                        'desc' => $this->trans('Maximum percentage of points deducted', [], 'Modules.Psbonussystem.Admin'),
                        'class' => 'fixed-width-sm',
                        'suffix' => '%',
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->trans('Tax', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_TYPE_TAX',
                        'desc' => $this->trans('Are bonuses calculated with tax?', [], 'Modules.Psbonussystem.Admin'),
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'value' => true,
                                'id' => 'tax_on',
                                'label' => $this->trans('Enabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                            array(
                                'value' => false,
                                'id' => 'tax_off',
                                'label' => $this->trans('Disabled', [], 'Modules.Psbonussystem.Admin')
                            ),
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->trans('Referral system information page', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_BONUS_PAGE_REF',
                        'options' => array(
                            'query' => $page_system,
                            'id' => 'id_cms',
                            'name' => 'meta_title',
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->trans('Bonus system information page', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_BONUS_PAGE_SYSTEM',
                        'options' => array(
                            'query' => $page_system,
                            'id' => 'id_cms',
                            'name' => 'meta_title',
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->trans('Points are cancelled when the order is', [], 'Modules.Psbonussystem.Admin'),
                        'name' => 'PS_LOYALTY_BONUS_STATUS_BACK',
                        'options' => array(
                            'query' => $order_states,
                            'id' => 'id_order_state',
                            'name' => 'name',
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->trans('Save', [], 'Modules.Psbonussystem.Admin'),
                ),
            ),
        );
    }

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        return array(
            'PS_LOYALTY_LEVEL_DEFAULT' => Configuration::get('PS_LOYALTY_LEVEL_DEFAULT'),
            'PS_LOYALTY_BONUS_STATUS_BACK' => Configuration::get('PS_LOYALTY_BONUS_STATUS_BACK'),
            'PS_CASHBACK' => Configuration::get('PS_CASHBACK'),
            'PS_LOYALTY_DAY' => Configuration::get('PS_LOYALTY_DAY'),
            'PS_LOYALTY_BONUS_INT' => Configuration::get('PS_LOYALTY_BONUS_INT'),
            'PS_LOYALTY_BONUS_PAGE_SYSTEM' => Configuration::get('PS_LOYALTY_BONUS_PAGE_SYSTEM'),
            'PS_LOYALTY_BONUS_PAGE_REF' => Configuration::get('PS_LOYALTY_BONUS_PAGE_REF'),
            'PS_LOYALTY_BONUS_EMAIL_SEND' => Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND'),
            'PS_LOYALTY_TYPE_TAX' => Configuration::get('PS_LOYALTY_TYPE_TAX'),
            'PS_LOYALTY_SHOW_PRICE' => Configuration::get('PS_LOYALTY_SHOW_PRICE'),
            'PS_LOYALTY_SHOW_ONE_PRODUCE_INFO' => Configuration::get('PS_LOYALTY_SHOW_ONE_PRODUCE_INFO'),
            'PS_LOYALTY_TYPE' => Configuration::get('PS_LOYALTY_TYPE'),
            'PS_LOYALTY_POSITION_CART' => Configuration::get('PS_LOYALTY_POSITION_CART'),
            'PS_LOYALTY_CHECKOUT' => Configuration::get('PS_LOYALTY_CHECKOUT'),
            'PS_LOYALTY_REMINDER' => Configuration::get('PS_LOYALTY_REMINDER'),
            'PS_LOYALTY_REMINDER_TIME' => Configuration::get('PS_LOYALTY_REMINDER_TIME'),
        );
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {
            Configuration::updateValue($key, Tools::getValue($key), true);
        }
    }

    private function voucherCategories($categories)
    {
        $cat = '';
        if ($categories && is_array($categories)) {
            foreach ($categories as $category) {
                $cat .= $category.',';
            }
        }
        return rtrim($cat, ',');
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        $this->context->controller->registerJavascript(
            'modules-psbonussystem',
            'modules/'.$this->name.'/views/js/front.js',
            ['position' => 'bottom', 'priority' => 160]
        );
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');



        if (Tools::getValue('r')) {
            $this->context->cookie->id_ref = (int)Tools::substr(
                ToolsBonus::dsCrypt(Tools::getValue('r'), true),
                5,
                -5
            );
        }

        $currency = new Currency((int)Configuration::get('PS_CURRENCY_DEFAULT'));
        Media::addJsDef(array(
            'bonus_int' => Configuration::get('PS_LOYALTY_BONUS_INT'),
            'link_bs' => $this->context->link->getModuleLink(
                'psbonussystem',
                'ajax',
                array('ajax' => 1,'action' => 'display'),
                true
            ),
            'link_bs_apply' => $this->context->link->getModuleLink(
                'psbonussystem',
                'ajax',
                array('ajax' => 1,'action' => 'apply'),
                true
            ),
            'currency_symbol' => version_compare(_PS_VERSION_, '1.7.5', '>=') ? $currency->symbol : $currency->sign,
            'reduction_amount' => ToolsBonus::reductionAmount(),
            'ball_amount' => Tools::ps_round(
                ToolsBonus::ballAmount(),
                ToolsBonus::getComputingPrecision()
            )
        ));
    }

    public function hookdisplayPaymentTop()
    {
        if (Configuration::get('PS_LOYALTY_CHECKOUT')) {
            $templateFile = 'module:psbonussystem/views/templates/hook/displayPaymentTop.tpl';
            $cacheId = $this->name.'|displayPaymentTop';
            return $this->fetch($templateFile, $this->getCacheId($cacheId));
        }
    }

    public function hookDisplayShoppingCartFooter()
    {
        if (Configuration::get('PS_LOYALTY_POSITION_CART') == 2) {
            $templateFile = 'module:psbonussystem/views/templates/hook/displayShoppingCart.tpl';
            $cacheId = $this->name.'|displayShoppingCartFooter';
            return $this->fetch($templateFile, $this->getCacheId($cacheId));
        }
    }

    public function hookDisplayProductPriceBlock($params)
    {
        if (Tools::getValue('action') == 'add-to-cart' ||
        !(int)Configuration::get('PS_LOYALTY_SHOW_PRICE') ||
        Tools::getValue('controller') == 'order' ||
        Tools::getValue('controller') == 'cart') {
            return;
        }
        if ((int)Configuration::get('PS_CURRENCY_DEFAULT') != (int)$this->context->cookie->id_currency) {
            return;
        }
        if ($params['type'] == 'unit_price') {
            if (Validate::isLoadedObject($params['product'])) {
                $price_type = Configuration::get('PS_LOYALTY_TYPE_TAX') ? Product::getPriceStatic($params['product']['id']) : Product::getPriceStatic($params['product']['id'], false);
                $product_price = ((float)$price_type * (int)$params['product']['minimal_quantity']);
                $level_procent = Levels::getLevelPercent(
                    $params['product'],
                    $this->context->customer
                );
                $price = ($product_price * $level_procent['return']) / 100;
                if ($level_procent['return'] == 0) {
                    return;
                }
                $this->context->smarty->assign(array(
                    'level_procent' => (int)$level_procent['return'],
                    'isFlash' => $level_procent['isFlash'],
                    'price' =>  Tools::displayPrice(
                        $price,
                        (int)Configuration::get('PS_CURRENCY_DEFAULT')
                    ),
                ));
                return $this->display($this->local_path, 'views/templates/hook/displayProductPriceBlock.tpl');
            }
        }
    }

    public function hookDisplayProductCartBlockLine($params)
    {
        if ((int)Configuration::get('PS_CURRENCY_DEFAULT') != (int)$this->context->cookie->id_currency) {
            return;
        }

        if (Validate::isLoadedObject($params['product'])) {
            $price_type = Configuration::get('PS_LOYALTY_TYPE_TAX') ? Product::getPriceStatic($params['product']['id']) : Product::getPriceStatic($params['product']['id'], false);
            $product_price = ((float)$price_type * (int)$params['product']['quantity']);
            $level_procent = Levels::getLevelPercent(
                $params['product'],
                $this->context->customer
            );
            if ($level_procent['return'] == 0) {
                return;
            }
            $price = ($product_price * $level_procent['return']) / 100;
            $this->context->smarty->assign(array(
                'level_procent' => (int)$level_procent['return'],
                'isFlash' => $level_procent['isFlash'],
                'price' =>  Tools::displayPrice(
                    $price,
                    (int)Configuration::get('PS_CURRENCY_DEFAULT')
                ),
            ));
            return $this->display($this->local_path, 'views/templates/hook/displayProductPriceBlock.tpl');
        }
    }

    public function hookDisplayShoppingCart()
    {
        if ((int)Configuration::get('PS_CURRENCY_DEFAULT') != (int)$this->context->cookie->id_currency) {
            return;
        }

        if ($this->context->customer->isLogged()) {
            ToolsBonus::resetCartRule();
            $bonus_user = BonusaccountObj::getPointsByCustomer(
                (int)$this->context->customer->id
            );
            $hash = Tools::hash((int)$this->context->customer->id);
            $id_cart_rule = Db::getInstance()->getValue('
                SELECT id_cart_rule
                FROM '._DB_PREFIX_.'cart_rule
                WHERE id_customer = '.(int)$this->context->customer->id.'
                AND code = \'' . pSQL($hash) . '\'');
            if (!$id_cart_rule) {
                $languages = Language::getLanguages();
                $array = array();
                $date = new DateTime();
                $date->add(new DateInterval('P3Y'));
                foreach ($languages as $language) {
                    $array[$language['id_lang']] = "Bonus";
                }
                $cartrule = new CartRule();
                $cartrule->name = $array;
                $cartrule->id_customer =  (int)$this->context->customer->id;
                $cartrule->date_from = date('Y-m-d H:i:s');
                $cartrule->date_to = $date->format('Y-m-d H:i:s');
                $cartrule->description = 'Bonus system';
                $cartrule->quantity = 100000;
                $cartrule->quantity_per_user = 100000;
                $cartrule->priority = 1;

                $cartrule->code = $hash;
                $cartrule->minimum_amount_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
                //Цена ваучера
                $cartrule->reduction_amount = 1;
                $cartrule->reduction_tax = 1;
                $cartrule->reduction_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
                $cartrule->active = 1;
                $cartrule->add();
            } else {
                $cartrule = new CartRule((int)$id_cart_rule);
                $cartrule->minimum_amount_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
                $cartrule->reduction_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
                $cartrule->reduction_tax = 1;
                $cartrule->active = 1;
                $cartrule->update();
            }
            if (Configuration::get('PS_LOYALTY_POSITION_CART') == 1) {
                return $this->display($this->local_path, 'views/templates/hook/displayShoppingCart.tpl');
            }
        }
    }

    public function hookdisplayCustomerAccount()
    {
        if ($this->context->customer->isLogged()) {
            $hash = Tools::hash((int)$this->context->customer->id);
            $id_cart_rule = Db::getInstance()->getValue('
                SELECT id_cart_rule
                FROM '._DB_PREFIX_.'cart_rule
                WHERE id_customer = '.(int)$this->context->customer->id.'
                AND code = \'' . pSQL($hash) . '\'');
            if ($id_cart_rule) {
                $cartrule = new CartRule((int)$id_cart_rule);
                $cartrule->active = 0;
                $cartrule->update();
            }
        }
        $url = $this->context->link->getModuleLink($this->name, 'bonusaccount', array(), true);
        $this->context->smarty->assign(array(
            'front_controller' => $url,
            'id_customer' => $this->context->customer->id,

        ));
        return $this->display($this->local_path, 'views/templates/front/displayCustomerAccount.tpl');
    }

    public function hookDisplayProductAdditionalInfo($params)
    {
        if ((int)Configuration::get('PS_CURRENCY_DEFAULT') != (int)$this->context->cookie->id_currency || !(int)Configuration::get('PS_LOYALTY_SHOW_ONE_PRODUCE_INFO')) {
            return;
        }

        $price_type = Configuration::get('PS_LOYALTY_TYPE_TAX') ? Product::getPriceStatic($params['product']['id']) : Product::getPriceStatic($params['product']['id'], false);
        $product_price = ($price_type * (int)$params['product']['quantity_wanted']);
        $level_procent = Levels::getLevelPercent(
            $params['product'],
            $this->context->customer
        );

        if ($level_procent['return'] == 0) {
            return;
        }

        if ($this->context->customer->isLogged()) {
            $price = ($product_price * $level_procent['return']) / 100;
            $this->context->smarty->assign(array(
                'level_procent' => (int)$level_procent['return'],
                'isFlash' => $level_procent['isFlash'],
                'price' =>  Tools::displayPrice(
                    $price,
                    (int)Configuration::get('PS_CURRENCY_DEFAULT')
                ),
            ));
        } else {
            $price = ($product_price * $level_procent['return']) / 100;
            $this->context->smarty->assign(array(
                'level_procent' => (int)$level_procent['return'],
                'isFlash' => $level_procent['isFlash'],
                'price' =>  Tools::displayPrice(
                    $price,
                    (int)Configuration::get('PS_CURRENCY_DEFAULT')
                ),
            ));
        }
        return $this->display($this->local_path, 'views/templates/hook/displayProductAdditionalInfo.tpl');
    }

    public function hookdisplayOrderDetail()
    {
        $list_bonus = BonusaccountObj::getListByCustomerPayone((int)Tools::getValue('id_order'));
        $currency = new Currency();
        $link = new Link();
        $this->context->smarty->assign(array(
            'link' => $link,
            'currency_bonus' => $currency->getCurrency((int)$this->context->cookie->id_currency),
            'list_bonus' => $list_bonus,
        ));
        return $this->display($this->local_path, 'views/templates/front/displayOrderDetail.tpl');
    }

    public function hookdisplayAdminOrder()
    {
        $list_bonus = BonusaccountObj::getListByCustomerPayone((int)Tools::getValue('id_order'));
        $this->context->smarty->assign(array(
            'list_bonus' => $list_bonus,
        ));
        if (!empty($list_bonus)) {
            return $this->display($this->local_path, 'views/templates/admin/displayAdminOrder.tpl');
        }
    }

    public function hookdisplayAdminCustomers()
    {
        $bonus_user = BonusaccountObj::getPointsByCustomer(
            (int)$this->context->customer->id
        );
        $p = Tools::getValue('p');
        $n = 15;
        if ($p < 1) {
            $p = 1;
        }
        $pages_nb = ceil(BonusaccountObj::getCount($this->context->customer->id)['count'] / (int)$n);
        $range = 2;
        $start = (int) ($p - $range);
        if ($start < 1) {
            $start = 1;
        }
        $stop = (int) ($p + $range);
        if ($stop > $pages_nb) {
            $stop = (int) $pages_nb;
        }

        if (!$p) {
            $p = 1;
        }


        $this->context->smarty->assign(array(
            'pages_nb' => $pages_nb,
            'prev_p' => $p != 1 ? $p - 1 : 1,
            'next_p' => (int)$p + 1  > $pages_nb ? $pages_nb : $p + 1,
            'requestPage' => $this->context->link->getModuleLink('psbonussystem', 'bonusaccount', array(), true),
            'p' => $p,
            'n' => $n,
            'range' => $range,
            'start' => $start,
            'stop' => $stop,
            'ball' => Tools::displayPrice($bonus_user, (int)Configuration::get('PS_CURRENCY_DEFAULT')),
            'list_bonus' => BonusaccountObj::getListByCustomerPay(
                (int)$this->context->customer->id,
                $p,
                $n
            )
        ));
        return $this->display($this->local_path, 'views/templates/admin/displayAdminCustomers.tpl');
    }


    public function hookactionOrderStatusPostUpdate($params)
    {
        if (Validate::isLoadedObject($params['newOrderStatus'])) {
            if ((int)Configuration::get('PS_LOYALTY_BONUS_STATUS_BACK') == (int)$params['newOrderStatus']->id) {
                Db::getInstance()->update(
                    'bonus_account',
                    array(
                    'status' => (int)3,
                    'paid' => (int)0,
                    'comment' => pSQL($this->trans('Bonuses canceled', [], 'Modules.Psbonussystem.Admin')),
                    ),
                    'id_order = '.(int)$params['id_order'].''
                );
            } else {
                Db::getInstance()->update(
                    'bonus_account',
                    array(
                        'paid' => (int)$params['newOrderStatus']->paid
                    ),
                    'id_order = '.(int)$params['id_order']. ' AND `status` = 1'
                );
            }
        }
    }

    public function hookactionValidateOrder($params)
    {
        $cart = $params['cart'];
        $order = $params['order'];
        $customer = $params['customer'];
        if (Validate::isLoadedObject($cart) &&
        Validate::isLoadedObject($order) &&
        Validate::isLoadedObject($customer) &&
        !$customer->is_guest) {
            $bonus_type_decision = Db::getInstance()->getValue(
                '
                SELECT type
                FROM ' . _DB_PREFIX_ . 'bonus_type_cart
                WHERE id_customer = '.(int)$this->context->customer->id.'
                AND id_cart = '.(int)$this->context->cart->id
            );
            $hash = Tools::hash((int)$this->context->customer->id);
            // id cart rule
            $cart_rule = Db::getInstance()->getRow('
                SELECT id_cart_rule,reduction_amount
                FROM '._DB_PREFIX_.'cart_rule
                WHERE id_customer = '.(int)$customer->id.'
                AND code = \'' . pSQL($hash) . '\'');

            // Установлена ли скидка
            $cart_cart_rule = Db::getInstance()->getRow('
                SELECT *
                FROM '._DB_PREFIX_.'cart_cart_rule
                WHERE id_cart = '.(int)$cart->id.'
                AND id_cart_rule = '.(int)$cart_rule['id_cart_rule']);
            $price = ToolsBonus::getTotalCartRule(
                (int)$cart_rule['id_cart_rule'],
                $cart,
                $customer
            );
            $date = new DateTime();
            $date->add(new DateInterval('P'.(int)Configuration::get('PS_LOYALTY_DAY').'D'));
            if (!Configuration::get('PS_LOYALTY_TYPE') || (int)$bonus_type_decision == 1 || empty($bonus_type_decision)) {
                //Начисляем
                if ($price > 0) {
                    $bonus = new BonusaccountObj();
                    $bonus->id_customer = (int)$customer->id;
                    $bonus->id_order = (int)$order->id;
                    $bonus->id_cart_rule = (int)$cart_rule['id_cart_rule'];
                    $bonus->points = $price;
                    $bonus->comment = pSQL($this->trans('Points per order', [], 'Modules.Psbonussystem.Admin'));
                    $bonus->status = 1;
                    $bonus->paid = 0;
                    $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                    $bonus->type = pSQL('order');
                    $bonus->save();
                    if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                        $info_bonus_order = '';
                        $info_bonus_order .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('Points per order').' ';
                        $info_bonus_order .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                            $price,
                            (int)Configuration::get('PS_CURRENCY_DEFAULT')
                        ).' ';
                        $info_bonus_order .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').'</strong></span> '.$date->format('Y-m-d H:i:s').' ';
                        $this->emailSend($info_bonus_order, $customer);
                    }
                }
            }

            if (!Configuration::get('PS_LOYALTY_TYPE') || (int)$bonus_type_decision == 2) {
                //Списываем
                if ($cart_cart_rule) {
                    $bonus = new BonusaccountObj();
                    $bonus->id_customer = (int)$customer->id;
                    $bonus->id_order = (int)$order->id;
                    $bonus->id_cart_rule = (int)$cart_rule['id_cart_rule'];
                    $bonus->points = pSQL($cart_rule['reduction_amount']);
                    $bonus->comment = pSQL($this->trans('Order payment', [], 'Modules.Psbonussystem.Admin'));
                    $bonus->status = 2;
                    $bonus->paid = 1;
                    $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                    $bonus->type = pSQL('order');
                    $bonus->save();
                }
            }
            if ($cart_rule['id_cart_rule']) {
                $cartrule = new CartRule((int)$cart_rule['id_cart_rule']);
                $cartrule->reduction_amount = 0.1;
                $cartrule->active = 0;
                $cartrule->update();
            }

            $total_orders = $customer->getStats();

            //Отправляем бонус за первый заказ
            $first_order = Actions::getBonusActions(
                'first_order',
                (int)$this->context->customer->id
            );
            if ((int)$total_orders['nb_orders'] == 0 && $first_order && $first_order['point'] > 0) {
                $date = new DateTime();
                $date->add(new DateInterval('P'.(int)$first_order['many_days'].'D'));
                if ($first_order['point'] > 0) {
                    $bonus = new BonusaccountObj();
                    $bonus->id_customer = (int)$customer->id;
                    $bonus->id_order = (int)$order->id;
                    $bonus->id_cart_rule = 0;
                    $bonus->points = $first_order['point'];
                    $bonus->comment = pSQL($this->trans('First order bonus', [], 'Modules.Psbonussystem.Admin'));
                    $bonus->status = 1;
                    $bonus->paid = 0;
                    $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                    $bonus->type = pSQL('first_order');
                    $bonus->save();
                    if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                        $info_bonus_first_order = '';
                        $info_bonus_first_order .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('First order bonus').' ';
                        $info_bonus_first_order .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                            $first_order['point'],
                            (int)Configuration::get('PS_CURRENCY_DEFAULT')
                        ).' ';
                        $info_bonus_first_order .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').' '.$date->format('Y-m-d H:i:s').' ';
                        $this->emailSend($info_bonus_first_order, $customer);
                    }
                }
            }

            //Начисляем бонусы по реферальной программе если пользователь оплатил заках
            if ((int)$total_orders['nb_orders'] == 0 && $this->context->cookie->is_new_customer) {
                $friend = Actions::getBonusActions(
                    'friend',
                    (int)$customer->id
                );

                if ($friend && $this->context->cookie->id_ref) {
                    $date = new DateTime();
                    $date->add(new DateInterval('P'.(int)$friend['many_days'].'D'));
                    if ($friend['point'] > 0) {
                        $bonus = new BonusaccountObj();
                        $bonus->id_customer = (int)$customer->id;
                        $bonus->id_order = (int)$order->id;
                        $bonus->id_cart_rule = 0;
                        $bonus->points = $friend['point'];
                        $bonus->comment = pSQL($this->trans('First order (referral program)', [], 'Modules.Psbonussystem.Admin'));
                        $bonus->status = 1;
                        $bonus->paid = 0;
                        $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                        $bonus->type = pSQL('friend');

                        $bonus->save();
                        if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                            $info_bonus = '';
                            $info_bonus .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('First order (referral program)', [], 'Modules.Psbonussystem.Admin').' ';
                            $info_bonus .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                                $friend['point'],
                                (int)Configuration::get('PS_CURRENCY_DEFAULT')
                            ).' ';
                            $info_bonus .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').' '.$date->format('Y-m-d H:i:s');
                            $this->emailSend($info_bonus, $customer);
                        }
                    }

                    if ($friend['point_self'] > 0) {
                        // Начисляем спонсору
                        $bonus_ref = new BonusaccountObj();
                        $bonus_ref->id_customer = (int)$this->context->cookie->id_ref;
                        $bonus_ref->id_order = (int)$order->id;
                        $bonus_ref->id_cart_rule = 0;
                        $bonus_ref->points = $friend['point_self'];
                        $bonus_ref->comment = pSQL($this->trans('Referral program', [], 'Modules.Psbonussystem.Admin'));
                        $bonus_ref->status = 1;
                        $bonus_ref->paid = 0;
                        $bonus_ref->date_bonus_to = $date->format('Y-m-d H:i:s');
                        $bonus_ref->type = pSQL('friend');
                        $bonus_ref->save();
                        if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                            $customer_ref = new Customer((int)$this->context->cookie->id_ref);
                            $info_bonus_ref = '';
                            $info_bonus_ref .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('Referral program', [], 'Modules.Psbonussystem.Admin').' ';
                            $info_bonus_ref .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                                $friend['point_self'],
                                (int)Configuration::get('PS_CURRENCY_DEFAULT')
                            ).' ';
                            $info_bonus_ref .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').' '.$date->format('Y-m-d H:i:s').' ';
                            $this->emailSend($info_bonus_ref, $customer_ref);
                        }
                    }
                }
            }
            $this->context->cookie->id_ref = false;
        }
    }

    public function hookactionCartSave()
    {
        if (!$this->active ||
        !Validate::isLoadedObject($this->context->cart) ||
        !Tools::getIsset('id_product') ||
        !$this->context->customer->isLogged()
        ) {
            return;
        }
        ToolsBonus::resetCartRule();
    }

    public function hookModuleRoutes()
    {
        $routes = array();
        $routes['module-psbonussystem-ajax'] = array(
            'controller' => 'ajax',
            'rule' => 'ajax/',
            'keywords' => array(
            ),
            'params' => array(
                'fc' => 'module',
                'module' => 'psbonussystem'
            )
        );
        $routes['module-psbonussystem-bonusaccount'] = array(
            'controller' => 'bonusaccount',
            'rule' => 'bonus/',
            'keywords' => array(
            ),
            'params' => array(
                'fc' => 'module',
                'module' => 'psbonussystem'
            )
        );

        $routes['module-psbonussystem-cron'] = array(
            'controller' => 'cron',
            'rule' => 'bonus-cron/',
            'keywords' => array(
            ),
            'params' => array(
                'fc' => 'module',
                'module' => 'psbonussystem',
            )
        );

        return $routes;
    }

    public function hookactionObjectCustomerAddAfter(array $params)
    {
        if (empty($params['object'])) {
            return;
        }
        $action = Actions::getBonusActions(
            'registration',
            (int)$params['object']->id
        );
        if ((int)$params['object']->id > 0 && $action) {
            $exist = Db::getInstance()->getValue('
                SELECT id_bonusaccount
                FROM '._DB_PREFIX_.'bonus_account
                WHERE id_customer = '.(int)$params['object']->id);
            if (!$exist) {
                $date = new DateTime();
                $date->add(new DateInterval('P'.(int)$action['many_days'].'D'));
                $bonus = new BonusaccountObj();
                $bonus->id_customer = (int)$params['object']->id;
                $bonus->id_order = (int)0;
                $bonus->id_cart_rule = (int)0;
                $bonus->points = $action['point'];
                $bonus->comment = $this->trans('Registration bonus', [], 'Modules.Psbonussystem.Admin');
                $bonus->status = 1;
                $bonus->paid = 1;
                $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                $bonus->type = pSQL('registration');
                $bonus->save();
                if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                    $info_bonus = '';
                    $info_bonus .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('Registration bonus', [], 'Modules.Psbonussystem.Admin').' ';
                    $info_bonus .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                        $action['point'],
                        (int)Configuration::get('PS_CURRENCY_DEFAULT')
                    ).' ';
                    $info_bonus .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').'</strong></span> '.$date->format('Y-m-d H:i:s').' ';
                    $this->emailSend($info_bonus, $params['object']);
                }
            }
        }

        if (isset($params['object']->newsletter) && $params['object']->newsletter) {
            $action = Actions::getBonusActions(
                'newsletter',
                (int)$params['object']->id
            );
            if ($action) {
                $date = new DateTime();
                $date->add(new DateInterval('P'.(int)$action['many_days'].'D'));
                $bonus = new BonusaccountObj();
                $bonus->id_customer = (int)$params['object']->id;
                $bonus->id_order = (int)0;
                $bonus->id_cart_rule = (int)0;
                $bonus->points = $action['point'];
                $bonus->comment = $this->trans('Subscribe to newsletter', [], 'Modules.Psbonussystem.Admin');
                $bonus->status = 1;
                $bonus->paid = 1;
                $bonus->type = pSQL('newsletter');
                $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                $bonus->save();
                if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                    $info_bonus = '';
                    $info_bonus .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('Subscribe to newsletter', [], 'Modules.Psbonussystem.Admin').' ';
                    $info_bonus .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                        $action['point'],
                        (int)Configuration::get('PS_CURRENCY_DEFAULT')
                    ).' ';
                    $info_bonus .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').' '.$date->format('Y-m-d H:i:s').' ';
                    $this->emailSend($info_bonus, $params['object']);
                }
            }
        }
        $this->context->cookie->is_new_customer = true;
    }

    public function hookActionObjectCustomerUpdateBefore($params)
    {
        if (isset($params['object']->newsletter) && $params['object']->newsletter) {
            $action = Actions::getBonusActions(
                'newsletter',
                (int)$params['object']->id
            );
            if ($action) {
                $date = new DateTime();
                $date->add(new DateInterval('P'.(int)$action['many_days'].'D'));
                $bonus = new BonusaccountObj();
                $bonus->id_customer = (int)$params['object']->id;
                $bonus->id_order = (int)0;
                $bonus->id_cart_rule = (int)0;
                $bonus->points = $action['point'];
                $bonus->comment = $this->trans('Subscribe to newsletter', [], 'Modules.Psbonussystem.Admin');
                $bonus->status = 1;
                $bonus->paid = 1;
                $bonus->type = pSQL('newsletter');
                $bonus->date_bonus_to = $date->format('Y-m-d H:i:s');
                $bonus->save();
                if (Configuration::get('PS_LOYALTY_BONUS_EMAIL_SEND')) {
                    $info_bonus = '';
                    $info_bonus .= $this->trans('Bonus type', [], 'Modules.Psbonussystem.Admin').' '.$this->trans('Subscribe to newsletter', [], 'Modules.Psbonussystem.Admin').' ';
                    $info_bonus .= $this->trans('Accrued', [], 'Modules.Psbonussystem.Admin').' '.Tools::displayPrice(
                        $action['point'],
                        (int)Configuration::get('PS_CURRENCY_DEFAULT')
                    ).' ';
                    $info_bonus .= $this->trans('Valid until', [], 'Modules.Psbonussystem.Admin').' '.$date->format('Y-m-d H:i:s').' ';
                    $this->emailSend($info_bonus, $params['object']);
                }
            }
        }
    }

    public function emailSend($info_bonus, $user)
    {
        $language = new Language($this->context->language->id);
        if (!Validate::isLoadedObject($language)) {
            $locale = $language->getLocale();
        } else {
            $locale = $this->context->language->getLocale();
        }
        Mail::Send(
            $this->context->language->id,
            'psbonussystem_mail',
            $this->trans('Bonus system', [], 'Emails.Subject', $locale),
            array(
                '{info_bonus}' => $info_bonus,
                '{info_bonus_title}' => $user->firstname .' '. $user->lastname.' '. $this->trans('you have received bonuses', [], 'Modules.Psbonussystem.Admin'),
            ),
            $user->email,
            null,
            null,
            null,
            null,
            null,
            dirname(__FILE__).'/mails/',
            null,
            (int)$this->context->shop->id
        );
    }

    public function getDashboardModule()
    {
        $modules = json_decode(Tools::file_get_contents('https://ewonta.com/apiaddons?module_key='.$this->module_key), true);
        foreach ($modules as $key => $module) {
            if ($this->isInstalled($module['nameaddons'])) {
                unset($modules[$key]);
            }
        }

        $this->context->smarty->assign(
            array(
                'modules' => $modules,
            )
        );
    }

    public function isUsingNewTranslationSystem()
    {
        return true;
    }
}
