<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

$sql = array();
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_account` (
    `id_bonusaccount` int(11) NOT NULL AUTO_INCREMENT,
    `id_customer` int(10) unsigned NOT NULL,
	`id_order` int(10) unsigned NOT NULL,
	`id_cart_rule` int(10) unsigned NOT NULL,
	`points` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
	`comment` text NOT NULL,
	`status` int(10) unsigned NOT NULL,
	`paid` TINYINT(1) UNSIGNED NOT NULL DEFAULT \'0\',
    `type` VARCHAR( 20 ) NOT NULL,
	`date_add` DATETIME NULL,
    `date_bonus_to` datetime NOT NULL,
	PRIMARY KEY  (`id_bonusaccount`),
    INDEX (`id_bonusaccount`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_levels` (
    `id_bonuslevels` int(11) NOT NULL AUTO_INCREMENT,
	`return` INT(11) UNSIGNED NOT NULL,
    `min_range` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
	`max_range` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
	PRIMARY KEY  (`id_bonuslevels`),
	INDEX (`id_bonuslevels`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_levels_lang` (
    `id_bonuslevels` INT(11) UNSIGNED NOT NULL,  
    `id_lang` INT(11) UNSIGNED NOT NULL,
    `name` VARCHAR( 255 ) NOT NULL,
	`description` text NOT NULL,
    PRIMARY KEY(`id_bonuslevels` , `id_lang`),
    INDEX ( `id_bonuslevels` , `id_lang`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_actions` (
    `id_bonusactions` int(11) NOT NULL AUTO_INCREMENT,
    `type` VARCHAR( 20 ) NOT NULL,
	`point` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
    `point_self` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
    `status` TINYINT(1) NOT NULL,
    `many_days` int(10) unsigned NOT NULL,
    `date_from` datetime NOT NULL,
    `date_to` datetime NOT NULL,
	PRIMARY KEY  (`id_bonusactions`),
	INDEX (`id_bonusactions`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_increased` (
    `id_increased` int(11) NOT NULL AUTO_INCREMENT,
    `increased` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
    `id_product` int(10) unsigned NOT NULL DEFAULT \'0\',
    `id_category` int(10) unsigned NOT NULL DEFAULT \'0\',
    `status` TINYINT(1) NOT NULL,
    `date_from` datetime NOT NULL,
    `date_to` datetime NOT NULL,
    PRIMARY KEY  (`id_increased`, `id_product`, `id_category`),
    INDEX (`id_increased`, `id_product`, `id_category`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_type_cart` (
    `id_cart` int(10) unsigned NOT NULL DEFAULT \'0\',
    `id_customer` int(10) unsigned NOT NULL DEFAULT \'0\',
    `type` TINYINT(1) UNSIGNED NOT NULL DEFAULT \'1\',
    PRIMARY KEY  (`id_cart`, `id_customer`),
    INDEX (`id_cart`, `id_customer`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_accrual` (
    `id_accrual` int(11) NOT NULL AUTO_INCREMENT,
    `id_object` INT(11) UNSIGNED NOT NULL,
    `type` VARCHAR( 20 ) NOT NULL,
    `increased` decimal(20,6) NOT NULL DEFAULT \'0.000000\',
    PRIMARY KEY  (`id_accrual`, `id_object`, `type`),
    INDEX (`id_accrual`, `id_object`, `type`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
foreach ($sql as $query) {
    if (Db::getInstance()->execute($query) == false) {
        return false;
    }
}
