<?php
/**
 * Since 2015 Ewonta
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author     Ewonta <support@ewonta.ru>
 *  @copyright  Since 2015 Ewonta
 *  @license    Valid for 1 website (or project) for each purchase of license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_2_3_0($module)
{
    if (!$module->registerHook('displayProductPriceBlock')) {
        return false;
    }

    if (!Configuration::updateValue('PS_LOYALTY_SHOW_PRICE', true)
        || !Configuration::updateValue('PS_LOYALTY_SHOW_ONE_PRODUCE_INFO', true)) {
        return false;
    }

    if (!Tab::getIdFromClassName('AdminPsbonusSystemIncreased')) {
        $languages = Language::getLanguages();
        $newtab = new Tab();
        $newtab->class_name = 'AdminPsbonusSystemIncreased';
        $newtab->id_parent = (int)Tab::getIdFromClassName('AdminImPsbonusSystem');
        $newtab->module = 'psbonussystem';
        foreach ($languages as $l) {
            $newtab->name[$l['id_lang']] = $module->l('Increased Cash Back', 'psbonussystem');
        }
        $newtab->save();
    }

    $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bonus_increased` (
        `id_increased` int(11) NOT NULL AUTO_INCREMENT,
        `increased` INT(11) UNSIGNED NOT NULL,
        `id_product` int(10) unsigned NOT NULL DEFAULT \'0\',
        `id_category` int(10) unsigned NOT NULL DEFAULT \'0\',
        `status` TINYINT(1) NOT NULL,
        `date_from` datetime NOT NULL,
        `date_to` datetime NOT NULL,
        PRIMARY KEY  (`id_increased`, `id_product`, `id_category`),
        INDEX (`id_increased`, `id_product`, `id_category`)
    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
    if (!DB::getInstance()->execute($sql)) {
        return false;
    }

    return true;
}
