<?php
/**
 * 2007-2020 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2020 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class CheckoutPersonalInformationStep extends CheckoutPersonalInformationStepCore
{
    /*
    * module: kbmobilelogin
    * date: 2024-04-15 12:59:54
    * version: 2.0.5
    */
    public function handleRequest(array $requestParameters = array())
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        if ($module_setting['enable']) {
            if ($module_setting['login_by_mobile']) {
                $kblastemailvalue = Tools::getValue('email');
                if (!Validate::isEmail($kblastemailvalue)) {
                    $selectSql = 'SELECT * FROM `' . _DB_PREFIX_ . 'kbmobile_user_detail` WHERE mobilenumber = "' . pSQL($kblastemailvalue) . '" AND customer_id is not null AND customer_id != "" ';
                    if ($module_setting['login_mobile_verified']) {
                        $selectSql .= ' and verified = 1 ';
                    }
                    $mobilenumber_exist = Db::getInstance()->getRow($selectSql);
                    /**
                     * If mobile number exist then get email from customer table else create a temp email as per module setting email format
                     * @date 23-03-2023
                     * @commenter Prvind Panday
                     */
                    if ($mobilenumber_exist) {
                        $customer_id = $mobilenumber_exist['customer_id'];
                        $customer = new Customer($customer_id);
                        $requestParameters['email'] = $customer->email;
                    } else {
                        $requestParameters['email'] = uniqid('unknown_') . $module_setting['temp_email_format'];
                    }
                }
            }
        }
        parent::handleRequest($requestParameters);
    }
}
