<?php
/**
 * 2007-2020 ETS-Soft
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please contact us for extra customization service at an affordable price
 *
 * @author ETS-Soft <etssoft.jsc@gmail.com>
 * @copyright  2007-2020 ETS-Soft
 * @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of ETS-Soft
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class CustomerLoginForm extends CustomerLoginFormCore
{
    /*
    * module: kbmobilelogin
    * date: 2020-07-07 15:25:33
    * version: 1.0.3
    */
    /*
    * module: kbmobilelogin
    * date: 2024-04-15 12:59:54
    * version: 2.0.5
    */
    public function submit()
    {
        $module_setting = json_decode(Configuration::get('KB_MOBILE_LOGIN'), true);
        /**
         * $this->validate() is called only if the module is enabled and login by mobile is disabled else it will return true
         * @date 23-03-2023
         * @commenter Prvind Panday
         */
        if ($module_setting['enable']) {
            if ($module_setting['login_by_mobile']) {
                $kb_validate = 1;
            } else {
                $kb_validate = $this->validate();
            }
        } else {
            $kb_validate = $this->validate();
        }
        if ($kb_validate) {
            
            Hook::exec('actionAuthenticationBefore');
        
            $customer = new Customer();
            $authentication = $customer->getByEmail(
                $this->getValue('email'),
                $this->getValue('password')
            );
            /**
             * Check if customer is active and he can log in. If not, display error message.
             * @date 23-03-2023
             * @commenter Prvind Panday
             */
            if (isset($authentication->active) && !$authentication->active) {
                $this->errors[''][] = $this->translator->trans('Your account isn\'t available at this time, please contact us', [], 'Shop.Notifications.Error');
            } elseif (!$authentication || !$customer->id || $customer->is_guest) {
                $this->errors[''][] = $this->translator->trans('Authentication failed.', [], 'Shop.Notifications.Error');
            } else {
                Context::getContext()->updateCustomer($customer);
                Hook::exec('actionAuthentication', ['customer' => Context::getContext()->customer]);
                CartRule::autoRemoveFromCart(Context::getContext());
                CartRule::autoAddToCart(Context::getContext());
            }
        }
        return !$this->hasErrors();
    }
}
