<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A Box Shadow set of controls
 *
 * @param array  $default    {
 *         @type integer $horizontal Default 0
 *         @type integer $vertical   Default 0
 *         @type integer $blur       Default 10
 *         @type integer $spread     Default 0
 *         @type bool    $inset      Unused //TODO: allow set an inset shadow
 *         @type string  $color      Shadow color, in rgb|rgba|hex format.
 * }
 *
 * @since 1.0.0
 */
class ControlBoxShadow extends ControlBaseMultiple
{
    public function getType()
    {
        return 'box_shadow';
    }

    public function getDefaultValue()
    {
        return array(
            'horizontal' => 0,
            'vertical' => 0,
            'blur' => 10,
            'spread' => 0,
            'inset' => '',
            'color' => 'rgba(0,0,0,0.5)',
        );
    }

    public static function getSliders()
    {
        return array(
            array('label' => __('Blur', 'elementor'), 'type' => 'blur', 'min' => 0, 'max' => 100),
            array('label' => __('Spread', 'elementor'), 'type' => 'spread', 'min' => 0, 'max' => 100),
            array('label' => __('Horizontal', 'elementor'), 'type' => 'horizontal', 'min' => -100, 'max' => 100),
            array('label' => __('Vertical', 'elementor'), 'type' => 'vertical', 'min' => -100, 'max' => 100),
        );
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlBoxShadow');
    }
}
