<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A group of Radio Buttons controls represented as a stylized component with an icon for each option.
 *
 * @param mixed $default      The selected option key
 *                            Default ''
 * @param array $options      Array of arrays `[ [ 'title' => ??, 'icon' => ?? ], [ 'title' ... ]`.
 *                            The icon can be any icon-font class that appears in the panel, e.g. 'fa fa-align-left' for Font Awesome
 * @param bool  $toggle       Whether to allow toggle the selected button (unset the selection)
 *                            Default true
 *
 * @since 1.0.0
 */
class ControlChoose extends ControlBase
{
    public function getType()
    {
        return 'choose';
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlChoose');
    }

    protected function getDefaultSettings()
    {
        return array(
            'options' => array(),
            'label_block' => true,
            'toggle' => true,
        );
    }
}
