<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A font select box control. The list is based on Google Fonts project (@see https://fonts.google.com/)
 *
 * @param string $default   The selected font name
 *                          Default empty
 * @param array $fonts      All available fonts
 *                          Default @see Fonts::getFonts()
 *
 * @since 1.0.0
 */
class ControlFont extends ControlBase
{
    public function getType()
    {
        return 'font';
    }

    protected function getDefaultSettings()
    {
        return array(
            'fonts' => Fonts::getFonts(),
        );
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlFont');
    }
}
