<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

/**
 * A UI only control. Show HTML markup between controls
 *
 * @param string $raw     The HTML markup
 *                        Default empty
 * @param string $classes Additional classes for the HTML wrapper
 *                        Default empty
 *
 * @since 1.0.0
 */
class ControlRawHtml extends ControlBase
{
    public function getType()
    {
        return 'raw_html';
    }

    public function contentTemplate()
    {
        \CESmarty::write(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ControlRawHtml');
    }

    public function getDefaultSettings()
    {
        return array(
            'classes' => '',
        );
    }
}
