<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks, Elementor
 * @copyright 2019-2020 WebshopWorks.com & Elementor.com
 * @license   https://www.gnu.org/licenses/gpl-3.0.html
 */

namespace CE;

defined('_PS_VERSION_') or die;

class ElementsManager
{
    /**
     * @var ElementBase[]
     */
    private $_element_types;

    private $_categories;

    public function __construct()
    {
        $this->requireFiles();

        add_action('wp_ajax_elementor_save_builder', array($this, 'ajax_save_builder'));
    }

    /**
     * @param array $element_data
     *
     * @return ElementBase
     */
    public function createElementInstance(array $element_data)
    {
        $args = array();

        if ('widget' === $element_data['elType']) {
            $element_type = Plugin::instance()->widgets_manager->getWidgetTypes($element_data['widgetType']);

            if (!$element_type) {
                return null;
            }

            $args = $element_type->getDefaultArgs();
        } else {
            $element_type = $this->getElementTypes($element_data['elType']);
        }

        $element_class = $element_type->getClassName();

        return new $element_class($element_data, $args);
    }

    public function getCategories()
    {
        if (null === $this->_categories) {
            $this->initCategories();
        }

        return $this->_categories;
    }

    public function addCategory($category_name, $category_properties, $offset = null)
    {
        if (null === $this->_categories) {
            $this->initCategories();
        }

        if (null === $offset) {
            $this->_categories[$category_name] = $category_properties;
        }

        $this->_categories = array_slice($this->_categories, 0, $offset, true) +
        array($category_name => $category_properties) +
        array_slice($this->_categories, $offset, null, true);
    }

    public function registerElementType(ElementBase $element)
    {
        $this->_element_types[$element->getName()] = $element;

        return true;
    }

    public function unregisterElementType($name)
    {
        if (!isset($this->_element_types[$name])) {
            return false;
        }

        unset($this->_element_types[$name]);

        return true;
    }

    public function getElementTypes($element_name = null)
    {
        if (is_null($this->_element_types)) {
            $this->_initElements();
        }

        if (null !== $element_name) {
            return isset($this->_element_types[$element_name]) ? $this->_element_types[$element_name] : null;
        }

        return $this->_element_types;
    }

    public function getElementTypesConfig()
    {
        $config = array();

        foreach ($this->getElementTypes() as $element) {
            $config[$element->getName()] = $element->getConfig();
        }

        return $config;
    }

    public function renderElementsContent()
    {
        foreach ($this->getElementTypes() as $element_type) {
            $element_type->printTemplate();
        }
    }

    public function ajaxSaveBuilder()
    {
        // if (empty($_POST['_nonce']) || !wp_verify_nonce($_POST['_nonce'], 'elementor-editing')) {
        //     wp_send_json_error('token_expired');
        // }

        if (empty(${'_POST'}['post_id'])) {
            wp_send_json_error('no_post_id');
        }

        if (!User::isCurrentUserCanEdit(${'_POST'}['post_id'])) {
            wp_send_json_error('no_access');
        }

        if (isset(${'_POST'}['status']) && DB::STATUS_DRAFT === ${'_POST'}['status']) {
            $status = DB::STATUS_DRAFT;
        } else {
            $status = DB::STATUS_PUBLISH;
        }

        $posted = json_decode(${'_POST'}['data'], true);

        Plugin::instance()->db->saveEditor(${'_POST'}['post_id'], $posted, $status);

        wp_send_json_success();
    }

    private function _initElements()
    {
        $this->_element_types = array();

        foreach (array('section', 'column') as $element_name) {
            $class_name = __NAMESPACE__ . '\Element' . $element_name;

            $this->registerElementType(new $class_name());
        }

        do_action('elementor/elements/elements_registered');
    }

    private function initCategories()
    {
        $this->_categories = array(
            'basic' => array(
                'title' => __('Basic', 'elementor'),
                'icon' => 'fa fa-font',
            ),
            'general-elements' => array(
                'title' => __('General Elements', 'elementor'),
                'icon' => 'fa fa-font',
            ),
            // 'pojo' => array(
            //     'title' => __('Pojo Themes', 'elementor'),
            //     'icon' => 'fa fa-pojome',
            // ),
            'prestashop' => array(
                'title' => __('PrestaShop', 'elementor'),
                'icon' => 'fa fa-wordpress',
            ),
        );
    }

    private function requireFiles()
    {
        require_once _CE_PATH_ . 'includes/base/element-base.php';

        require _CE_PATH_ . 'includes/elements/column.php';
        require _CE_PATH_ . 'includes/elements/section.php';
        require _CE_PATH_ . 'includes/elements/repeater.php';
    }
}
