<?php
/**
 * Creative Elements - Elementor based PageBuilder
 *
 * @author    WebshopWorks
 * @copyright 2019-2020 WebshopWorks.com
 * @license   One domain support license
 */

namespace CE;

defined('_PS_VERSION_') or die;

class WidgetLayerSlider extends WidgetBase
{
    protected $module;

    public function getName()
    {
        return 'ps-widget-LayerSlider';
    }

    public function getTitle()
    {
        return __('Creative Slider', 'elementor');
    }

    public function getIcon()
    {
        return 'eicon-insert-image';
    }

    public function getCategories()
    {
        return array('general-elements');
    }

    protected function getSliderOptions()
    {
        if (!$this->module) {
            return false;
        }
        $table = _DB_PREFIX_ . 'layerslider';
        $sliders = \Db::getInstance()->executeS(
            "SELECT id, name FROM $table WHERE flag_hidden = 0 AND flag_deleted = 0 LIMIT 100"
        );
        $opts = array(
            '0' => __('- Select Slider -', 'elementor'),
        );
        if (!empty($sliders)) {
            foreach ($sliders as &$slider) {
                $name = empty($slider['name']) ? 'Unnamed' : $slider['name'];
                $opts[$slider['id']] = "#{$slider['id']} - $name";
            }
        }

        return $opts;
    }

    protected function _registerControls()
    {
        $this->startControlsSection(
            'section_layerslider',
            array(
                'label' => __('Creative Slider', 'elementor'),
            )
        );

        if ($this->module) {
            $context = \Context::getContext();
            $lsUrl = empty($context->employee) ? '#' : $context->link->getAdminLink('AdminLayerSlider');

            $this->addControl(
                'ls-new',
                array(
                    'raw' => \CESmarty::get(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ce_ls_new'),
                    'type' => ControlsManager::RAW_HTML,
                )
            );

            $this->addControl(
                'slider',
                array(
                    'classes' => 'ls-selector',
                    'label' => __('Slider', 'elementor'),
                    'type' => ControlsManager::SELECT,
                    'options' => $this->getSliderOptions(),
                    'default' => '0',
                )
            );

            $this->addControl(
                'ls-edit',
                array(
                    'raw' => \CESmarty::get(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ce_ls_edit'),
                    'type' => ControlsManager::RAW_HTML,
                    'separator' => '',
                    'condition' => array(
                        'slider!' => '0',
                    ),
                )
            );
        } else {
            $this->addControl(
                'ls-alert',
                array(
                    'raw' => \CESmarty::get(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ce_ls_alert'),
                    'type' => ControlsManager::RAW_HTML,
                )
            );

            $this->addControl(
                'ls-promo',
                array(
                    'raw' => \CESmarty::get(_CE_TEMPLATES_ . 'admin/controls.tpl', 'ce_ls_promo'),
                    'type' => ControlsManager::RAW_HTML,
                )
            );

            $this->addControl('slider', array('type' => ControlsManager::HIDDEN));
        }

        $this->addControl(
            'view',
            array(
                'label' => __('View', 'elementor'),
                'type' => ControlsManager::HIDDEN,
                'default' => 'traditional',
            )
        );

        $this->endControlsSection();
    }

    protected function render()
    {
        if (!$this->module) {
            return;
        }
        if (is_admin()) {
            return Helper::remoteRender($this->getData());
        }
        $id = (int) $this->getSettings('slider');

        if (!empty($id)) {
            $slider = $this->module->generateSlider($id);

            if (\Tools::getValue('render') == 'widget') {
                $this->patchInitScript($slider, $id);
            }
            echo $slider;
        }
    }

    protected function patchInitScript(&$slider, $id)
    {
        $suffix = '_' . time();
        $slider = str_replace("layerslider_$id", "layerslider_$id$suffix", $slider);

        $slider .= \CESmarty::capture(_CE_TEMPLATES_ . 'admin/widgets.tpl', 'WidgetLayerSlider_initScript', array(
            'id' => $id . $suffix,
        ));
    }

    protected function _contentTemplate()
    {
        if ($this->module) {
            return;
        }

        \CESmarty::write(_CE_TEMPLATES_ . 'admin/widgets.tpl', 'WidgetLayerSlider');
    }

    public function __construct($data = array(), $args = array())
    {
        $ls = \Module::getInstanceByName('layerslider');

        if (!empty($ls->active)) {
            $this->module = $ls;

            $context = \Context::getContext();

            empty($context->employee) or Helper::$body_scripts['ce-layerslider'] = array(
                'l10n' => array(
                    'ls' => array(
                        'url' => $context->link->getAdminLink('AdminLayerSlider'),
                        'NameYourSlider' => __('Name your new slider'),
                        'ChangesYouMadeMayNotBeSaved' => __('Changes you made may not be saved, are you sure you want to close?'),
                    )
                ),
            );
        }
        parent::__construct($data, $args);
    }
}
