<?php
/**
 * Clase en donde se guardan las url y codigo de pago
 */

class EtixpayRecoverPay extends ObjectModel{
    public $id;
    public $id_etixpay;
    public $order_id;
    public $order_stock_restore;
    public $order_stock_discount;
    public $order_status;

    public static $definition = array(
        'table' => _DB_PREFIX_.'etixpay_pay_recover',
        'primary' => 'id',
        'multilang' => false,
        'fields' => array(
            'id' => array('type' => self::TYPE_INT, 'required' => false),
            'order_id' => array('type' => self::TYPE_INT, 'required' => false),
            'order_code' => array('type' => self::TYPE_STRING, 'required' => false),
            'order_url' => array('type' => self::TYPE_STRING, 'required' => true)
        )
    );

    /**
     * Guarda el registro de una oden
     * @param int $orderId
     * @param array $stock
     */
    public static function create($orderId, $order_code, $order_url)
    {

        $db = Db::getInstance();
        $result = $db->execute('
			INSERT INTO `'._DB_PREFIX_.'etixpay_pay_recover`
			( `order_id`, `order_code`, `order_url`)
			VALUES
			("'.intval($orderId).'","'.$order_code.'","'.$order_url.'")');
        return $result;
    }

    public static function ifExist($orderId)
    {
        $sql = 'SELECT COUNT(*) FROM '.EtixpayRecoverPay::$definition['table'].' WHERE order_id ='.$orderId;

        if (\Db::getInstance()->getValue($sql) > 0)
            return true;
        return false;
    }

    public static function getCode($orderId){
        $sql = 'SELECT `order_code` FROM '.EtixpayRecoverPay::$definition['table'].' WHERE order_id ='.$orderId;
        return \Db::getInstance()->getValue($sql);
    }


    public static function updateStockDiscount($orderId)
    {
        $db = Db::getInstance();
        $result = $db->update('etixpay', array('order_stock_discount'=>1), 'order_id = '.(int)$orderId );

        return $result ? true : false;
    }

    /**
     * Crear la tabla en la base de datos.
     * @return true or false
     */
    public static function setup()
    {
        $sql = array();
        $sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'etixpay_pay_recover` (
		    `id` int(11) NOT NULL AUTO_INCREMENT,
		    `id_etixpay` INT(11) NULL,
		    `order_id` INT NULL,
		    `order_code` TEXT NULL,
		    `order_url` TEXT NULL,
		    PRIMARY KEY  (`id`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';

        foreach ($sql as $query) {
            if (Db::getInstance()->execute($query) == false) {
                return false;
            }
        }
    }

    /**
     * Borra la tabla en la base de datos.
     * @return true or false
     */
    public static function remove(){
        $sql = array(
            'DROP TABLE IF EXISTS '._DB_PREFIX_.'etixpay_pay_recover'
        );

        foreach ($sql as $query) {
            if (Db::getInstance()->execute($query) == false) {
                return false;
            }
        }
    }
    public static function verifyPayment($orderId){
        $payCode = self::getCode($orderId);
        $client = new GuzzleHttp\Client(['base_url' => 'https://api.youetix.com']);
        $response = $client->get('/api/v2/etixpay/payments/order/code/'.$payCode);
        $jsonResponse = json_decode($response->getBody()->getContents());
        return $jsonResponse->data->pay_pasarelaESTADO;
    }
}