<?php


class Etixpay_OrderState extends ObjectModel
{

    public static function getOrderStates($ids_only = false)
    {
        global $cookie;

        $returnStates = array();

        $states = OrderState::getOrderStates($cookie->id_lang);

        $id_initial_state = Configuration::get('ETIXPAY_ORDERSTATE_WAITING');

        foreach($states as $k => $state)
        {
            if($ids_only)
            {
                $returnStates[] = $state['id_order_state'];
            }
            else
            {
                $returnStates[] = $state;
            }
        }
        return $returnStates;
    }



    public static function getInitialState()
    {
        return Configuration::get('ETIXPAY_ORDERSTATE_WAITING');
    }


    public static function updateStates($id_initial_state, $delete_on)
    {
        return true;
    }

    public static function setup()
    {
        if (!Configuration::get('ETIXPAY_ORDERSTATE_WAITING'))
        {
            $order_state = new OrderState();
            $order_state->name = array();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento in sospeso';

            $order_state->send_email = false;
            $order_state->color = '#FEFF64';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();
            Configuration::updateValue('ETIXPAY_ORDERSTATE_WAITING', (int)$order_state->id);
        }

        if (!Configuration::get('ETIXPAY_OS_PENDING'))
        {
            $order_state = new OrderState();
            $order_state->name = array();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento in sospeso';

            $order_state->send_email = false;
            $order_state->color = '#FEFF64';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();
            Configuration::updateValue('ETIXPAY_OS_PENDING', (int)$order_state->id);
        }

        if (!Configuration::get('ETIXPAY_OS_FAILED'))
        {
            $order_state = new OrderState();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento non riuscito';
            $order_state->send_email = false;
            $order_state->color = '#8F0621';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();

            Configuration::updateValue('ETIXPAY_OS_FAILED', (int)$order_state->id);
        }

        if (!Configuration::get('ETIXPAY_OS_REJECTED'))
        {
            $order_state = new OrderState();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento rifiutato';
            $order_state->send_email = false;
            $order_state->color = '#8F0621';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();
            Configuration::updateValue('ETIXPAY_OS_REJECTED', (int)$order_state->id);
        }

        if (!Configuration::get('ETIXPAY_OS_EXPIRED'))
        {
            $order_state = new OrderState();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento scaduto';
            $order_state->send_email = false;
            $order_state->color = '#8F0621';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();
            Configuration::updateValue('ETIXPAY_OS_EXPIRED', (int)$order_state->id);
        }

        if (!Configuration::get('ETIXPAY_OS_ABANDONED'))
        {
            $order_state = new OrderState();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento abbandonato';
            $order_state->send_email = false;
            $order_state->color = '#8F0621';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();
            Configuration::updateValue('ETIXPAY_OS_ABANDONED', (int)$order_state->id);
        }

        if (!Configuration::get('ETIXPAY_OS_CANCELED'))
        {
            $order_state = new OrderState();
            foreach (Language::getLanguages() as $language)
                $order_state->name[$language['id_lang']] = 'Etixpay Pagamento annullato';
            $order_state->send_email = false;
            $order_state->color = '#8F0621';
            $order_state->hidden = false;
            $order_state->delivery = false;
            $order_state->logable = false;
            $order_state->invoice = false;
            $order_state->add();
            Configuration::updateValue('ETIXPAY_OS_CANCELED', (int)$order_state->id);
        }
    }

    public static function remove(){

        $statuses = [
            'ETIXPAY_ORDERSTATE_WAITING',
            'ETIXPAY_OS_PENDING',
            'ETIXPAY_OS_FAILED',
            'ETIXPAY_OS_REJECTED',
            'ETIXPAY_OS_EXPIRED',
            'ETIXPAY_OS_ABANDONED',
            'ETIXPAY_OS_CANCELED'
        ];

        foreach ($statuses as $state) {
            self::deleteOrderState((int)Configuration::get($state));
            Configuration::deleteByName($state);
        }
    }

    public static function deleteOrderState($id_order_state) {

        $orderState = new OrderState($id_order_state);
        $orderState->delete();

    }
}

?>