{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @version  Release: $Revision$
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{$count=0}
{foreach from=$productCates item=productCate name=poslistcateproduct}
<div class="poslistcateproduct pos-content poslistcateproduct_{$count} block_product"
		data-items="{$slider_options.number_item}" 
		data-speed="{$slider_options.speed_slide}"
		data-autoplay="{$slider_options.auto_play}"
		data-time="{$slider_options.auto_time}"
		data-arrow="{$slider_options.show_arrow}"
		data-pagination="{$slider_options.show_pagination}"
		data-move="{$slider_options.move}"
		data-pausehover="{$slider_options.pausehover}"
		data-md="{$slider_options.items_md}"
		data-sm="{$slider_options.items_sm}"
		data-xs="{$slider_options.items_xs}"
		data-xxs="{$slider_options.items_xxs}">
	<div class="container">
		<div class="pos_title">		
			<h2>
				{$productCate.category_name}
			</h2>
			{if $configure['show_sub'] && $productCate.list_subcategories}
			<ul class="subcategories-list">
				{foreach from=$productCate.list_subcategories item=subcategories}
					<li><a href="{$link->getCategoryLink($subcategories['id_category'])}" target="_blank">{$subcategories.name}</a></li>
				{/foreach}
			</ul>
			{/if}
		</div>
		<div class="row_edit">
			<div class="top">
				{$j=0}
				{foreach from=$productCate.product item=product name=myLoop}
					<div class="item-product col-md-4">
						 <article class="product-miniature js-product-miniature" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
							<div class="img_block">
							  {block name='product_thumbnail'}
								<a href="{$product.url}" class="thumbnail product-thumbnail">
								  <img
									src = "{$product.cover.bySize.home_default.url}"
									alt = "{if !empty($product.cover.legend)}{$product.cover.legend}{else}{$product.name|truncate:30:'...'}{/if}"
									data-full-size-image-url = "{$product.cover.large.url}"
								  >
								</a>
							  {/block}
							</div>
							<div class="product_desc">
								
								{block name='product_name'}
								  <h3 itemprop="name"><a href="{$product.url}" class="product_name">{$product.name|truncate:40:'...'}</a></h3>
								{/block}
								
								{block name='product_price_and_shipping'}
								  {if $product.show_price}
									<div class="product-price-and-shipping">
									  {if $product.has_discount}
										{hook h='displayProductPriceBlock' product=$product type="old_price"}

										<span class="sr-only">{l s='Regular price' d='Shop.Theme.Catalog'}</span>
										<span class="regular-price">{$product.regular_price}</span>
									  {/if}

									  {hook h='displayProductPriceBlock' product=$product type="before_price"}

									  <span class="sr-only">{l s='Price' d='Shop.Theme.Catalog'}</span>
									  <span itemprop="price" class="price">{$product.price}</span>

									  {hook h='displayProductPriceBlock' product=$product type='unit_price'}

									  {hook h='displayProductPriceBlock' product=$product type='weight'}
									</div>
								  {/if}
								{/block}
								
								
								{block name='product_description_short'}
									<div class="product-desc" itemprop="description">{$product.description_short nofilter}</div>
								{/block}
								
								{block name='product_variants'}
								{if $product.main_variants}
								{include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
								{/if}
								{/block}
							</div>
						  </article>							
					</div>									
				{$j = $j+1}  
				{if $j == 3}{break}{/if}
			{/foreach}
			</div>
			<div class="row">
			<div class="listcateSlide owl-carousel ">
				{foreach from=$productCate.product item=product name=myLoop}					
					{if $smarty.foreach.myLoop.index % $slider_options.rows == 0 || $smarty.foreach.myLoop.first }
					<div class="item-product">
					{/if}
						{include file="catalog/_partials/miniatures/product.tpl" product=$product}
					{if $smarty.foreach.myLoop.iteration %  $slider_options.rows == 0 || $smarty.foreach.myLoop.last}
						</div>
					{/if}
				{/foreach}	
	
			</div>
			</div>
		
		</div>
	</div>
	<script type="text/javascript">
		$(document).ready(function() {
			var listcateSlide = $(".poslistcateproduct .listcateSlide ");
			listcateSlide.owlCarousel({
				autoPlay : autoPlay ,
				smartSpeed: speed,
				autoplayHoverPause: pausehover,
				nav: arrow,
				dots : pagination,	
				responsive:{
					0:{
						items:1,
					},
					480:{
						items:1,
					},
					768:{
						items:2,
						nav:false,
					},
					992:{
						items:3,
					},
					1200:{
						items:5,
					}
				}
			});
		});
	</script>
			
</div>
{$count= $count+1}
{/foreach}


